/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.util;

import com.google.gson.JsonObject;
import com.mistrx.prefabricated_structures.PrefabricatedStructures;
import com.mistrx.prefabricated_structures.firebase.Firebase;
import com.mistrx.prefabricated_structures.util.AllBlocksArray;
import com.mistrx.prefabricated_structures.util.Variables;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class Functions {
    public static Integer[] pasteBlockBlackListArray = new Integer[0];
    public static ArrayList<Integer> pasteBlockBlackList = new ArrayList<Integer>(Arrays.asList(pasteBlockBlackListArray));
    public static String[] blockDataBlacklist = new String[]{"level=0", "snowy=false", "waterlogged=true"};
    public static int newerBlocksAmountFound = 0;
    public static Integer i = 0;
    public static ArrayList<BlockPos> observerBlockPos = new ArrayList();
    public static ArrayList<BlockState> observerBlockStates = new ArrayList();
    public static Boolean uuidMessageSent = false;
    public static HashMap<String, String> blockEqualsItemHashmap = new HashMap();
    static Vector3d lastBlockPlacePos;
    static Vector3d firstBlockPlacePos;
    public static boolean hasFoundOldNBT;
    public static List<String> buildsWithOldNBT;

    public static void setPlayerVariables(Player player) {
        Variables.player = player;
        Variables.uuid = player.getStringUUID();
    }

    public static Boolean sendInvalidUUIDMessage(Player player) {
        if (player.getStringUUID().equals("00000000-0000-0000-0000-000000000000") && !uuidMessageSent.booleanValue()) {
            uuidMessageSent = true;
            return true;
        }
        return false;
    }

    public static void setItemEqualsBlockHashmap() {
        Object toAdd = "";
        toAdd = (String)toAdd + "attached_melon_stem=melon_seeds\n";
        toAdd = (String)toAdd + "attached_pumpkin_stem=pumpkin_seeds\n";
        toAdd = (String)toAdd + "melon_stem=melon_seeds\n";
        toAdd = (String)toAdd + "pumpkin_stem=pumpkin_seeds\n";
        toAdd = (String)toAdd + "bamboo_sapling=bamboo\n";
        toAdd = (String)toAdd + "chorus_plant=chorus_fruit\n";
        toAdd = (String)toAdd + "cocoa=cocoa_beans\n";
        toAdd = (String)toAdd + "farmland=dirt\n";
        toAdd = (String)toAdd + "frosted_ice=ice\n";
        toAdd = (String)toAdd + "grass_path=grass\n";
        toAdd = (String)toAdd + "kelp_plant=kelp\n";
        toAdd = (String)toAdd + "moving_piston=piston\n";
        toAdd = (String)toAdd + "redstone_wire=redstone\n";
        toAdd = (String)toAdd + "snow=snowball\n";
        toAdd = (String)toAdd + "sweet_berry_bush=sweet_berries\n";
        toAdd = (String)toAdd + "beetroots=beetroot\n";
        toAdd = (String)toAdd + "potatoes=potato\n";
        toAdd = (String)toAdd + "carrots=carrot\n";
        toAdd = (String)toAdd + "wheat=wheat_seeds\n";
        String[] toAddArray = ((String)toAdd).split("\n");
        for (int i = 0; i < toAddArray.length; ++i) {
            String[] keyAndValue = toAddArray[i].split("=");
            blockEqualsItemHashmap.put("minecraft:" + keyAndValue[0], "minecraft:" + keyAndValue[1]);
        }
    }

    public static String getItemFromBlock(String block) {
        if (blockEqualsItemHashmap.containsKey(block)) {
            return blockEqualsItemHashmap.get(block);
        }
        if (block.contains("wall_")) {
            return block.replace("wall_", "");
        }
        if (block.contains("infested_")) {
            return block.replace("infested_", "");
        }
        if (block.contains("potted_")) {
            return "flower_pot";
        }
        return block;
    }

    public static void addBlockToBlocksInBuild(String block) {
        if (!Variables.blocksInBuild.contains(block = block.replace("minecraft:", "")) && !block.equals("air")) {
            Variables.blocksInBuild.add(block);
        }
    }

    public static String getData(Level world, Vector3d pos) {
        BlockState state = world.getBlockState(new BlockPos((int)pos.x, (int)pos.y, (int)pos.z));
        int length = state.getValues().keySet().toArray().length;
        Object data = "";
        for (int i = 0; i < length; ++i) {
            String thisKey = state.getValues().keySet().toArray()[i].toString();
            thisKey = thisKey.substring(thisKey.indexOf("=") + 1, thisKey.indexOf(",")).toLowerCase();
            String thisValue = state.getValues().values().toArray()[i].toString().toLowerCase();
            String thisData = thisKey + "=" + thisValue;
            boolean isBlacklisted = false;
            for (int j = 0; j < blockDataBlacklist.length; ++j) {
                if (!thisData.contains(blockDataBlacklist[j])) continue;
                isBlacklisted = true;
            }
            if (i == 0) {
                data = (String)data + "[";
            }
            if (i == length - 1) {
                if (isBlacklisted) {
                    if (((String)data).endsWith(",")) {
                        data = ((String)data).substring(0, ((String)data).length() - 1);
                    }
                } else {
                    data = (String)data + thisData;
                }
                data = (String)data + "]";
                continue;
            }
            data = (String)data + thisData + ",";
        }
        if (data == "[]" || ((String)data).equals("") || ((String)data).length() == 2) {
            return null;
        }
        return data;
    }

    public static String getSetblockCommand(Vector3d pos, String blockname, String data, String nbt) {
        int x = Math.toIntExact(Math.round(pos.x));
        int y = Math.toIntExact(Math.round(pos.y));
        int z = Math.toIntExact(Math.round(pos.z));
        if (data == null || data.equals("null") || !data.startsWith("[")) {
            data = "";
        }
        Object command = "";
        command = "_setblocknoresponse " + x + " " + y + " " + z + " " + blockname + data + nbt;
        return command;
    }

    public static String setBuilding(Vector3d pos, String dir, String[] args, Boolean placeBlocksOnFinish) {
        String buildIDinArgs = null;
        String buildArgs = "nopastemodifier";
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (!args[i].equals(Variables.suggestion)) {
                buildIDinArgs = args[i];
                continue;
            }
            buildArgs = args[i];
        }
        String getBuildResponse = null;
        if (buildIDinArgs == null) {
            getBuildResponse = Firebase.getSelectedBuildingID();
        } else {
            getBuildResponse = "success";
            Variables.buildID = buildIDinArgs;
        }
        PrefabricatedStructures.LOGGER.info(getBuildResponse + " sent");
        if (getBuildResponse == "success") {
            PrefabricatedStructures.LOGGER.info("success sent, Firebase.getBuilding executed");
            String getBuildByURLResponse = Firebase.getBuilding(Variables.buildID, placeBlocksOnFinish, pos, dir, buildArgs);
            PrefabricatedStructures.LOGGER.info("After Firebase.getBuilding");
            if (getBuildResponse == "success" && getBuildByURLResponse == "success") {
                return "success";
            }
            if (getBuildByURLResponse == "error-404") {
                return "error-404";
            }
            return "random-error";
        }
        return getBuildResponse;
    }

    public static void addToLastBlocks(Vector3d pos) {
        String blockName = Functions.getBlocknameFromVector(pos);
        if (Functions.getBlockIdByName(blockName) == null) {
            Variables.lastBlockIDs.add(blockName);
        } else {
            Variables.lastBlockIDs.add(Functions.getBlockIdByName(blockName));
        }
        Variables.lastBlockData.add(Functions.getData(Variables.player.getCommandSenderWorld(), pos));
    }

    public static void setBlock(Vector3d currentPos, String placeBlockName, String data, String nbt, String direction, String pasteModifier) {
        String blockName = Functions.getBlocknameFromVector(currentPos);
        if (Functions.includesOldNBT(placeBlockName, nbt) && !hasFoundOldNBT) {
            hasFoundOldNBT = true;
        }
        Functions.addToLastBlocks(currentPos);
        if (pasteModifier.equals(Variables.suggestion)) {
            if (!blockName.equals(placeBlockName) && !placeBlockName.equals("minecraft:air")) {
                if (placeBlockName.equals("minecraft:observer")) {
                    BlockPos blockPos = new BlockPos((int)currentPos.x, (int)currentPos.y, (int)currentPos.z);
                    String rotation = Functions.rotateBlock(data, direction, true);
                    Direction dir = Functions.getDirection(rotation);
                    Level world = Variables.player.getCommandSenderWorld();
                    BlockState observerState = (BlockState)Blocks.OBSERVER.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)dir);
                    observerBlockPos.add(blockPos);
                    observerBlockStates.add(observerState);
                    world.setBlockAndUpdate(blockPos, Blocks.STONE.defaultBlockState());
                } else {
                    String thisData = Functions.rotateBlock(data, direction);
                    String command = Functions.getSetblockCommand(currentPos, placeBlockName, thisData, nbt);
                    try {
                        Variables.player.getCommandSenderWorld().getServer().getCommands().getDispatcher().execute(command, (Object)Variables.player.createCommandSourceStackForNameResolution((ServerLevel)Variables.player.getCommandSenderWorld()));
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (pasteModifier.equals("nopastemodifier") && !blockName.equals(placeBlockName)) {
            if (placeBlockName.equals("minecraft:observer")) {
                BlockPos blockPos = new BlockPos((int)currentPos.x, (int)currentPos.y, (int)currentPos.z);
                String rotation = Functions.rotateBlock(data, direction, true);
                Direction dir = Functions.getDirection(rotation);
                Level world = Variables.player.getCommandSenderWorld();
                BlockState observerState = (BlockState)Blocks.OBSERVER.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)dir);
                observerBlockPos.add(blockPos);
                observerBlockStates.add(observerState);
                world.setBlockAndUpdate(blockPos, Blocks.STONE.defaultBlockState());
            } else {
                String thisData = Functions.rotateBlock(data, direction);
                String command = Functions.getSetblockCommand(currentPos, placeBlockName, thisData, nbt);
                try {
                    Variables.player.getCommandSenderWorld().getServer().getCommands().getDispatcher().execute(command, (Object)Variables.player.createCommandSourceStackForNameResolution((ServerLevel)Variables.player.getCommandSenderWorld()));
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @NotNull
    private static Direction getDirection(String rotation) {
        Direction dir = Direction.SOUTH;
        if (rotation.equals("south")) {
            dir = Direction.SOUTH;
        } else if (rotation.equals("east")) {
            dir = Direction.EAST;
        } else if (rotation.equals("west")) {
            dir = Direction.WEST;
        } else if (rotation.equals("north")) {
            dir = Direction.NORTH;
        } else if (rotation.equals("up")) {
            dir = Direction.UP;
        } else if (rotation.equals("down")) {
            dir = Direction.DOWN;
        }
        return dir;
    }

    public static String pasteCurrentBuilding(Vector3d pos, String direction, String pasteModifier, Boolean undoPaste, Boolean isConstructing) {
        Vector3d size = null;
        ArrayList<Object> ids = null;
        ArrayList<String> data = null;
        JsonObject nbt = null;
        newerBlocksAmountFound = 0;
        hasFoundOldNBT = false;
        if (!undoPaste.booleanValue()) {
            size = Firebase.size;
            ids = new ArrayList<Object>(Firebase.blockIDs);
            data = new ArrayList<String>(Firebase.blockData);
            nbt = Firebase.blockNBT;
        } else {
            size = Firebase.size;
            ids = new ArrayList<Object>(Variables.lastBlockIDs);
            data = new ArrayList<String>(Variables.lastBlockData);
            nbt = Variables.lastNBT;
        }
        Variables.lastPos = pos;
        Variables.lastPasteDirection = direction;
        Variables.lastBlockSize = Firebase.size;
        Variables.lastBlockIDs = new ArrayList<Object>();
        Variables.lastBlockData = new ArrayList<String>();
        Variables.lastNBT = nbt;
        HashMap<Object, Integer> usedMaterials = new HashMap<Object, Integer>();
        Variables.blocksInBuild = new ArrayList();
        i = 0;
        if (Firebase.uploadDirection.equals("north") || Firebase.uploadDirection.equals("south")) {
            if (Objects.equals(direction, "north")) {
                for (x = size.x; x > 0.0; x -= 1.0) {
                    for (y = 0.0; y < size.y; y += 1.0) {
                        for (z = size.z; z > 0.0; z -= 1.0) {
                            currentPos = new Vector3d(pos.x + x, pos.y + y, pos.z + z - size.z);
                            block = Functions.getBlockByIdOrName(ids.get(i).toString());
                            nbtData = "";
                            if (nbt.has(i.toString())) {
                                nbtData = nbt.get(i.toString()).getAsString();
                            }
                            Functions.addBlockToBlocksInBuild(block);
                            if (isConstructing.booleanValue()) {
                                itemFromBlock = Functions.getItemFromBlock(block);
                                if (Variables.playerItems.containsKey(itemFromBlock)) {
                                    if (Variables.playerItems.get(itemFromBlock) > 0) {
                                        Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                                        Variables.playerItems.merge((String)itemFromBlock, -1, Integer::sum);
                                        usedMaterials.merge(itemFromBlock, 1, Integer::sum);
                                    } else {
                                        Functions.addToLastBlocks(currentPos);
                                    }
                                } else {
                                    Functions.addToLastBlocks(currentPos);
                                }
                            } else {
                                Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                            }
                            itemFromBlock = i;
                            i = i + 1;
                        }
                    }
                }
            } else if (Objects.equals(direction, "south")) {
                for (x = 0.0; x < size.x; x += 1.0) {
                    for (y = 0.0; y < size.y; y += 1.0) {
                        for (z = 0.0; z < size.z; z += 1.0) {
                            currentPos = new Vector3d(pos.x + x - size.x, pos.y + y, pos.z + z);
                            block = Functions.getBlockByIdOrName(ids.get(i).toString());
                            nbtData = "";
                            if (nbt.has(i.toString())) {
                                nbtData = nbt.get(i.toString()).getAsString();
                            }
                            Functions.addBlockToBlocksInBuild(block);
                            if (isConstructing.booleanValue()) {
                                itemFromBlock = Functions.getItemFromBlock(block);
                                if (Variables.playerItems.containsKey(itemFromBlock)) {
                                    if (Variables.playerItems.get(itemFromBlock) > 0) {
                                        Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                                        Variables.playerItems.merge((String)itemFromBlock, -1, Integer::sum);
                                        usedMaterials.merge(itemFromBlock, 1, Integer::sum);
                                    } else {
                                        Functions.addToLastBlocks(currentPos);
                                    }
                                } else {
                                    Functions.addToLastBlocks(currentPos);
                                }
                            } else {
                                Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                            }
                            itemFromBlock = i;
                            i = i + 1;
                        }
                    }
                }
            } else if (Objects.equals(direction, "east")) {
                for (x = size.x; x > 0.0; x -= 1.0) {
                    for (y = 0.0; y < size.y; y += 1.0) {
                        for (z = 0.0; z < size.z; z += 1.0) {
                            currentPos = new Vector3d(pos.x + z, pos.y + y, pos.z + x);
                            block = Functions.getBlockByIdOrName(ids.get(i).toString());
                            nbtData = "";
                            if (nbt.has(i.toString())) {
                                nbtData = nbt.get(i.toString()).getAsString();
                            }
                            Functions.addBlockToBlocksInBuild(block);
                            if (isConstructing.booleanValue()) {
                                itemFromBlock = Functions.getItemFromBlock(block);
                                if (Variables.playerItems.containsKey(itemFromBlock)) {
                                    if (Variables.playerItems.get(itemFromBlock) > 0) {
                                        Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                                        Variables.playerItems.merge((String)itemFromBlock, -1, Integer::sum);
                                        usedMaterials.merge(itemFromBlock, 1, Integer::sum);
                                    } else {
                                        Functions.addToLastBlocks(currentPos);
                                    }
                                } else {
                                    Functions.addToLastBlocks(currentPos);
                                }
                            } else {
                                Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                            }
                            itemFromBlock = i;
                            i = i + 1;
                        }
                    }
                }
            } else if (Objects.equals(direction, "west")) {
                for (x = 0.0; x < size.x; x += 1.0) {
                    for (y = 0.0; y < size.y; y += 1.0) {
                        for (z = size.z; z > 0.0; z -= 1.0) {
                            currentPos = new Vector3d(pos.x + z - size.z, pos.y + y, pos.z + x - size.x);
                            block = Functions.getBlockByIdOrName(ids.get(i).toString());
                            nbtData = "";
                            if (nbt.has(i.toString())) {
                                nbtData = nbt.get(i.toString()).getAsString();
                            }
                            Functions.addBlockToBlocksInBuild(block);
                            if (isConstructing.booleanValue()) {
                                itemFromBlock = Functions.getItemFromBlock(block);
                                if (Variables.playerItems.containsKey(itemFromBlock)) {
                                    if (Variables.playerItems.get(itemFromBlock) > 0) {
                                        Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                                        Variables.playerItems.merge((String)itemFromBlock, -1, Integer::sum);
                                        usedMaterials.merge(itemFromBlock, 1, Integer::sum);
                                    } else {
                                        Functions.addToLastBlocks(currentPos);
                                    }
                                } else {
                                    Functions.addToLastBlocks(currentPos);
                                }
                            } else {
                                Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                            }
                            itemFromBlock = i;
                            i = i + 1;
                        }
                    }
                }
            }
        } else if (direction.equals("north")) {
            for (x = size.x; x > 0.0; x -= 1.0) {
                for (y = 0.0; y < size.y; y += 1.0) {
                    for (z = size.z; z > 0.0; z -= 1.0) {
                        currentPos = new Vector3d(pos.x + z, pos.y + y, pos.z + x - size.x);
                        block = Functions.getBlockByIdOrName(ids.get(i).toString());
                        nbtData = "";
                        if (nbt.has(i.toString())) {
                            nbtData = nbt.get(i.toString()).getAsString();
                        }
                        Functions.addBlockToBlocksInBuild(block);
                        if (isConstructing.booleanValue()) {
                            itemFromBlock = Functions.getItemFromBlock(block);
                            if (Variables.playerItems.containsKey(itemFromBlock)) {
                                if (Variables.playerItems.get(itemFromBlock) > 0) {
                                    Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                                    Variables.playerItems.merge((String)itemFromBlock, -1, Integer::sum);
                                    usedMaterials.merge(itemFromBlock, 1, Integer::sum);
                                } else {
                                    Functions.addToLastBlocks(currentPos);
                                }
                            } else {
                                Functions.addToLastBlocks(currentPos);
                            }
                        } else {
                            Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                        }
                        itemFromBlock = i;
                        i = i + 1;
                    }
                }
            }
        } else if (direction.equals("south")) {
            for (x = 0.0; x < size.x; x += 1.0) {
                for (y = 0.0; y < size.y; y += 1.0) {
                    for (z = 0.0; z < size.z; z += 1.0) {
                        currentPos = new Vector3d(pos.x + z - size.z, pos.y + y, pos.z + x);
                        block = Functions.getBlockByIdOrName(ids.get(i).toString());
                        nbtData = "";
                        if (nbt.has(i.toString())) {
                            nbtData = nbt.get(i.toString()).getAsString();
                        }
                        Functions.addBlockToBlocksInBuild(block);
                        if (isConstructing.booleanValue()) {
                            itemFromBlock = Functions.getItemFromBlock(block);
                            if (Variables.playerItems.containsKey(itemFromBlock)) {
                                if (Variables.playerItems.get(itemFromBlock) > 0) {
                                    Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                                    Variables.playerItems.merge((String)itemFromBlock, -1, Integer::sum);
                                    usedMaterials.merge(itemFromBlock, 1, Integer::sum);
                                } else {
                                    Functions.addToLastBlocks(currentPos);
                                }
                            } else {
                                Functions.addToLastBlocks(currentPos);
                            }
                        } else {
                            Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                        }
                        itemFromBlock = i;
                        i = i + 1;
                    }
                }
            }
        } else if (direction.equals("east")) {
            for (x = 0.0; x < size.x; x += 1.0) {
                for (y = 0.0; y < size.y; y += 1.0) {
                    for (z = size.z; z > 0.0; z -= 1.0) {
                        currentPos = new Vector3d(pos.x + x, pos.y + y, pos.z + z);
                        block = Functions.getBlockByIdOrName(ids.get(i).toString());
                        nbtData = "";
                        if (nbt.has(i.toString())) {
                            nbtData = nbt.get(i.toString()).getAsString();
                        }
                        Functions.addBlockToBlocksInBuild(block);
                        if (isConstructing.booleanValue()) {
                            itemFromBlock = Functions.getItemFromBlock(block);
                            if (Variables.playerItems.containsKey(itemFromBlock)) {
                                if (Variables.playerItems.get(itemFromBlock) > 0) {
                                    Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                                    Variables.playerItems.merge((String)itemFromBlock, -1, Integer::sum);
                                    usedMaterials.merge(itemFromBlock, 1, Integer::sum);
                                } else {
                                    Functions.addToLastBlocks(currentPos);
                                }
                            } else {
                                Functions.addToLastBlocks(currentPos);
                            }
                        } else {
                            Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                        }
                        itemFromBlock = i;
                        i = i + 1;
                    }
                }
            }
        } else if (direction.equals("west")) {
            for (x = size.x; x > 0.0; x -= 1.0) {
                for (y = 0.0; y < size.y; y += 1.0) {
                    for (z = 0.0; z < size.z; z += 1.0) {
                        currentPos = new Vector3d(pos.x + x - size.x, pos.y + y, pos.z + z - size.z);
                        block = Functions.getBlockByIdOrName(ids.get(i).toString());
                        nbtData = "";
                        if (nbt.has(i.toString())) {
                            nbtData = nbt.get(i.toString()).getAsString();
                        }
                        Functions.addBlockToBlocksInBuild(block);
                        if (isConstructing.booleanValue()) {
                            itemFromBlock = Functions.getItemFromBlock(block);
                            if (Variables.playerItems.containsKey(itemFromBlock)) {
                                if (Variables.playerItems.get(itemFromBlock) > 0) {
                                    Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                                    Variables.playerItems.merge((String)itemFromBlock, -1, Integer::sum);
                                    usedMaterials.merge(itemFromBlock, 1, Integer::sum);
                                } else {
                                    Functions.addToLastBlocks(currentPos);
                                }
                            } else {
                                Functions.addToLastBlocks(currentPos);
                            }
                        } else {
                            Functions.setBlock(currentPos, block, (String)data.get(i), nbtData, direction, pasteModifier);
                        }
                        Integer n = i;
                        i = i + 1;
                    }
                }
            }
        }
        final Level world = Variables.player.getCommandSenderWorld();
        if (observerBlockPos.size() != 0) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    for (int j = 0; j < observerBlockPos.size(); ++j) {
                        world.setBlockAndUpdate(observerBlockPos.get(j), (BlockState)observerBlockStates.get(j).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
                    }
                    observerBlockPos = new ArrayList();
                    observerBlockStates = new ArrayList();
                }
            }, 1L);
        }
        if (isConstructing.booleanValue()) {
            for (String item : usedMaterials.keySet()) {
                Integer amount = (Integer)usedMaterials.get(item);
                String command = "_clearnoresponse " + Variables.player.getName().getString() + " " + item + " " + amount.toString();
                try {
                    Variables.player.getCommandSenderWorld().getServer().getCommands().getDispatcher().execute(command, (Object)Variables.player.createCommandSourceStackForNameResolution((ServerLevel)Variables.player.getCommandSenderWorld()));
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        Vector3d adjustedSize = size;
        if (Firebase.uploadDirection.equals("east") || Firebase.uploadDirection.equals("west")) {
            adjustedSize = new Vector3d(size.z, size.y, size.x);
        }
        if (direction.equals("north")) {
            firstBlockPlacePos = new Vector3d(Variables.lastPos.x + 1.0, Variables.lastPos.y, Variables.lastPos.z);
            lastBlockPlacePos = Functions.getLastSecondPos(firstBlockPlacePos, adjustedSize, new Vector3d(1.0, 1.0, -1.0));
        } else if (direction.equals("east")) {
            Vector3d modifiedSize = new Vector3d(adjustedSize.z, adjustedSize.y, adjustedSize.x);
            firstBlockPlacePos = new Vector3d(Variables.lastPos.x, Variables.lastPos.y, Variables.lastPos.z + 1.0);
            lastBlockPlacePos = Functions.getLastSecondPos(firstBlockPlacePos, modifiedSize, new Vector3d(1.0, 1.0, 1.0));
        } else if (direction.equals("south")) {
            firstBlockPlacePos = new Vector3d(Variables.lastPos.x - 1.0, Variables.lastPos.y, Variables.lastPos.z);
            lastBlockPlacePos = Functions.getLastSecondPos(firstBlockPlacePos, adjustedSize, new Vector3d(-1.0, 1.0, 1.0));
        } else if (direction.equals("west")) {
            Vector3d modifiedSize = new Vector3d(adjustedSize.z, adjustedSize.y, adjustedSize.x);
            firstBlockPlacePos = new Vector3d(Variables.lastPos.x, Variables.lastPos.y, Variables.lastPos.z - 1.0);
            lastBlockPlacePos = Functions.getLastSecondPos(firstBlockPlacePos, modifiedSize, new Vector3d(-1.0, 1.0, -1.0));
        }
        Variables.lastFirstPos = firstBlockPlacePos;
        Variables.lastSecondPos = lastBlockPlacePos;
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (hasFoundOldNBT && !buildsWithOldNBT.contains(Variables.buildID)) {
                    assert (Minecraft.getInstance().player != null);
                    MutableComponent oldNbtWarningComponent = Component.translatable((String)"paste.old_nbt");
                    Style style = Style.EMPTY;
                    style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"paste.old_nbt.hover").withStyle(ChatFormatting.WHITE)));
                    oldNbtWarningComponent.setStyle(style);
                    Minecraft.getInstance().player.displayClientMessage((Component)oldNbtWarningComponent, false);
                }
                buildsWithOldNBT.add(Variables.buildID);
            }
        }, 20L);
        return null;
    }

    private static boolean includesOldNBT(String blockId, String nbt) {
        String blockName = blockId.replace("minecraft:", "");
        if (nbt.contains("Count:") && (nbt.contains("AttributeModifiers:") || nbt.contains("Potion") || nbt.contains("Enchantments:"))) {
            return true;
        }
        if (blockName.contains("command_block")) {
            try {
                int endIndex;
                String commandKey = "Command:";
                int startIndex = nbt.indexOf(commandKey);
                if (startIndex == -1) {
                    throw new IllegalArgumentException("The 'Command:' key was not found.");
                }
                char quoteCharacter = nbt.charAt(startIndex += commandKey.length());
                if (quoteCharacter != '\'' && quoteCharacter != '\"') {
                    throw new IllegalArgumentException("Unexpected character after 'Command:'. Expected a quote.");
                }
                if ((endIndex = nbt.indexOf(quoteCharacter, ++startIndex)) == -1) {
                    throw new IllegalArgumentException("Closing quote for the command value was not found.");
                }
                String commandValue = nbt.substring(startIndex, endIndex);
                if (commandValue.contains("{") && commandValue.contains("}")) {
                    return true;
                }
            }
            catch (Exception e) {
                System.err.println("An error occurred: " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    private static Vector3d getLastSecondPos(Vector3d firstPos, Vector3d size, Vector3d positiveOrNegative) {
        return new Vector3d(firstPos.x + positiveOrNegative.x * (size.x - 1.0), firstPos.y + positiveOrNegative.y * (size.y - 1.0), firstPos.z + positiveOrNegative.z * (size.z - 1.0));
    }

    public static String rotateBlock(String thisData, String pasteDirection, Boolean returnDirection) {
        if (thisData != null) {
            if (thisData.contains("facing=") && thisData.length() >= 11) {
                String blockDirection = thisData.substring(thisData.indexOf("facing=") + 7);
                blockDirection = blockDirection.contains(",") ? blockDirection.substring(0, blockDirection.indexOf(",")) : blockDirection.substring(0, blockDirection.indexOf("]"));
                return Functions.calculateBlockRotation(blockDirection, pasteDirection, Firebase.uploadDirection);
            }
        } else {
            return "";
        }
        return thisData;
    }

    public static String rotateBlock(String thisData, String pasteDirection) {
        if (thisData != null) {
            if (thisData.contains("facing=") && thisData.length() >= 11) {
                String blockDirection = thisData.substring(thisData.indexOf("facing=") + 7);
                blockDirection = blockDirection.contains(",") ? blockDirection.substring(0, blockDirection.indexOf(",")) : blockDirection.substring(0, blockDirection.indexOf("]"));
                String finalBlockDirection = Functions.calculateBlockRotation(blockDirection, pasteDirection, Firebase.uploadDirection);
                thisData = thisData.replace("facing=" + blockDirection, "facing=" + finalBlockDirection);
                return thisData;
            }
        } else {
            return "";
        }
        return thisData;
    }

    public static String calculateBlockRotation(String blockDir, String pasteDir, String uploadDir) {
        String[] possibleBlockDirectionsArray = new String[]{"north", "south", "east", "west"};
        List<String> possibleBlockDirections = Arrays.asList(possibleBlockDirectionsArray);
        if (possibleBlockDirections.contains(blockDir)) {
            Integer uploadDirectionInDegrees = Functions.facingToDegrees(uploadDir);
            Integer pasteDirInt = Functions.facingToDegrees(pasteDir);
            Integer differenceUploadPasteDirection = pasteDirInt - uploadDirectionInDegrees;
            Integer result = (360 + (Functions.facingToDegrees(blockDir) + differenceUploadPasteDirection)) % 360;
            return Functions.degreesToFacing(result);
        }
        return blockDir;
    }

    public static Integer facingToDegrees(String facing) {
        if (facing.equals("north")) {
            return 0;
        }
        if (facing.equals("east")) {
            return 90;
        }
        if (facing.equals("south")) {
            return 180;
        }
        if (facing.equals("west")) {
            return 270;
        }
        PrefabricatedStructures.LOGGER.info("No rotation is passend, return 0");
        return 0;
    }

    public static String degreesToFacing(Integer degrees) {
        if (degrees == 0) {
            return "north";
        }
        if (degrees == 90) {
            return "east";
        }
        if (degrees == 180) {
            return "south";
        }
        if (degrees == 270) {
            return "west";
        }
        return "north";
    }

    public static String getLookDirection(float yaw) {
        if (yaw > 360.0f) {
            yaw %= 360.0f;
        }
        if (yaw < 0.0f) {
            yaw %= 360.0f;
            yaw += 360.0f;
        }
        if (yaw >= 315.0f || yaw < 45.0f) {
            return "south";
        }
        if (yaw < 135.0f) {
            return "west";
        }
        if (yaw < 225.0f) {
            return "north";
        }
        if (yaw < 315.0f) {
            return "east";
        }
        return "north";
    }

    public static String getBlockByID(Integer id) {
        return "minecraft:" + AllBlocksArray.blocksArray[id];
    }

    public static Integer getBlockIdByName(String name) {
        if (Arrays.asList(AllBlocksArray.blocksArray).contains(name)) {
            return ArrayUtils.indexOf((Object[])AllBlocksArray.blocksArray, (Object)name.replace("minecraft:", ""));
        }
        return null;
    }

    public static String getBlockByIdOrName(Object nameOrId) {
        try {
            int index = Math.round(Float.parseFloat(nameOrId.toString()));
            if (index >= AllBlocksArray.blocksArray.length || index < 0) {
                ++newerBlocksAmountFound;
                return "minecraft:air";
            }
            return "minecraft:" + AllBlocksArray.blocksArray[index];
        }
        catch (NumberFormatException e) {
            return nameOrId.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "minecraft:air";
        }
    }

    public static String getBlocknameFromVector(Vector3d pos) {
        Block block = Variables.player.getCommandSenderWorld().getBlockState(new BlockPos((int)pos.x, (int)pos.y, (int)pos.z)).getBlock();
        return BuiltInRegistries.BLOCK.getKey((Object)block).toString();
    }

    public static String getBlocknameFromBlock(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).toString();
    }

    public static String PosToString(Vector3d pos) {
        return Math.round(pos.x) + " " + Math.round(pos.y) + " " + Math.round(pos.z);
    }

    public static String PosToString(BlockPos pos) {
        return pos.getX() + " " + pos.getY() + " " + pos.getZ();
    }

    public static Boolean hasPremiumMemberLevel(String memberLevel) {
        return memberLevel.equals("plus") || memberLevel.equals("pro");
    }

    static {
        hasFoundOldNBT = false;
        buildsWithOldNBT = new ArrayList<String>();
    }
}

