/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.client.render.blockentity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Calendar;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.colossalchests.client.render.blockentity.RenderTileEntityChestBase;
import org.joml.Matrix4f;

public class RenderTileEntityColossalChest
extends RenderTileEntityChestBase<BlockEntityColossalChest> {
    public static final Map<ChestMaterial, ResourceLocation> TEXTURES_CHEST = Maps.newHashMap();
    public static final Map<ChestMaterial, ResourceLocation> TEXTURES_INTERFACE = Maps.newHashMap();

    public RenderTileEntityColossalChest(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void handleRotation(BlockEntityColossalChest blockEntity, PoseStack poseStack) {
        if (blockEntity.isStructureComplete()) {
            Vec3 renderOffset = blockEntity.getRenderOffset();
            poseStack.translate(-renderOffset.x, -renderOffset.y, -renderOffset.z);
        }
        super.handleRotation(blockEntity, poseStack);
        poseStack.translate(0.0f, (float)blockEntity.getSizeSingular() * 0.0625f, 0.0f);
        float size = (float)blockEntity.getSizeSingular() * 1.125f;
        poseStack.scale(size, size, size);
    }

    @Override
    public void render(BlockEntityColossalChest tile, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        if (tile.isStructureComplete()) {
            matrixStack.pushPose();
            super.render(tile, partialTicks, matrixStack, renderTypeBuffer, combinedLightIn, combinedOverlayIn);
            if (tile.isStructureComplete() && tile.getOpenNess(0.0f) == 0.0f && (GeneralConfig.alwaysShowInterfaceOverlay || Minecraft.getInstance().player.isCrouching())) {
                matrixStack.pushPose();
                Material materialInterface = this.getMaterialInterface(tile);
                VertexConsumer buffer = materialInterface.buffer(renderTypeBuffer, RenderType::text);
                for (Vec3i interfaceLocation : tile.getInterfaceLocations()) {
                    float translateX = interfaceLocation.getX() - tile.getBlockPos().getX();
                    float translateY = interfaceLocation.getY() - tile.getBlockPos().getY();
                    float translateZ = interfaceLocation.getZ() - tile.getBlockPos().getZ();
                    matrixStack.translate(translateX, translateY, translateZ);
                    this.renderInterface(matrixStack, buffer, materialInterface.sprite(), interfaceLocation.equals((Object)tile.getBlockPos()), combinedLightIn);
                    matrixStack.translate(-translateX, -translateY, -translateZ);
                }
                matrixStack.popPose();
            }
            matrixStack.popPose();
        }
    }

    public boolean shouldRenderOffScreen(BlockEntityColossalChest tile) {
        return true;
    }

    @Override
    protected Direction getDirection(BlockEntityColossalChest tile) {
        return tile.getRotation().getOpposite();
    }

    @Override
    protected Material getMaterial(BlockEntityColossalChest tile) {
        return new Material(Sheets.CHEST_SHEET, TEXTURES_CHEST.get(tile.getMaterial()));
    }

    protected Material getMaterialInterface(BlockEntityColossalChest tile) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, TEXTURES_INTERFACE.get(tile.getMaterial()));
    }

    protected void setMatrixOrientation(PoseStack matrixStack, Direction direction) {
        float translateX = -1.0f - (float)direction.getStepX();
        float translateY = direction.getStepY();
        float translateZ = direction.getStepZ();
        if (direction == Direction.NORTH) {
            translateZ += 1.0f;
            translateX += 2.0f;
            translateY -= 1.0f;
        } else if (direction == Direction.EAST) {
            translateX += 3.0f;
            translateY -= 1.0f;
            translateZ += 1.0f;
        } else if (direction == Direction.WEST) {
            translateY -= 1.0f;
        } else if (direction == Direction.SOUTH) {
            translateX += 1.0f;
            translateY -= 1.0f;
        } else if (direction == Direction.UP) {
            translateX += 1.0f;
            translateZ += 1.0f;
        } else if (direction == Direction.DOWN) {
            translateX += 1.0f;
        }
        matrixStack.translate(translateX * 16.0f, translateY * 16.0f, translateZ * 16.0f);
        int rotationY = 0;
        int rotationX = 0;
        if (direction == Direction.SOUTH) {
            rotationY = 0;
        } else if (direction == Direction.NORTH) {
            rotationY = 180;
        } else if (direction == Direction.EAST) {
            rotationY = 90;
        } else if (direction == Direction.WEST) {
            rotationY = -90;
        } else if (direction == Direction.UP) {
            rotationX = -90;
        } else if (direction == Direction.DOWN) {
            rotationX = 90;
        }
        matrixStack.mulPose(Axis.YP.rotationDegrees((float)rotationY));
        matrixStack.mulPose(Axis.XP.rotationDegrees((float)rotationX));
    }

    protected void renderInterface(PoseStack matrixStack, VertexConsumer buffer, TextureAtlasSprite sprite, boolean core, int combinedLightIn) {
        for (Direction side : Direction.values()) {
            matrixStack.pushPose();
            float scale = 0.063f;
            matrixStack.scale(scale, scale, scale);
            matrixStack.scale(1.0f, -1.0f, 1.0f);
            this.setMatrixOrientation(matrixStack, side);
            float indent = -0.2f;
            if (side == Direction.UP) {
                indent = -15.8f;
            }
            if (side == Direction.DOWN) {
                indent *= 2.0f;
            }
            int alpha = 255;
            float posMin = core ? 5.0f : 6.0f;
            float posMax = 16.0f - posMin;
            float uvScale = posMin / 16.0f;
            float uMin = (sprite.getU1() - sprite.getU0()) * uvScale + sprite.getU0();
            float uMax = (sprite.getU1() - sprite.getU0()) * (1.0f - uvScale) + sprite.getU0();
            float vMin = (sprite.getV1() - sprite.getV0()) * uvScale + sprite.getV0();
            float vMax = (sprite.getV1() - sprite.getV0()) * (1.0f - uvScale) + sprite.getV0();
            Matrix4f matrix = matrixStack.last().pose();
            buffer.addVertex(matrix, posMax, posMax, indent).setColor(255, 255, 255, alpha).setUv(uMin, vMax).setLight(combinedLightIn);
            buffer.addVertex(matrix, posMax, posMin, indent).setColor(255, 255, 255, alpha).setUv(uMin, vMin).setLight(combinedLightIn);
            buffer.addVertex(matrix, posMin, posMin, indent).setColor(255, 255, 255, alpha).setUv(uMax, vMin).setLight(combinedLightIn);
            buffer.addVertex(matrix, posMin, posMax, indent).setColor(255, 255, 255, alpha).setUv(uMax, vMax).setLight(combinedLightIn);
            matrixStack.popPose();
        }
    }

    static {
        Calendar calendar = Calendar.getInstance();
        boolean christmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        TEXTURES_CHEST.put(ChestMaterial.WOOD, ResourceLocation.parse((String)("entity/chest/" + (christmas ? "christmas" : "normal"))));
        TEXTURES_CHEST.put(ChestMaterial.COPPER, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"models/chest_copper"));
        TEXTURES_CHEST.put(ChestMaterial.IRON, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"models/chest_iron"));
        TEXTURES_CHEST.put(ChestMaterial.SILVER, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"models/chest_silver"));
        TEXTURES_CHEST.put(ChestMaterial.GOLD, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"models/chest_gold"));
        TEXTURES_CHEST.put(ChestMaterial.DIAMOND, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"models/chest_diamond"));
        TEXTURES_CHEST.put(ChestMaterial.OBSIDIAN, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"models/chest_obsidian"));
        TEXTURES_INTERFACE.put(ChestMaterial.WOOD, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_wood"));
        TEXTURES_INTERFACE.put(ChestMaterial.COPPER, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_copper"));
        TEXTURES_INTERFACE.put(ChestMaterial.IRON, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_iron"));
        TEXTURES_INTERFACE.put(ChestMaterial.SILVER, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_silver"));
        TEXTURES_INTERFACE.put(ChestMaterial.GOLD, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_gold"));
        TEXTURES_INTERFACE.put(ChestMaterial.DIAMOND, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_diamond"));
        TEXTURES_INTERFACE.put(ChestMaterial.OBSIDIAN, ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_obsidian"));
    }
}

