/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.screens.inventory;

import fuzs.completionistsindex.client.gui.screens.inventory.IndexViewScreen;
import fuzs.completionistsindex.client.gui.screens.inventory.StatsSorting;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.item.ItemStack;

public class ItemsIndexViewScreen
extends IndexViewScreen<StatsSorting> {
    private static StatsSorting statsSorting = StatsSorting.CREATIVE;
    private final List<ItemStack> items;

    public ItemsIndexViewScreen(Screen lastScreen, boolean fromInventory, List<ItemStack> items) {
        super(lastScreen, fromInventory);
        this.items = items;
    }

    @Override
    protected Stream<IndexViewScreen.IndexViewPage.Entry> getPageEntries() {
        StatsCounter statsCounter = this.minecraft.player.getStats();
        return this.items.stream().map(itemStack -> IndexViewScreen.IndexViewPage.createSingleEntry(itemStack, statsCounter, this.font));
    }

    @Override
    protected void init() {
        super.init();
        ((SpritelessImageButton)this.addRenderableWidget((GuiEventListener)new SpritelessImageButton(this.leftPos + 17, this.topPos + 11, 16, 13, 42, 202, 20, INDEX_LOCATION, 512, 256, button -> this.minecraft.setScreen(this.lastScreen)))).setTooltip(Tooltip.create((Component)CommonComponents.GUI_BACK));
        this.rebuildPages();
    }

    @Override
    protected StatsSorting getSortProvider() {
        return statsSorting;
    }

    @Override
    protected void setSortProvider(StatsSorting sortProvider) {
        statsSorting = sortProvider;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 259 && this.shouldCloseOnEsc()) {
            this.minecraft.setScreen(this.lastScreen);
            return true;
        }
        return false;
    }

    public void onClose() {
        this.lastScreen.onClose();
    }
}

