/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.cyclepaintings_common_fabric.util;

import com.natamus.cyclepaintings_common_fabric.config.ConfigHandler;
import com.natamus.cyclepaintings_common_fabric.data.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1535;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7406;

public class Util {
    private static final List<class_6880<class_1535>> allPaintingVariants = new ArrayList<class_6880<class_1535>>();

    public static void setPaintings(class_2378<class_1535> paintingRegistry) {
        if (!allPaintingVariants.isEmpty()) {
            return;
        }
        String[] allignore = ConfigHandler.ignorePaintingsInCycleResourceLocation.split(",");
        boolean debug = ConfigHandler.showRegisteredPaintingsDebug;
        if (debug) {
            Constants.logger.info("[Cycle Paintings Debug] The config option 'showRegisteredPaintingsDebug' has been enabled. Showing paintings during cycle registration.");
        }
        for (class_6880 paintingVariantHolder : paintingRegistry.method_40286(class_7406.field_38929)) {
            class_5321 resourceKey;
            class_2960 resourceLocation;
            Optional optional = paintingVariantHolder.method_40230();
            if (optional.isEmpty() || (resourceLocation = (resourceKey = (class_5321)optional.get()).method_29177()) == null) continue;
            boolean allowed = true;
            String stringLocation = resourceLocation.toString().toLowerCase();
            for (String toignore : allignore) {
                if ((toignore = toignore.toLowerCase().trim()).contains(":")) {
                    if (!stringLocation.equals(toignore)) continue;
                    allowed = false;
                    break;
                }
                if (!stringLocation.split(":")[0].contains(toignore)) continue;
                allowed = false;
                break;
            }
            if (!allowed) {
                if (!debug) continue;
                Constants.logger.info("[Cycle Paintings Debug] " + stringLocation + " (ignored)");
                continue;
            }
            if (debug) {
                Constants.logger.info("[Cycle Paintings Debug] " + stringLocation + " (allowed)");
            }
            Optional motiveOptionalReference = paintingRegistry.method_10223(resourceLocation);
            motiveOptionalReference.ifPresent(allPaintingVariants::add);
        }
    }

    public static List<class_6880<class_1535>> getSimilarArt(class_1535 currentVariant) {
        ArrayList<class_6880<class_1535>> similarVariants = new ArrayList<class_6880<class_1535>>();
        int xSize = currentVariant.comp_2670();
        int ySize = currentVariant.comp_2671();
        for (class_6880<class_1535> paintingVariantHolder : allPaintingVariants) {
            class_1535 paintingVariant = (class_1535)paintingVariantHolder.comp_349();
            if (paintingVariant.comp_2670() != xSize || paintingVariant.comp_2671() != ySize) continue;
            similarVariants.add(paintingVariantHolder);
        }
        return similarVariants;
    }
}

