/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.deathcounter.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import me.ichun.mods.deathcounter.common.DeathCounter;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class CommandDeathCounter {
    private static final DynamicCommandExceptionType TRANSFER_FAIL = new DynamicCommandExceptionType(name -> Component.translatable((String)"commands.deathcounter.transfer.fail", (Object[])new Object[]{name}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dc").executes(source -> {
            Entity ent = ((CommandSourceStack)source.getSource()).getEntity();
            if (ent != null) {
                CommandDeathCounter.broadcastLeaderboard(Collections.singleton(ent), null, DeathCounter.config.leaderboardCount);
            } else {
                CommandDeathCounter.broadcastLeaderboard(Collections.emptyList(), (CommandSourceStack)source.getSource(), DeathCounter.config.leaderboardCount);
            }
            return 0;
        })).then(Commands.literal((String)"get").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)commandContext.getSource()).getServer().getPlayerList().getPlayerNamesArray(), (SuggestionsBuilder)suggestionsBuilder)).executes(source -> {
            String name = StringArgumentType.getString((CommandContext)source, (String)"name");
            int deaths = DeathCounter.deathHandler.getDeaths(name);
            int rank = DeathCounter.deathHandler.getRank(name);
            if (deaths > 0) {
                ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.translatable((String)"commands.deathcounter.get", (Object[])new Object[]{name, deaths, rank}), false);
            } else {
                ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.translatable((String)"commands.deathcounter.get.none", (Object[])new Object[]{name}), false);
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(p -> p.hasPermission(DeathCounter.config.commandPermissionLevel))).then(Commands.argument((String)"name/\"all\"", (ArgumentType)StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)commandContext.getSource()).getServer().getPlayerList().getPlayerNamesArray(), (SuggestionsBuilder)suggestionsBuilder)).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(source -> {
            int deaths = IntegerArgumentType.getInteger((CommandContext)source, (String)"value");
            DeathCounter.deathHandler.setDeaths(StringArgumentType.getString((CommandContext)source, (String)"name/\"all\""), deaths);
            return deaths;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"broadcast").requires(p -> p.hasPermission(DeathCounter.config.commandPermissionLevel))).executes(source -> {
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.translatable((String)"commands.deathcounter.leaderboard.broadcasted"), true);
            CommandDeathCounter.broadcastLeaderboard(((CommandSourceStack)source.getSource()).getServer().getPlayerList().getPlayers(), null, DeathCounter.config.leaderboardCount);
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(source -> {
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.translatable((String)"commands.deathcounter.leaderboard.broadcasted"), true);
            CommandDeathCounter.broadcastLeaderboard(EntityArgument.getPlayers((CommandContext)source, (String)"targets"), null, DeathCounter.config.leaderboardCount);
            return 0;
        })).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(source -> {
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.translatable((String)"commands.deathcounter.leaderboard.broadcasted"), true);
            CommandDeathCounter.broadcastLeaderboard(EntityArgument.getPlayers((CommandContext)source, (String)"targets"), null, IntegerArgumentType.getInteger((CommandContext)source, (String)"count"));
            return 0;
        })))).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(source -> {
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.translatable((String)"commands.deathcounter.leaderboard.broadcasted"), true);
            CommandDeathCounter.broadcastLeaderboard(((CommandSourceStack)source.getSource()).getServer().getPlayerList().getPlayers(), null, IntegerArgumentType.getInteger((CommandContext)source, (String)"count"));
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"transfer").requires(p -> p.hasPermission(DeathCounter.config.commandPermissionLevel))).then(Commands.argument((String)"from", (ArgumentType)StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)commandContext.getSource()).getServer().getPlayerList().getPlayerNamesArray(), (SuggestionsBuilder)suggestionsBuilder)).then(Commands.argument((String)"to", (ArgumentType)StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)commandContext.getSource()).getServer().getPlayerList().getPlayerNamesArray(), (SuggestionsBuilder)suggestionsBuilder)).executes(source -> {
            String to;
            String from = StringArgumentType.getString((CommandContext)source, (String)"from");
            int deaths = DeathCounter.deathHandler.transferDeaths(from, to = StringArgumentType.getString((CommandContext)source, (String)"to"));
            if (deaths <= 0) {
                throw TRANSFER_FAIL.create((Object)from);
            }
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.translatable((String)"commands.deathcounter.transfer", (Object[])new Object[]{deaths, from, to}), true);
            return deaths;
        })))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"deathcounter").redirect((CommandNode)command));
    }

    public static void broadcastLeaderboard(Collection<? extends Entity> entities, CommandSourceStack source, int count) {
        if (source != null) {
            source.sendSuccess(() -> Component.translatable((String)"commands.deathcounter.leaderboard"), false);
            if (DeathCounter.deathHandler.getRankings().isEmpty()) {
                source.sendSuccess(() -> Component.translatable((String)"commands.deathcounter.leaderboard.none"), false);
            } else {
                int done = 0;
                int rank = 1;
                for (Map.Entry<Integer, TreeSet<String>> e2 : DeathCounter.deathHandler.getRankings().entrySet()) {
                    TreeSet<String> set = e2.getValue();
                    for (String s : set) {
                        int finalRank = rank;
                        source.sendSuccess(() -> CommandDeathCounter.setStyleForRank(Component.translatable((String)"commands.deathcounter.leaderboard.copy", (Object[])new Object[]{"   " + finalRank + " - " + s + " (" + String.valueOf(e2.getKey()) + ")"}), finalRank), false);
                        if (++done < count) continue;
                        break;
                    }
                    if (done < count) {
                        rank += e2.getValue().size();
                        continue;
                    }
                    break;
                }
            }
        } else {
            entities.stream().filter(e -> e instanceof ServerPlayer).forEach(e -> {
                ServerPlayer player = (ServerPlayer)e;
                player.sendSystemMessage((Component)Component.translatable((String)"commands.deathcounter.leaderboard"));
                if (DeathCounter.deathHandler.getRankings().isEmpty()) {
                    player.sendSystemMessage((Component)Component.translatable((String)"commands.deathcounter.leaderboard.none"));
                } else {
                    int done = 0;
                    int rank = 1;
                    for (Map.Entry<Integer, TreeSet<String>> e1 : DeathCounter.deathHandler.getRankings().entrySet()) {
                        TreeSet<String> set = e1.getValue();
                        for (String s : set) {
                            if (done++ >= count && !s.equalsIgnoreCase(player.getName().getString())) continue;
                            player.sendSystemMessage(CommandDeathCounter.setStyleForRank(Component.translatable((String)"commands.deathcounter.leaderboard.copy", (Object[])new Object[]{(s.equalsIgnoreCase(player.getName().getString()) ? "-> " : "   ") + rank + " - " + s + " (" + String.valueOf(e1.getKey()) + ")"}), rank));
                        }
                        rank += e1.getValue().size();
                    }
                }
            });
        }
    }

    private static Component setStyleForRank(MutableComponent text, int i) {
        switch (i) {
            case 1: {
                return text.withStyle(ChatFormatting.YELLOW);
            }
            case 2: {
                return text.withStyle(ChatFormatting.GRAY);
            }
            case 3: {
                return text.withStyle(ChatFormatting.DARK_RED);
            }
        }
        return text;
    }
}

