/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.deathcounter.common.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import me.ichun.mods.deathcounter.common.DeathCounter;
import me.ichun.mods.deathcounter.common.command.CommandDeathCounter;
import me.ichun.mods.ichunutil.common.entity.EntityHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.util.WatchServiceThread;
import me.ichun.mods.ichunutil.mixin.LevelStorageAccessAccessorMixin;
import me.ichun.mods.ichunutil.mixin.MinecraftServerAccessorMixin;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;

public abstract class DeathHandler {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private TreeMap<String, Integer> deaths = new TreeMap(Comparator.naturalOrder());
    private TreeMap<Integer, TreeSet<String>> ranking = new TreeMap(Comparator.reverseOrder());
    private Path currentDeathsFile = null;
    private long timestamp = 0L;
    private boolean writing = false;

    public DeathHandler() {
        iChunUtil.eS().registerServerAboutToStartListener(this::onServerAboutToStart);
        iChunUtil.eS().registerCommandRegistrationListener(this::onRegisterCommands);
        iChunUtil.eS().registerServerStoppingListener(server -> this.onServerStopping());
    }

    public void onLivingDeath(LivingEntity living, DamageSource source) {
        if (!living.getCommandSenderWorld().isClientSide() && living instanceof ServerPlayer && !EntityHelper.isFakePlayer((ServerPlayer)((ServerPlayer)living)) && !this.postAddPlayerDeathStatEvent((ServerPlayer)living, source)) {
            this.addDeath((ServerPlayer)living);
        }
    }

    public void onServerAboutToStart(MinecraftServer server) {
        if (!DeathCounter.config.singleSession) {
            Path worldSavePath = ((LevelStorageAccessAccessorMixin)((MinecraftServerAccessorMixin)server).getStorageSource()).getLevelDirectory().path();
            this.currentDeathsFile = worldSavePath.resolve("deaths.json");
            WatchServiceThread.watchFile((Path)this.currentDeathsFile, fileName -> {
                long lastChange = 0L;
                try {
                    lastChange = Files.getLastModifiedTime(this.currentDeathsFile, new LinkOption[0]).toMillis();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.currentDeathsFile != null && !DeathCounter.config.singleSession && !this.writing && this.timestamp != lastChange) {
                    server.execute(this::loadDeaths);
                }
            }).setSleepTime(500L);
            this.loadDeaths();
        }
    }

    public void onRegisterCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandDeathCounter.register(dispatcher);
    }

    public void onServerStopping() {
        if (this.currentDeathsFile != null) {
            WatchServiceThread.stopWatchFile((Path)this.currentDeathsFile);
        }
        this.currentDeathsFile = null;
        this.deaths.clear();
        this.ranking.clear();
    }

    public boolean isMessageOurs(Component message) {
        return message instanceof MutableComponent && message.getContents() instanceof TranslatableContents && (((TranslatableContents)message.getContents()).getKey().startsWith("message.deathcounter.") || ((TranslatableContents)message.getContents()).getKey().startsWith("commands.deathcounter.leaderboard"));
    }

    public abstract boolean postAddPlayerDeathStatEvent(ServerPlayer var1, DamageSource var2);

    public void addDeath(ServerPlayer player) {
        int playerDeaths = this.deaths.compute(player.getName().getString(), (k, v) -> v == null ? 1 : v + 1);
        this.saveAndUpdateDeaths();
        int rank = this.getRank(player.getName().getString());
        switch (DeathCounter.config.messageType) {
            case SHORT: {
                player.sendSystemMessage((Component)Component.translatable((String)"message.deathcounter.deathAndRank", (Object[])new Object[]{playerDeaths, rank}));
                break;
            }
            case LONG: {
                player.sendSystemMessage((Component)Component.translatable((String)"message.deathcounter.death", (Object[])new Object[]{playerDeaths}), false);
                player.sendSystemMessage((Component)Component.translatable((String)"message.deathcounter.rank", (Object[])new Object[]{rank}), false);
                break;
            }
        }
        switch (DeathCounter.config.broadcastOnDeath) {
            case SELF: {
                CommandDeathCounter.broadcastLeaderboard(Collections.singleton(player), null, DeathCounter.config.leaderboardCount);
                break;
            }
            case ALL: {
                CommandDeathCounter.broadcastLeaderboard(player.getServer().getPlayerList().getPlayers(), null, DeathCounter.config.leaderboardCount);
                break;
            }
        }
    }

    public int getDeaths(String name) {
        return this.deaths.getOrDefault(name, 0);
    }

    public int getDeaths(ServerPlayer player) {
        return this.getDeaths(player.getName().getString());
    }

    public void setDeaths(String name, int i) {
        if ("all".equalsIgnoreCase(name)) {
            if (i <= 0) {
                this.deaths.clear();
            } else {
                TreeMap newDeaths = new TreeMap(Comparator.naturalOrder());
                newDeaths.putAll(this.deaths.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> i)));
                this.deaths = newDeaths;
            }
        } else if (i <= 0) {
            this.deaths.remove(name);
        } else {
            this.deaths.put(name, i);
        }
        this.saveAndUpdateDeaths();
    }

    public int transferDeaths(String from, String to) {
        if (from == null || to == null || from.isEmpty() || to.isEmpty() || !this.deaths.containsKey(from)) {
            return -1;
        }
        this.deaths.put(to, this.deaths.get(from));
        this.deaths.remove(from);
        this.saveAndUpdateDeaths();
        return this.deaths.get(to);
    }

    public void saveAndUpdateDeaths() {
        if (this.currentDeathsFile == null) {
            DeathCounter.LOGGER.error("Trying to save deaths before we're ready");
            return;
        }
        if (this.writing) {
            DeathCounter.LOGGER.error("Tried to save deaths whilst saving deaths... what?");
            return;
        }
        if (!DeathCounter.config.singleSession) {
            this.writing = true;
            try {
                Files.writeString(this.currentDeathsFile, (CharSequence)this.gson.toJson(this.deaths), StandardCharsets.UTF_8, new OpenOption[0]);
                this.timestamp = Files.getLastModifiedTime(this.currentDeathsFile, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                DeathCounter.LOGGER.error("Error writing deaths.json: {}", (Object)this.currentDeathsFile.toString(), (Object)e);
            }
            this.writing = false;
        }
        this.calculateRank();
    }

    public void loadDeaths() {
        if (DeathCounter.config.singleSession) {
            return;
        }
        if (this.currentDeathsFile == null) {
            DeathCounter.LOGGER.error("Trying to load deaths before we're ready");
            return;
        }
        if (!this.currentDeathsFile.toFile().exists()) {
            DeathCounter.LOGGER.info("Deaths not found, presuming new world: {}", (Object)this.currentDeathsFile.toString());
            return;
        }
        if (this.currentDeathsFile.toFile().isDirectory()) {
            DeathCounter.LOGGER.error("Deaths is a directory: {}", (Object)this.currentDeathsFile.toString());
            return;
        }
        if (this.writing) {
            DeathCounter.LOGGER.error("Trying to read file whilst it is being written: {}", (Object)this.currentDeathsFile.toString());
            return;
        }
        try {
            byte[] bytes = Files.readAllBytes(this.currentDeathsFile);
            this.deaths = (TreeMap)this.gson.fromJson(new String(bytes), new TypeToken<TreeMap<String, Integer>>(this){}.getType());
            this.timestamp = Files.getLastModifiedTime(this.currentDeathsFile, new LinkOption[0]).toMillis();
        }
        catch (JsonSyntaxException | IOException e) {
            DeathCounter.LOGGER.error("Error reading deaths.json: {}", (Object)this.currentDeathsFile.toString(), (Object)e);
        }
        this.calculateRank();
    }

    public void calculateRank() {
        this.ranking.clear();
        for (Map.Entry<String, Integer> e : this.deaths.entrySet()) {
            TreeSet names = this.ranking.computeIfAbsent(e.getValue(), k -> new TreeSet(Comparator.naturalOrder()));
            names.add(e.getKey());
        }
    }

    public int getRank(String name) {
        int rank = 1;
        for (Map.Entry<Integer, TreeSet<String>> e : this.ranking.entrySet()) {
            if (e.getValue().contains(name)) {
                return rank;
            }
            rank += e.getValue().size();
        }
        return -1;
    }

    public TreeMap<Integer, TreeSet<String>> getRankings() {
        return this.ranking;
    }
}

