/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase.client.tile;

import chappie.displaycase.common.blocks.ModBlocks;
import chappie.displaycase.common.tile.DisplayCaseTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class DisplayCaseSpecialRenderer
implements SpecialModelRenderer<ItemStack> {
    private final DisplayCaseTileEntity tile = new DisplayCaseTileEntity(BlockPos.ZERO, ModBlocks.DISPLAY_CASE.defaultBlockState());

    public void render(@Nullable ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        poseStack.pushPose();
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            this.tile.setLevel((Level)level);
            CustomData customData = (CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
            this.tile.loadWithComponents(customData.copyTag(), (HolderLookup.Provider)level.registryAccess());
            BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)this.tile.getType(), (CompoundTag)this.tile.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess()));
        }
        Minecraft.getInstance().getBlockEntityRenderDispatcher().render((BlockEntity)this.tile, Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaTicks(), poseStack, bufferSource);
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(((BlockItem)stack.getItem()).getBlock().defaultBlockState(), poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.popPose();
    }

    @Nullable
    public ItemStack extractArgument(ItemStack stack) {
        return stack;
    }

    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit((Object)new Unbaked());

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            return new DisplayCaseSpecialRenderer();
        }
    }
}

