/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase.common.items;

import chappie.displaycase.Constants;
import chappie.displaycase.common.blocks.ModBlocks;
import chappie.displaycase.common.tile.ModTileEntities;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DisplayCaseItem
extends BlockItem {
    public DisplayCaseItem() {
        super((Block)ModBlocks.DISPLAY_CASE, new Item.Properties().setId(ResourceKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)Constants.of("display_case"))));
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemStack, level, entity, slot, selected);
        this.updateDisplayCase(level, itemStack);
    }

    public void updateDisplayCase(Level level, ItemStack itemStack) {
        if (level.isClientSide) {
            CompoundTag compoundtag = ((CustomData)itemStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (!compoundtag.getBoolean("Waxed") && compoundtag.getInt("Rotation") != Short.MIN_VALUE) {
                compoundtag.putInt("Rotation", compoundtag.getInt("Rotation") + 1);
            }
            BlockItem.setBlockEntityData((ItemStack)itemStack, ModTileEntities.DISPLAY_CASE, (CompoundTag)compoundtag);
        }
    }
}

