/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.effecttimerplus.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.CyclingListControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.terminalmc.effecttimerplus.config.Config;
import dev.terminalmc.effecttimerplus.mixin.accessor.GuiAccessor;
import dev.terminalmc.effecttimerplus.util.IndicatorUtil;
import dev.terminalmc.effecttimerplus.util.Localization;
import java.awt.Color;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public class YaclScreenProvider {
    private static final IntUnaryOperator toAlpha = value -> value >> 24 & 0xFF;
    private static final IntUnaryOperator fromAlpha = value -> value * 0x1000000;
    private static final IntBinaryOperator withAlpha = (value, alpha) -> value - fromAlpha.applyAsInt(toAlpha.applyAsInt(value)) + alpha;

    static Screen getConfigScreen(Screen parent) {
        Config options = Config.get();
        Preview preview = new Preview();
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder().title((Component)Localization.localized("name", new Object[0])).save(Config::save);
        ConfigCategory.Builder timerCat = ConfigCategory.createBuilder().name((Component)Localization.localized("option", "timer", new Object[0]));
        timerCat.option(Option.createBuilder().name((Component)Localization.localized("option", "timer.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerEnabled = (Boolean)option.pendingValue();
        }).binding((Object)true, () -> options.timerEnabled, val -> {
            options.timerEnabled = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        timerCat.option(Option.createBuilder().name((Component)Localization.localized("option", "timer.ambient.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerEnabledAmbient = (Boolean)option.pendingValue();
        }).binding((Object)false, () -> options.timerEnabledAmbient, val -> {
            options.timerEnabledAmbient = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        timerCat.option(Option.createBuilder().name((Component)Localization.localized("option", "timer.warn.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerWarnEnabled = (Boolean)option.pendingValue();
        }).binding((Object)true, () -> options.timerWarnEnabled, val -> {
            options.timerWarnEnabled = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        timerCat.option(Option.createBuilder().name((Component)Localization.localized("option", "timer.warn.flash.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerFlashEnabled = (Boolean)option.pendingValue();
        }).binding((Object)true, () -> options.timerFlashEnabled, val -> {
            options.timerFlashEnabled = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        timerCat.option(Option.createBuilder().name((Component)Localization.localized("option", "timer.color", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerColor = YaclScreenProvider.fixAlpha(((Color)option.pendingValue()).getRGB());
        }).binding((Object)YaclScreenProvider.fromArgb(-1711276033), () -> YaclScreenProvider.fromArgb(options.timerColor), val -> {
            options.timerColor = YaclScreenProvider.fixAlpha(val.getRGB());
        }).controller(option -> ColorControllerBuilder.create((Option)option).allowAlpha(true)).build());
        timerCat.option(Option.createBuilder().name((Component)Localization.localized("option", "timer.shadow.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerShadow = (Boolean)option.pendingValue();
        }).binding((Object)true, () -> options.timerShadow, val -> {
            options.timerShadow = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        timerCat.option(Option.createBuilder().name((Component)Localization.localized("option", "timer.back.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerBack = (Boolean)option.pendingValue();
        }).binding((Object)false, () -> options.timerBack, val -> {
            options.timerBack = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        timerCat.option(Option.createBuilder().name((Component)Localization.localized("option", "timer.back.color", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerBackColor = YaclScreenProvider.fixAlpha(((Color)option.pendingValue()).getRGB());
        }).binding((Object)YaclScreenProvider.fromArgb(-1776213727), () -> YaclScreenProvider.fromArgb(options.timerBackColor), val -> {
            options.timerBackColor = YaclScreenProvider.fixAlpha(val.getRGB());
        }).controller(option -> ColorControllerBuilder.create((Option)option).allowAlpha(true)).build());
        timerCat.option(Option.createBuilder().name((Component)Localization.localized("option", "timer.warn.color", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerWarnColor = YaclScreenProvider.fixAlpha(((Color)option.pendingValue()).getRGB());
        }).binding((Object)YaclScreenProvider.fromArgb(-65536), () -> YaclScreenProvider.fromArgb(options.timerWarnColor), val -> {
            options.timerWarnColor = YaclScreenProvider.fixAlpha(val.getRGB());
        }).controller(option -> ColorControllerBuilder.create((Option)option).allowAlpha(true)).build());
        timerCat.option(Option.createBuilder().name((Component)Localization.localized("option", "timer.warn.time", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerWarnTime = (Integer)option.pendingValue();
        }).binding((Object)20, () -> options.timerWarnTime, val -> {
            options.timerWarnTime = val;
        }).controller(option -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)option).range((Number)0, (Number)60)).step((Number)1)).formatValue(val -> Localization.localized("option", "timer.warn.time.value", val))).build());
        timerCat.option(Option.createBuilder().name((Component)Localization.localized("option", "timer.location", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerLocation = (Integer)option.pendingValue();
        }).binding((Object)6, () -> options.timerLocation, val -> {
            options.timerLocation = val;
        }).controller(option -> CyclingListControllerBuilder.create((Option)option).values((Object[])Config.locations).formatValue(val -> Localization.localized("option", "location." + val, new Object[0]))).build());
        ConfigCategory.Builder potencyCat = ConfigCategory.createBuilder().name((Component)Localization.localized("option", "potency", new Object[0]));
        potencyCat.option(Option.createBuilder().name((Component)Localization.localized("option", "potency.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyEnabled = (Boolean)option.pendingValue();
        }).binding((Object)true, () -> options.potencyEnabled, val -> {
            options.potencyEnabled = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        potencyCat.option(Option.createBuilder().name((Component)Localization.localized("option", "potency.color", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyColor = YaclScreenProvider.fixAlpha(((Color)option.pendingValue()).getRGB());
        }).binding((Object)YaclScreenProvider.fromArgb(-1140850689), () -> YaclScreenProvider.fromArgb(options.potencyColor), val -> {
            options.potencyColor = YaclScreenProvider.fixAlpha(val.getRGB());
        }).controller(option -> ColorControllerBuilder.create((Option)option).allowAlpha(true)).build());
        potencyCat.option(Option.createBuilder().name((Component)Localization.localized("option", "potency.shadow.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyShadow = (Boolean)option.pendingValue();
        }).binding((Object)true, () -> options.potencyShadow, val -> {
            options.potencyShadow = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        potencyCat.option(Option.createBuilder().name((Component)Localization.localized("option", "potency.back.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyBack = (Boolean)option.pendingValue();
        }).binding((Object)false, () -> options.potencyBack, val -> {
            options.timerBack = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        potencyCat.option(Option.createBuilder().name((Component)Localization.localized("option", "potency.back.color", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyBackColor = YaclScreenProvider.fixAlpha(((Color)option.pendingValue()).getRGB());
        }).binding((Object)YaclScreenProvider.fromArgb(-1140850689), () -> YaclScreenProvider.fromArgb(options.potencyBackColor), val -> {
            options.potencyBackColor = YaclScreenProvider.fixAlpha(val.getRGB());
        }).controller(option -> ColorControllerBuilder.create((Option)option).allowAlpha(true)).build());
        potencyCat.option(Option.createBuilder().name((Component)Localization.localized("option", "potency.location", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyLocation = (Integer)option.pendingValue();
        }).binding((Object)2, () -> options.potencyLocation, val -> {
            options.potencyLocation = val;
        }).controller(option -> CyclingListControllerBuilder.create((Option)option).values((Object[])Config.locations).formatValue(val -> Localization.localized("option", "location." + val, new Object[0]))).build());
        ConfigCategory.Builder scaleCat = ConfigCategory.createBuilder().name((Component)Localization.localized("option", "scale", new Object[0]));
        scaleCat.option(Option.createBuilder().name((Component)Localization.localized("option", "scale.icon", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.scale = (Double)option.pendingValue();
        }).binding((Object)1.0, () -> options.scale, val -> {
            options.scale = val;
        }).controller(option -> ((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)option).range((Number)0.5, (Number)1.5)).step((Number)0.1)).build());
        scaleCat.option(Option.createBuilder().name((Component)Localization.localized("option", "scale.timer", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerScale = (Double)option.pendingValue();
        }).binding((Object)0.7f, () -> options.timerScale, val -> {
            options.timerScale = val;
        }).controller(option -> ((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)option).range((Number)0.5, (Number)1.5)).step((Number)0.1)).build());
        scaleCat.option(Option.createBuilder().name((Component)Localization.localized("option", "scale.potency", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyScale = (Double)option.pendingValue();
        }).binding((Object)0.7f, () -> options.potencyScale, val -> {
            options.potencyScale = val;
        }).controller(option -> ((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)option).range((Number)0.5, (Number)1.5)).step((Number)0.1)).build());
        builder.category(timerCat.build());
        builder.category(potencyCat.build());
        builder.category(scaleCat.build());
        YetAnotherConfigLib yacl = builder.build();
        return yacl.generateScreen(parent);
    }

    private static Color fromArgb(int i) {
        return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, i >> 24 & 0xFF);
    }

    private static int fixAlpha(int color) {
        if (toAlpha.applyAsInt(color) < 4) {
            return withAlpha.applyAsInt(color, fromAlpha.applyAsInt(4));
        }
        return color;
    }

    private static class Preview
    implements ImageRenderer {
        Config options = Config.get();
        public double scale;
        public double potencyScale;
        public double timerScale;
        public boolean potencyEnabled;
        public boolean timerEnabled;
        public boolean timerEnabledAmbient;
        public boolean timerWarnEnabled;
        public boolean timerFlashEnabled;
        public int timerWarnTime;
        public int potencyColor;
        public boolean potencyShadow;
        public boolean potencyBack;
        public int potencyBackColor;
        public int timerColor;
        public int timerWarnColor;
        public boolean timerShadow;
        public boolean timerBack;
        public int timerBackColor;
        public int potencyLocation;
        public int timerLocation;
        private final MobEffectInstance[] DEMO_EFFECTS;

        private Preview() {
            this.scale = this.options.scale;
            this.potencyScale = this.options.potencyScale;
            this.timerScale = this.options.potencyScale;
            this.potencyEnabled = this.options.potencyEnabled;
            this.timerEnabled = this.options.timerEnabled;
            this.timerEnabledAmbient = this.options.timerEnabledAmbient;
            this.timerWarnEnabled = this.options.timerWarnEnabled;
            this.timerFlashEnabled = this.options.timerFlashEnabled;
            this.timerWarnTime = this.options.timerWarnTime;
            this.potencyColor = this.options.potencyColor;
            this.potencyShadow = this.options.potencyShadow;
            this.potencyBack = this.options.potencyBack;
            this.potencyBackColor = this.options.potencyBackColor;
            this.timerColor = this.options.timerColor;
            this.timerWarnColor = this.options.timerWarnColor;
            this.timerShadow = this.options.timerShadow;
            this.timerBack = this.options.timerBack;
            this.timerBackColor = this.options.timerBackColor;
            this.potencyLocation = this.options.potencyLocation;
            this.timerLocation = this.options.timerLocation;
            this.DEMO_EFFECTS = new MobEffectInstance[]{new MobEffectInstance(MobEffects.DIG_SPEED, 111, 1, true, true), new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 211, 1, false, true), new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 411, 2, false, true), new MobEffectInstance(MobEffects.DAMAGE_BOOST, 811, 9, false, true), new MobEffectInstance(MobEffects.JUMP, 1251, 4, false, true), new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 2131, 0, false, true), new MobEffectInstance(MobEffects.WEAKNESS, 3500, 1, false, true), new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 9600, 0, false, true), new MobEffectInstance(MobEffects.INVISIBILITY, 144000, 0, false, true), new MobEffectInstance(MobEffects.CONDUIT_POWER, -1, 0, false, true)};
        }

        public int render(GuiGraphics graphics, int x, int y, int width, float delta) {
            int space;
            float scale = (float)this.scale;
            graphics.pose().pushPose();
            graphics.pose().translate((float)x * (1.0f - scale), (float)y * (1.0f - scale), 0.0f);
            graphics.pose().scale(scale, scale, 0.0f);
            Minecraft mc = Minecraft.getInstance();
            int movingX = x;
            int movingY = y;
            int targetHeight = space = 27;
            int maxX = (int)((float)x + (float)width / scale);
            int spriteSize = 24;
            int iconSize = 18;
            for (MobEffectInstance effect : this.DEMO_EFFECTS) {
                int pY;
                int pX;
                int labelWidth;
                String label;
                if (effect.isAmbient()) {
                    graphics.blitSprite(RenderType::guiTextured, GuiAccessor.getEffectBackgroundAmbientSprite(), movingX, movingY, spriteSize, spriteSize);
                } else {
                    graphics.blitSprite(RenderType::guiTextured, GuiAccessor.getEffectBackgroundSprite(), movingX, movingY, spriteSize, spriteSize);
                }
                graphics.blitSprite(RenderType::guiTextured, mc.getMobEffectTextures().get(effect.getEffect()), movingX + 3, movingY + 3, iconSize, iconSize, ARGB.white((float)1.0f));
                if (this.potencyEnabled && effect.getAmplifier() > 0) {
                    label = IndicatorUtil.getAmplifierAsString(effect.getAmplifier());
                    labelWidth = mc.font.width(label);
                    pX = movingX + IndicatorUtil.getTextOffsetX(this.potencyLocation, labelWidth, spriteSize);
                    Objects.requireNonNull(mc.font);
                    pY = movingY + IndicatorUtil.getTextOffsetY(this.potencyLocation, 9, spriteSize);
                    graphics.pose().pushPose();
                    graphics.pose().translate((double)pX * (1.0 - this.potencyScale), (double)pY * (1.0 - this.potencyScale), 0.0);
                    PoseStack poseStack = graphics.pose();
                    float f = IndicatorUtil.getScaleTranslateX(this.potencyLocation, labelWidth, (float)this.potencyScale);
                    Objects.requireNonNull(mc.font);
                    poseStack.translate(f, IndicatorUtil.getScaleTranslateY(this.potencyLocation, 9, (float)this.potencyScale), 0.0f);
                    graphics.pose().scale((float)this.potencyScale, (float)this.potencyScale, 0.0f);
                    if (this.potencyBack) {
                        Objects.requireNonNull(mc.font);
                        graphics.fill(pX - 1, pY - 1, pX + labelWidth, pY + 9 - 1, this.potencyBackColor);
                    }
                    graphics.drawString(mc.font, label, pX, pY, this.potencyColor, this.potencyShadow);
                    graphics.pose().popPose();
                }
                if (this.timerEnabled && (this.timerEnabledAmbient || !effect.isAmbient())) {
                    label = IndicatorUtil.getDurationAsString(effect.getDuration());
                    labelWidth = mc.font.width(label);
                    pX = movingX + IndicatorUtil.getTextOffsetX(this.timerLocation, labelWidth, spriteSize);
                    Objects.requireNonNull(mc.font);
                    pY = movingY + IndicatorUtil.getTextOffsetY(this.timerLocation, 9, spriteSize);
                    graphics.pose().pushPose();
                    graphics.pose().translate((double)pX * (1.0 - this.timerScale), (double)pY * (1.0 - this.timerScale), 0.0);
                    PoseStack poseStack = graphics.pose();
                    float f = IndicatorUtil.getScaleTranslateX(this.timerLocation, labelWidth, (float)this.timerScale);
                    Objects.requireNonNull(mc.font);
                    poseStack.translate(f, IndicatorUtil.getScaleTranslateY(this.timerLocation, 9, (float)this.timerScale), 0.0f);
                    graphics.pose().scale((float)this.timerScale, (float)this.timerScale, 0.0f);
                    if (this.timerBack) {
                        Objects.requireNonNull(mc.font);
                        graphics.fill(pX - 1, pY - 1, pX + labelWidth, pY + 9 - 1, this.timerBackColor);
                    }
                    graphics.drawString(mc.font, label, pX, pY, IndicatorUtil.getTimerColor(effect, this.timerColor, this.timerWarnEnabled, this.timerWarnTime, this.timerWarnColor, this.timerFlashEnabled), this.timerShadow);
                    graphics.pose().popPose();
                }
                if ((movingX += space) + space <= maxX) continue;
                movingX = x;
                movingY += space;
                targetHeight += space;
            }
            graphics.pose().popPose();
            return (int)((float)targetHeight * scale);
        }

        public void close() {
        }
    }
}

