/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.effecttimerplus.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.terminalmc.effecttimerplus.config.Config;
import dev.terminalmc.effecttimerplus.util.IndicatorUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class}, priority=2000)
public class MixinGui {
    @Final
    @Shadow
    private Minecraft minecraft;
    @Unique
    @Nullable
    private Runnable effectTimerPlus$runnable;

    @Inject(method={"renderEffects"}, at={@At(value="HEAD")})
    private void scale(GuiGraphics graphics, DeltaTracker delta, CallbackInfo ci) {
        float scale = (float)Config.get().scale;
        graphics.pose().pushPose();
        graphics.pose().translate((float)graphics.guiWidth() * (1.0f - scale), 0.0f, 0.0f);
        graphics.pose().scale(scale, scale, 0.0f);
    }

    @Inject(method={"renderEffects"}, at={@At(value="RETURN")})
    private void descale(GuiGraphics graphics, DeltaTracker delta, CallbackInfo ci) {
        graphics.pose().popPose();
    }

    @WrapOperation(method={"renderEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIII)V")})
    private void CreateOverlayRunnable(GuiGraphics graphics, Function<ResourceLocation, RenderType> function, ResourceLocation sprite, int x, int y, int width, int height, Operation<Void> original, @Local MobEffectInstance effectInstance) {
        original.call(new Object[]{graphics, function, sprite, x, y, width, height});
        Config options = Config.get();
        this.effectTimerPlus$runnable = () -> {
            int posY;
            int posX;
            int labelWidth;
            String label;
            if (options.potencyEnabled && effectInstance.getAmplifier() > 0) {
                label = IndicatorUtil.getAmplifierAsString(effectInstance.getAmplifier());
                labelWidth = this.minecraft.font.width(label);
                posX = x + IndicatorUtil.getTextOffsetX(options.potencyLocation, labelWidth, width);
                int n = options.potencyLocation;
                Objects.requireNonNull(this.minecraft.font);
                posY = y + IndicatorUtil.getTextOffsetY(n, 9, height);
                float scale = (float)Config.get().potencyScale;
                graphics.pose().pushPose();
                graphics.pose().translate((float)posX * (1.0f - scale), (float)posY * (1.0f - scale), 0.0f);
                PoseStack poseStack = graphics.pose();
                float f = IndicatorUtil.getScaleTranslateX(options.potencyLocation, labelWidth, scale);
                int n2 = options.potencyLocation;
                Objects.requireNonNull(this.minecraft.font);
                poseStack.translate(f, IndicatorUtil.getScaleTranslateY(n2, 9, scale), 0.0f);
                graphics.pose().scale(scale, scale, 0.0f);
                if (options.potencyBack) {
                    Objects.requireNonNull(this.minecraft.font);
                    graphics.fill(posX - 1, posY - 1, posX + labelWidth, posY + 9 - 1, options.potencyBackColor);
                }
                graphics.drawString(this.minecraft.font, label, posX, posY, options.potencyColor, options.potencyShadow);
                graphics.pose().popPose();
            }
            if (options.timerEnabled && (options.timerEnabledAmbient || !effectInstance.isAmbient())) {
                label = IndicatorUtil.getDurationAsString(effectInstance.getDuration());
                labelWidth = this.minecraft.font.width(label);
                posX = x + IndicatorUtil.getTextOffsetX(options.timerLocation, labelWidth, width);
                int n = options.timerLocation;
                Objects.requireNonNull(this.minecraft.font);
                posY = y + IndicatorUtil.getTextOffsetY(n, 9, height);
                int color = IndicatorUtil.getTimerColor(effectInstance, options.timerColor, options.timerWarnEnabled, options.timerWarnTime, options.timerWarnColor, options.timerFlashEnabled);
                float scale = (float)Config.get().timerScale;
                graphics.pose().pushPose();
                graphics.pose().translate((float)posX * (1.0f - scale), (float)posY * (1.0f - scale), 0.0f);
                PoseStack poseStack = graphics.pose();
                float f = IndicatorUtil.getScaleTranslateX(options.timerLocation, labelWidth, scale);
                int n3 = options.timerLocation;
                Objects.requireNonNull(this.minecraft.font);
                poseStack.translate(f, IndicatorUtil.getScaleTranslateY(n3, 9, scale), 0.0f);
                graphics.pose().scale(scale, scale, 0.0f);
                if (options.timerBack) {
                    Objects.requireNonNull(this.minecraft.font);
                    graphics.fill(posX - 1, posY - 1, posX + labelWidth, posY + 9 - 1, options.timerBackColor);
                }
                graphics.drawString(this.minecraft.font, label, posX, posY, color, options.timerShadow);
                graphics.pose().popPose();
            }
        };
    }

    @ModifyExpressionValue(method={"renderEffects"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z")})
    private boolean AddOverlayRunnable(boolean original, @Local List<Runnable> runnables) {
        if (this.effectTimerPlus$runnable != null) {
            runnables.add(this.effectTimerPlus$runnable);
            this.effectTimerPlus$runnable = null;
        }
        return original;
    }
}

