/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.minecraft_enhanced_snowman;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Configs {
    public static final Common COMMON;
    static final ModConfigSpec confSpec;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        confSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.DoubleValue snowballDamage;
        public final ModConfigSpec.BooleanValue onlyHostile;
        public final ModConfigSpec.BooleanValue playersDealDamage;
        public final ModConfigSpec.BooleanValue convert;
        public final ModConfigSpec.DoubleValue convert_chance;
        public final ModConfigSpec.BooleanValue slowness;
        public final ModConfigSpec.BooleanValue prevent_snow_trail;
        public final ModConfigSpec.BooleanValue disable_heat_damage;
        public final ModConfigSpec.BooleanValue disable_water_damage;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Snowman common settings");
            builder.push("common");
            this.snowballDamage = builder.comment("Damage dealt by one snowgolem snowball").defineInRange("snowballDamage", 1.0, 0.0, 100.0);
            this.onlyHostile = builder.comment("Only deal damage to hostile creatures").define("onlyHostile", true);
            this.playersDealDamage = builder.comment("Allow players to deal damage with snowballs").define("playersDealDamage", false);
            this.convert = builder.comment("Convert creatures killed by snowgolem to a snowgolem").define("convert", false);
            this.convert_chance = builder.comment("Chance of converting killed creature to a snowgolem if enabled").defineInRange("convert_chance", 1.0, 0.0, 1.0);
            this.slowness = builder.comment("Add a short freeze/slowness to a creature hit by a snowball").define("slowness", true);
            this.prevent_snow_trail = builder.comment("Prevent snowgolems from leaving a snow trail").define("prevent_snow_trail", false);
            this.disable_heat_damage = builder.comment("Prevent snowgolems from taking damage in hot biomes").define("disable_heat_damage", false);
            this.disable_water_damage = builder.comment("Prevent snowgolems from taking damage in rain (or in water)").define("disable_water_damage", false);
            builder.pop();
        }
    }
}

