/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.minecraft_enhanced_snowman;

import de.maxanier.minecraft_enhanced_snowman.Configs;
import java.util.Optional;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.apache.logging.log4j.LogManager;

@Mod(value="enhanced_snowman")
public class ModEnhancedSnowman {
    public static final String MOD_ID = "enhanced_snowman";
    public static ModEnhancedSnowman INSTANCE;

    public ModEnhancedSnowman(IEventBus modEventBus) {
        INSTANCE = this;
        NeoForge.EVENT_BUS.register((Object)this);
        Optional opt = ModList.get().getModContainerById(MOD_ID);
        if (opt.isPresent()) {
            LogManager.getLogger().info("Preparing Enhanced Snowman {}", (Object)((ModContainer)opt.get()).getModInfo().getVersion());
            ((ModContainer)opt.get()).registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configs.confSpec);
        } else {
            LogManager.getLogger().error("Somehow Enhanced Snowman could not be found");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDeath(LivingDeathEvent event) {
        if (((Boolean)Configs.COMMON.convert.get()).booleanValue() && event.getSource().getEntity() instanceof SnowGolem && (Double)Configs.COMMON.convert_chance.get() > Math.random()) {
            SnowGolem snowman = new SnowGolem(EntityType.SNOW_GOLEM, event.getEntity().getCommandSenderWorld());
            snowman.copyPosition((Entity)event.getEntity());
            event.getEntity().getCommandSenderWorld().addFreshEntity((Entity)snowman);
            event.getEntity().deathTime = 19;
        }
    }

    @SubscribeEvent
    public void onLivingBaseAttack(LivingIncomingDamageEvent event) {
        if (event.getAmount() == 0.0f && event.getSource().getDirectEntity() instanceof Snowball) {
            Snowball ball;
            if (event.getEntity().getCommandSenderWorld().isClientSide) {
                return;
            }
            if ((event.getSource().getEntity() instanceof SnowGolem || ((Boolean)Configs.COMMON.playersDealDamage.get()).booleanValue() && event.getSource().getEntity() instanceof Player) && (event.getEntity() instanceof Enemy || !((Boolean)Configs.COMMON.onlyHostile.get()).booleanValue()) && !(ball = (Snowball)event.getSource().getDirectEntity()).getPersistentData().contains("dealt_damage")) {
                ball.getPersistentData().putBoolean("dealt_damage", true);
                Entity indirectEntity = event.getSource().getEntity();
                LivingEntity indirectEntityLiving = indirectEntity instanceof LivingEntity ? (LivingEntity)indirectEntity : null;
                event.getEntity().hurt(event.getEntity().getCommandSenderWorld().damageSources().mobProjectile(event.getSource().getDirectEntity(), indirectEntityLiving), ((Double)Configs.COMMON.snowballDamage.get()).floatValue());
                if (((Boolean)Configs.COMMON.slowness.get()).booleanValue()) {
                    event.getEntity().addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 1));
                }
            }
        }
        if (((Boolean)Configs.COMMON.disable_heat_damage.get()).booleanValue() && event.getSource().is(DamageTypes.ON_FIRE) && event.getEntity().getType() == EntityType.SNOW_GOLEM) {
            event.setCanceled(true);
        }
        if (((Boolean)Configs.COMMON.disable_water_damage.get()).booleanValue() && event.getSource().is(DamageTypes.DROWN) && event.getEntity().getType() == EntityType.SNOW_GOLEM) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onMobGriefing(EntityMobGriefingEvent event) {
        if (((Boolean)Configs.COMMON.prevent_snow_trail.get()).booleanValue() && event.getEntity() instanceof SnowGolem) {
            event.setCanGrief(false);
        }
    }
}

