/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.expore;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ExpOreConfig {
    private static final File CONFIG_FILE = new File("config/expore-common.toml");
    public static int expOreMinExperience = 50;
    public static int expOreMaxExperience = 80;
    public static int deepslateExpOreMinExperience = 50;
    public static int deepslateExpOreMaxExperience = 80;
    public static int netherExpOreMinExperience = 50;
    public static int netherExpOreMaxExperience = 80;
    public static int endExpOreMinExperience = 50;
    public static int endExpOreMaxExperience = 80;

    public static void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            ExpOreConfig.saveConfig();
        } else {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                JsonObject config = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonObject expOreConfig = config.getAsJsonObject("expOre");
                expOreMinExperience = expOreConfig.get("minExperience").getAsInt();
                expOreMaxExperience = expOreConfig.get("maxExperience").getAsInt();
                JsonObject deepslateExpOreConfig = config.getAsJsonObject("deepslateExpOre");
                deepslateExpOreMinExperience = deepslateExpOreConfig.get("minExperience").getAsInt();
                deepslateExpOreMaxExperience = deepslateExpOreConfig.get("maxExperience").getAsInt();
                JsonObject netherExpOreConfig = config.getAsJsonObject("netherExpOre");
                netherExpOreMinExperience = netherExpOreConfig.get("minExperience").getAsInt();
                netherExpOreMaxExperience = netherExpOreConfig.get("maxExperience").getAsInt();
                JsonObject endExpOreConfig = config.getAsJsonObject("endExpOre");
                endExpOreMinExperience = endExpOreConfig.get("minExperience").getAsInt();
                endExpOreMaxExperience = endExpOreConfig.get("maxExperience").getAsInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig() {
        JsonObject config = new JsonObject();
        JsonObject expOreConfig = new JsonObject();
        expOreConfig.addProperty("minExperience", (Number)expOreMinExperience);
        expOreConfig.addProperty("maxExperience", (Number)expOreMaxExperience);
        config.add("expOre", (JsonElement)expOreConfig);
        JsonObject deepslateExpOreConfig = new JsonObject();
        deepslateExpOreConfig.addProperty("minExperience", (Number)deepslateExpOreMinExperience);
        deepslateExpOreConfig.addProperty("maxExperience", (Number)deepslateExpOreMaxExperience);
        config.add("deepslateExpOre", (JsonElement)deepslateExpOreConfig);
        JsonObject netherExpOreConfig = new JsonObject();
        netherExpOreConfig.addProperty("minExperience", (Number)netherExpOreMinExperience);
        netherExpOreConfig.addProperty("maxExperience", (Number)netherExpOreMaxExperience);
        config.add("netherExpOre", (JsonElement)netherExpOreConfig);
        JsonObject endExpOreConfig = new JsonObject();
        endExpOreConfig.addProperty("minExperience", (Number)endExpOreMinExperience);
        endExpOreConfig.addProperty("maxExperience", (Number)endExpOreMaxExperience);
        config.add("endExpOre", (JsonElement)endExpOreConfig);
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            writer.write(config.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            writer.write(gson.toJson((JsonElement)config));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

