/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.expore.world.feature;

import com.blocklegend001.expore.blocks.ModBlocks;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_EXP_ORE_KEY = ModConfiguredFeatures.createKey("overworld_exp_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_EXP_ORE_KEY = ModConfiguredFeatures.createKey("nether_exp_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> END_EXP_ORE_KEY = ModConfiguredFeatures.createKey("end_exp_ore");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplacable = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepSlateReplacable = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        BlockMatchTest netherRackReplacable = new BlockMatchTest(Blocks.NETHERRACK);
        BlockMatchTest endStoneReplacable = new BlockMatchTest(Blocks.END_STONE);
        List<OreConfiguration.TargetBlockState> overworldExpOre = List.of(OreConfiguration.target((RuleTest)stoneReplacable, (BlockState)((Block)ModBlocks.EXP_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepSlateReplacable, (BlockState)((Block)ModBlocks.DEEPSLATE_EXP_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> netherExpOre = List.of(OreConfiguration.target((RuleTest)netherRackReplacable, (BlockState)((Block)ModBlocks.NETHER_EXP_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> endExpOre = List.of(OreConfiguration.target((RuleTest)endStoneReplacable, (BlockState)((Block)ModBlocks.END_EXP_ORE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, NETHER_EXP_ORE_KEY, Feature.ORE, new OreConfiguration(netherExpOre, 7));
        ModConfiguredFeatures.register(context, END_EXP_ORE_KEY, Feature.ORE, new OreConfiguration(endExpOre, 7));
        ModConfiguredFeatures.register(context, OVERWORLD_EXP_ORE_KEY, Feature.ORE, new OreConfiguration(overworldExpOre, 7));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"expore", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
        context.register(key, (Object)new ConfiguredFeature(feature, config));
    }
}

