/*
 * Decompiled with CFR 0.152.
 */
package com.daxton.fancyclear;

import com.daxton.fancyclear.api.base.StringUtil;
import com.daxton.fancyclear.api.method.PlayerFunction;
import com.daxton.fancyclear.api.method.ServerFunction;
import com.daxton.fancyclear.command.CommandMain;
import com.daxton.fancyclear.config.FileConfig;
import com.daxton.fancyclear.key.FancyClearKeyMappings;
import com.daxton.fancyclear.listener.KeyBoardListener;
import com.daxton.fancyclear.listener.PlayerListener;
import com.daxton.fancyclear.listener.RenderListener;
import com.daxton.fancyclear.task.RunTask;
import com.daxton.fancyclear.task.ServerTask;
import com.daxton.fancydiscord.FancyDiscord;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.slf4j.Logger;

@Mod(value="fancyclear")
public class FancyClear {
    public static final String MODID = "fancyclear";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static FancyClear fancyClear;
    public static MinecraftServer minecraftServer;
    public static Minecraft minecraft;
    public static ItemRenderer itemRenderer;
    public static Font fontRenderer;

    public FancyClear(IEventBus modEventBus, ModContainer modContainer) {
        fancyClear = this;
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        minecraftServer = event.getServer();
        NeoForge.EVENT_BUS.register((Object)new PlayerListener());
        ServerTask.start();
        CommandMain.register((CommandDispatcher<CommandSourceStack>)event.getServer().getCommands().getDispatcher());
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppedEvent event) {
        RunTask.stopAction();
    }

    public static String getResourceFolder() {
        return "config/FancyClear/";
    }

    public static void sendPlayerMessage(ServerPlayer serverPlayer, String message) {
        if (serverPlayer == null || message == null || message.isEmpty()) {
            return;
        }
        String header = FileConfig.languageConfig.getString("Header");
        PlayerFunction.sendPlayerMessage(serverPlayer, header + message);
    }

    public static void sendAllPlayerMessage(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        String header = FileConfig.languageConfig.getString("Header");
        boolean show = FileConfig.config.getBoolean("PlayerMessage");
        if (show) {
            PlayerFunction.sendAllPlayerMessage(header + message);
        }
    }

    public static void sendLogger(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        String header = FileConfig.languageConfig.getString("Header");
        boolean log_show = FileConfig.config.getBoolean("ConsoleMessage");
        if (log_show) {
            ServerFunction.sendLogger(header + message);
        }
        FancyClear.sendDiscord(message);
    }

    public static void sendDiscord(String message) {
        boolean discord_show = FileConfig.config.getBoolean("DiscordMessage");
        if (discord_show && ModList.get().isLoaded("fancydiscord")) {
            String discordMessage = StringUtil.removeMinecraftColorCodes(message);
            FancyDiscord.discordBot.sendMessage(discordMessage);
        }
    }

    @EventBusSubscriber(modid="fancyclear", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            minecraft = Minecraft.getInstance();
            itemRenderer = minecraft.getItemRenderer();
            fontRenderer = FancyClear.minecraft.font;
            NeoForge.EVENT_BUS.register((Object)new RenderListener());
            NeoForge.EVENT_BUS.register((Object)new KeyBoardListener());
            FancyClearKeyMappings.registerKeys();
        }
    }
}

