/*
 * Decompiled with CFR 0.152.
 */
package com.daxton.fancyclear.api.been;

import com.daxton.fancyclear.api.method.DetectionDistance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;

public class FancyEntity {
    private final Entity entity;
    private final String name;
    private final String id;
    private String type;

    public FancyEntity(Entity entity) {
        this.entity = entity;
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            this.name = itemEntity.getName().getString();
            this.id = itemEntity.getItem().getItem().getDescriptionId();
            this.type = "ITEM";
        } else {
            TamableAnimal tamableAnimal;
            this.name = entity.getName().getString();
            this.id = entity.getType().getDescriptionId();
            this.type = "MOB";
            if (entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).getOwner() != null) {
                this.type = "PET";
            }
        }
    }

    public boolean outsidePlayer(float distance) {
        return DetectionDistance.outsidePlayer(this.entity, distance);
    }

    public boolean withinPlayer(float distance) {
        return DetectionDistance.withinPlayer(this.entity, distance);
    }

    public Entity getEntity() {
        return this.entity;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void remove() {
        if (this.entity != null) {
            this.entity.remove(Entity.RemovalReason.KILLED);
        }
    }
}

