/*
 * Decompiled with CFR 0.152.
 */
package com.daxton.fancyclear.api.configuration.file;

import com.daxton.fancyclear.api.configuration.serialization.ConfigurationSerialization;
import com.daxton.fancyclear.api.yaml.snakeyaml.constructor.SafeConstructor;
import com.daxton.fancyclear.api.yaml.snakeyaml.error.YAMLException;
import com.daxton.fancyclear.api.yaml.snakeyaml.nodes.MappingNode;
import com.daxton.fancyclear.api.yaml.snakeyaml.nodes.Node;
import com.daxton.fancyclear.api.yaml.snakeyaml.nodes.Tag;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlConstructor
extends SafeConstructor {
    public YamlConstructor() {
        this.yamlConstructors.put(Tag.MAP, new ConstructCustomObject(this));
    }

    @Override
    public void flattenMapping(@NotNull MappingNode node) {
        super.flattenMapping(node);
    }

    @Nullable
    public Object construct(@NotNull Node node) {
        return this.constructObject(node);
    }

    private class ConstructCustomObject
    extends SafeConstructor.ConstructYamlMap {
        private ConstructCustomObject(YamlConstructor yamlConstructor) {
            super(yamlConstructor);
        }

        @Override
        @Nullable
        public Object construct(@NotNull Node node) {
            if (node.isTwoStepsConstruction()) {
                throw new YAMLException("Unexpected referential mapping structure. Node: " + String.valueOf(node));
            }
            Map raw = (Map)super.construct(node);
            if (raw.containsKey("==")) {
                LinkedHashMap typed = new LinkedHashMap(raw.size());
                for (Map.Entry entry : raw.entrySet()) {
                    typed.put(entry.getKey().toString(), entry.getValue());
                }
                try {
                    return ConfigurationSerialization.deserializeObject(typed);
                }
                catch (IllegalArgumentException ex) {
                    throw new YAMLException("Could not deserialize object", ex);
                }
            }
            return raw;
        }

        @Override
        public void construct2ndStep(@NotNull Node node, @NotNull Object object) {
            throw new YAMLException("Unexpected referential mapping structure. Node: " + String.valueOf(node));
        }
    }
}

