/*
 * Decompiled with CFR 0.152.
 */
package com.daxton.fancyclear.api.method;

import com.daxton.fancyclear.FancyClear;
import com.daxton.fancyclear.api.been.FancyEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.joml.Matrix4f;

public class EntityFunction {
    public static Map<EntityRenderState, Entity> entityRenderMap = new ConcurrentHashMap<EntityRenderState, Entity>();

    public static List<FancyEntity> getWorldAllFancyEntity() {
        ArrayList<FancyEntity> fancyEntities = new ArrayList<FancyEntity>();
        MinecraftServer server = FancyClear.minecraftServer;
        server.getAllLevels().forEach(serverLevel -> serverLevel.getAllEntities().forEach(entity -> fancyEntities.add(new FancyEntity((Entity)entity))));
        return fancyEntities;
    }

    public static List<Entity> getWorldAllEntity() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        MinecraftServer server = FancyClear.minecraftServer;
        server.getAllLevels().forEach(serverLevel -> serverLevel.getAllEntities().forEach(entities::add));
        return entities;
    }

    public static Map<String, String> getAllEntityID() {
        HashMap<String, String> entityIDMap = new HashMap<String, String>();
        return entityIDMap;
    }

    public static Map<String, String> getAllMobID() {
        HashMap<String, String> mobIDMap = new HashMap<String, String>();
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            mobIDMap.put(entityType.getDescription().getString(), entityType.getDescriptionId());
        }
        return mobIDMap;
    }

    public static Map<String, String> getAllItemID() {
        HashMap<String, String> itemIDMap = new HashMap<String, String>();
        for (Item item : BuiltInRegistries.ITEM) {
            itemIDMap.put(item.getDescriptionId(), item.getDescriptionId());
        }
        return itemIDMap;
    }

    public static Map<String, String> getAllBlockID() {
        HashMap<String, String> blockIDList = new HashMap<String, String>();
        for (Block block : BuiltInRegistries.BLOCK) {
            blockIDList.put(block.getName().getString(), block.getDescriptionId());
        }
        return blockIDList;
    }

    public static void renderNameTag(Entity entity, String text, PoseStack poseStack, MultiBufferSource multiBufferSource) {
        float h = entity.getBbHeight() + 0.9f;
        poseStack.pushPose();
        poseStack.translate(0.0, (double)h, 0.0);
        poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        Font font = Minecraft.getInstance().font;
        float f = (float)(-font.width(text)) / 2.0f;
        int k = (int)(Minecraft.getInstance().options.getBackgroundOpacity(0.25f) * 255.0f) << 24;
        font.drawInBatch(text, f, 0.0f, -2130706433, false, matrix4f, multiBufferSource, Font.DisplayMode.NORMAL, k, 0xF00000);
        poseStack.popPose();
    }
}

