/*
 * Decompiled with CFR 0.152.
 */
package com.daxton.fancyclear.mixin;

import com.daxton.fancyclear.api.event.EntityRendererCallback;
import com.daxton.fancyclear.api.method.EntityFunction;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin {
    @Inject(at={@At(value="HEAD")}, method={"render*"}, cancellable=true)
    private void onEntityRender(EntityRenderState entityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, CallbackInfo ci) {
        Entity entity = EntityFunction.entityRenderMap.get(entityRenderState);
        EntityRendererCallback entityRendererCallback = new EntityRendererCallback(entityRenderState, entity, 0.0f, 0.0f, poseStack, multiBufferSource, light);
        if (((EntityRendererCallback)NeoForge.EVENT_BUS.post((Event)entityRendererCallback)).isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"extractRenderState"}, at={@At(value="HEAD")})
    public void onRender(Entity entity, EntityRenderState entityRenderState, float f, CallbackInfo ci) {
        EntityFunction.entityRenderMap.put(entityRenderState, entity);
    }
}

