/*
 * Decompiled with CFR 0.152.
 */
package com.daxton.fancyclear.task;

import com.daxton.fancyclear.FancyClear;
import com.daxton.fancyclear.api.been.FancyEntity;
import com.daxton.fancyclear.api.configuration.file.YamlConfiguration;
import com.daxton.fancyclear.api.method.DetectionDistance;
import com.daxton.fancyclear.api.method.EntityFunction;
import com.daxton.fancyclear.config.FileConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;

public class MobsTask {
    public static void saveId() {
        YamlConfiguration entityIdListConfig = YamlConfiguration.loadConfiguration(new File("config/FancyClear/entity-id-list.yml"));
        Map<String, String> mobIDMap = EntityFunction.getAllMobID();
        for (String string : mobIDMap.keySet()) {
            String mobID = mobIDMap.get(string);
            entityIdListConfig.set("mob-list." + string, mobID);
        }
        Map<String, String> itemIDMap = EntityFunction.getAllItemID();
        for (String itemName : itemIDMap.keySet()) {
            String itemID = itemIDMap.get(itemName);
            entityIdListConfig.set("item-list." + itemName, itemID);
        }
        Map<String, String> map = EntityFunction.getAllBlockID();
        for (String blockName : map.keySet()) {
            String blockID = map.get(blockName);
            entityIdListConfig.set("block-list." + blockName, blockID);
        }
        try {
            entityIdListConfig.save(new File("config/FancyClear/entity-id-list.yml"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void killAll() {
        MinecraftServer server = FancyClear.minecraftServer;
        AtomicInteger mob_amount = new AtomicInteger(0);
        AtomicInteger item_amount = new AtomicInteger(0);
        boolean clear_pet = FileConfig.config.getBoolean("Pet.Clear");
        boolean clear_mob = FileConfig.config.getBoolean("Mob.Clear");
        boolean clear_item = FileConfig.config.getBoolean("Item.Clear");
        boolean clear_custom_name = FileConfig.config.getBoolean("ClearHasCustomName");
        for (FancyEntity fancyEntity : EntityFunction.getWorldAllFancyEntity()) {
            if (fancyEntity.getType().equals("ITEM")) {
                item_amount.getAndIncrement();
                continue;
            }
            mob_amount.getAndIncrement();
        }
        int need_mob_amount = FileConfig.config.getInt("Mob.GreaterAmount");
        if (mob_amount.get() <= need_mob_amount) {
            clear_mob = false;
            clear_pet = false;
        }
        int need_item_amount = FileConfig.config.getInt("Item.GreaterAmount");
        if (item_amount.get() <= need_item_amount) {
            clear_item = false;
        }
        item_amount.set(0);
        mob_amount.set(0);
        HashSet<Entity> entitySet = new HashSet<Entity>();
        HashSet<String> itemList = new HashSet<String>(FileConfig.blackListConfig.getStringList("ItemBlackList"));
        boolean item_blacklist_to_whitelist = FileConfig.config.getBoolean("Item.BlackListToWhiteList");
        int item_away_form_player = FileConfig.config.getInt("Item.AwayFormPlayer");
        HashSet<String> mobList = new HashSet<String>(FileConfig.blackListConfig.getStringList("MobBlackList"));
        boolean mob_blacklist_to_whitelist = FileConfig.config.getBoolean("Mob.BlackListToWhiteList");
        int mob_away_form_player = FileConfig.config.getInt("Mob.AwayFormPlayer");
        for (Entity entity : EntityFunction.getWorldAllEntity()) {
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                if (!clear_item || item_away_form_player > 0 && DetectionDistance.withinPlayer(entity, item_away_form_player)) continue;
                if (item_blacklist_to_whitelist) {
                    if (!itemList.stream().anyMatch(itemEntity.getItem().getItem().getDescriptionId()::contains)) continue;
                    entitySet.add(entity);
                    item_amount.getAndIncrement();
                    continue;
                }
                if (!itemList.stream().noneMatch(itemEntity.getItem().getItem().getDescriptionId()::contains)) continue;
                entitySet.add(entity);
                item_amount.getAndIncrement();
                continue;
            }
            if (entity.hasCustomName() && !clear_custom_name) continue;
            if (entity instanceof TamableAnimal) {
                if (!clear_pet || mob_away_form_player > 0 && DetectionDistance.withinPlayer(entity, mob_away_form_player)) continue;
                if (mob_blacklist_to_whitelist) {
                    if (!mobList.stream().anyMatch(entity.getType().getDescriptionId()::contains)) continue;
                    entitySet.add(entity);
                    mob_amount.getAndIncrement();
                    continue;
                }
                if (!mobList.stream().noneMatch(entity.getType().getDescriptionId()::contains)) continue;
                entitySet.add(entity);
                mob_amount.getAndIncrement();
                continue;
            }
            if (!clear_mob || mob_away_form_player > 0 && DetectionDistance.withinPlayer(entity, mob_away_form_player)) continue;
            if (mob_blacklist_to_whitelist) {
                if (!mobList.stream().anyMatch(entity.getType().getDescriptionId()::contains)) continue;
                entitySet.add(entity);
                mob_amount.getAndIncrement();
                continue;
            }
            if (!mobList.stream().noneMatch(entity.getType().getDescriptionId()::contains)) continue;
            entitySet.add(entity);
            mob_amount.getAndIncrement();
        }
        try {
            server.execute(() -> entitySet.forEach(entity -> entity.remove(Entity.RemovalReason.KILLED)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String message = FileConfig.languageConfig.getString("Clear.remove");
        if (message != null) {
            message = message.replace("{mob}", String.valueOf(mob_amount.get())).replace("{item}", String.valueOf(item_amount.get()));
        }
        FancyClear.sendAllPlayerMessage(message);
        FancyClear.sendLogger(message);
    }
}

