/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.block.AbstractGaiaGrassBlock;
import androsa.gaiadimension.block.GaiaSoilBlock;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class AuraShootBlock
extends Block {
    public static final MapCodec<? extends AuraShootBlock> CODEC = AuraShootBlock.simpleCodec(AuraShootBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_5;
    public static final BooleanProperty IS_TOP = BooleanProperty.create((String)"is_top");
    private static final VoxelShape SHOOT_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TOP_SHOOT_SHAPE_1 = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private static final VoxelShape TOP_SHOOT_SHAPE_2 = Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
    private static final VoxelShape TOP_SHOOT_SHAPE_3 = Block.box((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape TOP_SHOOT_SHAPE = Shapes.or((VoxelShape)TOP_SHOOT_SHAPE_1, (VoxelShape[])new VoxelShape[]{TOP_SHOOT_SHAPE_2, TOP_SHOOT_SHAPE_3});

    public AuraShootBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)IS_TOP, (Comparable)Boolean.valueOf(true)));
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)IS_TOP)).booleanValue()) {
            return TOP_SHOOT_SHAPE;
        }
        return SHOOT_SHAPE;
    }

    @Deprecated
    public BlockState updateShape(BlockState stateIn, LevelReader reader, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (!stateIn.canSurvive(reader, currentPos)) {
            ticker.scheduleTick(currentPos, (Block)this, 1);
        }
        if (facing != Direction.UP) {
            return super.updateShape(stateIn, reader, ticker, currentPos, facing, facingPos, facingState, random);
        }
        Block block = facingState.getBlock();
        return (BlockState)stateIn.setValue((Property)IS_TOP, (Comparable)Boolean.valueOf(block != this));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Block block = context.getLevel().getBlockState(context.getClickedPos().above()).getBlock();
        return (BlockState)this.defaultBlockState().setValue((Property)IS_TOP, (Comparable)Boolean.valueOf(block != this));
    }

    @Deprecated
    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState soil = worldIn.getBlockState(pos.below());
        if (soil.canSustainPlant((BlockGetter)worldIn, pos.below(), Direction.UP, state).isTrue()) {
            return true;
        }
        Block block = worldIn.getBlockState(pos.below()).getBlock();
        return block == this || block instanceof AbstractGaiaGrassBlock || block instanceof GaiaSoilBlock;
    }

    @Deprecated
    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!state.canSurvive((LevelReader)worldIn, pos)) {
            worldIn.destroyBlock(pos, true);
        }
    }

    @Deprecated
    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (worldIn.isEmptyBlock(pos.above())) {
            int i = 1;
            while (worldIn.getBlockState(pos.below(i)).is((Block)this)) {
                ++i;
            }
            if (i < 15) {
                int j = (Integer)state.getValue((Property)AGE);
                if (CommonHooks.canCropGrow((Level)worldIn, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                    if (j == 5) {
                        worldIn.setBlockAndUpdate(pos.above(), this.defaultBlockState());
                        CommonHooks.fireCropGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
                        worldIn.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)IS_TOP, (Comparable)Boolean.valueOf(false)), 3);
                    } else {
                        worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 3);
                    }
                }
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, IS_TOP});
    }
}

