/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.block.AbstractGaiaGrassBlock;
import androsa.gaiadimension.registry.registration.ModBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrystalFungusBlock
extends BushBlock {
    public static final MapCodec<? extends CrystalFungusBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("cavernous").forGetter(obj -> obj.cavernous), (App)CrystalFungusBlock.propertiesCodec()).apply((Applicative)instance, CrystalFungusBlock::new));
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private final boolean cavernous;

    public CrystalFungusBlock(boolean isCave, BlockBehaviour.Properties props) {
        super(props);
        this.cavernous = isCave;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter worldIn, BlockPos pos) {
        if (this.cavernous) {
            return state.getBlock() == ModBlocks.gaia_stone.get() || state.getBlock() == ModBlocks.primal_mass.get() || state.getBlock() == ModBlocks.wasteland_stone.get() || state.getBlock() == ModBlocks.volcanic_rock.get();
        }
        return state.getBlock() instanceof AbstractGaiaGrassBlock;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        double d0 = (double)pos.getX() + rand.nextDouble() * 0.6 + 0.2;
        double d1 = (double)pos.getY() + rand.nextDouble() * 0.6 + 0.2;
        double d2 = (double)pos.getZ() + rand.nextDouble() * 0.6 + 0.2;
        worldIn.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

