/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block.blockentity;

import androsa.gaiadimension.block.LargeCrateBlock;
import androsa.gaiadimension.block.menu.LargeCrateMenu;
import androsa.gaiadimension.registry.registration.ModBlockEntities;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class LargeCrateBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS = IntStream.range(0, 54).toArray();
    private NonNullList<ItemStack> items = NonNullList.withSize((int)54, (Object)ItemStack.EMPTY);

    public LargeCrateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.LARGE_CRATE.get(), pos, state);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public Component getDefaultName() {
        return Component.translatable((String)"gaiadimension.container.large_crate");
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.loadFromNbt(compound, provider);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.saveToNbt(compound, provider);
    }

    public void loadFromNbt(CompoundTag compound, HolderLookup.Provider provider) {
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(compound) && compound.contains("Items", 9)) {
            ContainerHelper.loadAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)provider);
        }
    }

    public CompoundTag saveToNbt(CompoundTag compound, HolderLookup.Provider provider) {
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.items, (boolean)false, (HolderLookup.Provider)provider);
        }
        return compound;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int[] getSlotsForFace(Direction side) {
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, Direction direction) {
        return !(Block.byItem((Item)itemStackIn.getItem()) instanceof LargeCrateBlock);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new LargeCrateMenu(id, playerInventory, (Container)this);
    }
}

