/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block.blockentity;

import androsa.gaiadimension.block.RestructurerBlock;
import androsa.gaiadimension.block.menu.RestructurerMenu;
import androsa.gaiadimension.recipe.RestructurerRecipe;
import androsa.gaiadimension.registry.registration.ModBlockEntities;
import androsa.gaiadimension.registry.registration.ModDataMaps;
import androsa.gaiadimension.registry.registration.ModRecipes;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class RestructurerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{3, 1, 2, 4};
    private static final int[] slotsSides = new int[]{1, 2};
    private NonNullList<ItemStack> restructurerItemStacks = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    private int burnTime;
    private int burnDuration;
    private int cookTime;
    private int cookTimeTotal;
    protected final ContainerData slotsArray = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> RestructurerBlockEntity.this.burnTime;
                case 1 -> RestructurerBlockEntity.this.burnDuration;
                case 2 -> RestructurerBlockEntity.this.cookTime;
                case 3 -> RestructurerBlockEntity.this.cookTimeTotal;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    RestructurerBlockEntity.this.burnTime = value;
                }
                case 1: {
                    RestructurerBlockEntity.this.burnDuration = value;
                }
                case 2: {
                    RestructurerBlockEntity.this.cookTime = value;
                }
                case 3: {
                    RestructurerBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceKey<Recipe<?>>> recipeMap = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends RestructurerRecipe> cache = RecipeManager.createCheck((RecipeType)((RecipeType)ModRecipes.RESTRUCTURING.get()));

    public RestructurerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.RESTRUCTURER.get(), pos, state);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"gaiadimension.container.restructurer", (Object[])new Object[]{0});
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new RestructurerMenu(id, inventory, (Container)this, this.slotsArray);
    }

    public static int getFuelBurnTime(Item item) {
        Integer fuel = (Integer)item.builtInRegistryHolder().getData(ModDataMaps.GLITTERING_FUEL);
        return fuel != null ? fuel : 0;
    }

    public static int getSecondFuelBurnTime(Item item) {
        Integer fuel = (Integer)item.builtInRegistryHolder().getData(ModDataMaps.SHINING_FUEL);
        return fuel != null ? fuel : 0;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.restructurerItemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compound, this.restructurerItemStacks, (HolderLookup.Provider)provider);
        this.burnTime = compound.getInt("BurnTime");
        this.cookTime = compound.getInt("CookTime");
        this.cookTimeTotal = compound.getInt("CookTimeTotal");
        this.burnDuration = this.getItemBurnTime((ItemStack)this.restructurerItemStacks.get(1), (ItemStack)this.restructurerItemStacks.get(2));
        CompoundTag usedRecipes = compound.getCompound("RecipesUsed");
        for (String s : usedRecipes.getAllKeys()) {
            this.recipeMap.put((Object)ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)s)), usedRecipes.getInt(s));
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("BurnTime", this.burnTime);
        compound.putInt("CookTime", this.cookTime);
        compound.putInt("CookTimeTotal", (int)((short)this.cookTimeTotal));
        ContainerHelper.saveAllItems((CompoundTag)compound, this.restructurerItemStacks, (HolderLookup.Provider)provider);
        CompoundTag usedRecipes = new CompoundTag();
        this.recipeMap.forEach((key, i) -> usedRecipes.putInt(key.location().toString(), i.intValue()));
        compound.put("RecipesUsed", (Tag)usedRecipes);
    }

    public static void tick(ServerLevel level, BlockPos pos, BlockState state, RestructurerBlockEntity entity) {
        boolean burning = entity.isBurning();
        boolean burn = false;
        if (entity.isBurning()) {
            --entity.burnTime;
        }
        ItemStack input = (ItemStack)entity.restructurerItemStacks.get(0);
        ItemStack goldStack = (ItemStack)entity.restructurerItemStacks.get(1);
        ItemStack essenceStack = (ItemStack)entity.restructurerItemStacks.get(2);
        if (entity.isBurning() || !goldStack.isEmpty() && !essenceStack.isEmpty()) {
            SingleRecipeInput recipeInput = new SingleRecipeInput(input);
            RecipeHolder recipeHolder = !((ItemStack)entity.restructurerItemStacks.get(0)).isEmpty() ? (RecipeHolder)entity.cache.getRecipeFor((RecipeInput)recipeInput, level).orElse(null) : null;
            if (!entity.isBurning() && entity.canChange(level.registryAccess(), (RecipeHolder<? extends RestructurerRecipe>)recipeHolder, recipeInput, entity.restructurerItemStacks, entity.getMaxStackSize())) {
                entity.burnDuration = entity.burnTime = entity.getItemBurnTime(goldStack, essenceStack);
                if (entity.isBurning()) {
                    burn = true;
                    ItemStack goldRemain = goldStack.getCraftingRemainder();
                    if (!goldRemain.isEmpty()) {
                        entity.restructurerItemStacks.set(1, (Object)goldRemain);
                    } else if (!goldStack.isEmpty()) {
                        goldStack.shrink(1);
                        if (goldStack.isEmpty()) {
                            entity.restructurerItemStacks.set(1, (Object)goldRemain);
                        }
                    }
                    ItemStack essenceRemain = essenceStack.getCraftingRemainder();
                    if (!essenceRemain.isEmpty()) {
                        entity.restructurerItemStacks.set(2, (Object)essenceRemain);
                    } else if (!essenceStack.isEmpty()) {
                        essenceStack.shrink(1);
                        if (essenceStack.isEmpty()) {
                            entity.restructurerItemStacks.set(2, (Object)essenceRemain);
                        }
                    }
                }
            }
            if (entity.isBurning() && entity.canChange(level.registryAccess(), (RecipeHolder<? extends RestructurerRecipe>)recipeHolder, recipeInput, entity.restructurerItemStacks, entity.getMaxStackSize())) {
                ++entity.cookTime;
                if (entity.cookTime == entity.cookTimeTotal) {
                    entity.cookTime = 0;
                    entity.cookTimeTotal = RestructurerBlockEntity.cookingTime(level, entity);
                    if (entity.changeItem(level.registryAccess(), (RecipeHolder<? extends RestructurerRecipe>)recipeHolder, recipeInput, entity.restructurerItemStacks, entity.getMaxStackSize())) {
                        entity.setRecipeUsed(recipeHolder);
                    }
                    burn = true;
                }
            } else {
                entity.cookTime = 0;
            }
        } else if (!entity.isBurning() && entity.cookTime > 0) {
            entity.cookTime = Mth.clamp((int)(entity.cookTime - 2), (int)0, (int)entity.cookTimeTotal);
        }
        if (burning != entity.isBurning()) {
            burn = true;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)RestructurerBlock.LIT, (Comparable)Boolean.valueOf(entity.isBurning())));
        }
        if (burn) {
            RestructurerBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean canChange(RegistryAccess access, RecipeHolder<? extends RestructurerRecipe> recipe, SingleRecipeInput input, NonNullList<ItemStack> stacks, int stacksize) {
        if (!((ItemStack)stacks.get(0)).isEmpty() && recipe != null) {
            ItemStack slot1 = ((RestructurerRecipe)recipe.value()).assemble(input, (HolderLookup.Provider)access);
            ItemStack slot2 = ((RestructurerRecipe)recipe.value()).byproduct();
            if (slot1.isEmpty() && slot2.isEmpty() || slot1.isEmpty()) {
                return false;
            }
            ItemStack output = (ItemStack)stacks.get(3);
            ItemStack byproduct = (ItemStack)stacks.get(4);
            if (output.isEmpty() && byproduct.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)output, (ItemStack)slot1) || !ItemStack.isSameItem((ItemStack)byproduct, (ItemStack)slot2)) {
                return false;
            }
            if (output.getCount() + slot1.getCount() <= stacksize && output.getCount() + slot1.getCount() <= output.getMaxStackSize() && byproduct.getCount() + slot2.getCount() <= stacksize && byproduct.getCount() + slot2.getCount() <= byproduct.getMaxStackSize()) {
                return true;
            }
            return output.getCount() + slot1.getCount() <= output.getMaxStackSize() && byproduct.getCount() + slot2.getCount() <= byproduct.getMaxStackSize();
        }
        return false;
    }

    private boolean changeItem(RegistryAccess access, RecipeHolder<? extends RestructurerRecipe> recipe, SingleRecipeInput recipeInput, NonNullList<ItemStack> stacks, int stacksize) {
        if (recipe != null && this.canChange(access, recipe, recipeInput, stacks, stacksize)) {
            ItemStack input = (ItemStack)stacks.get(0);
            ItemStack slot1 = ((RestructurerRecipe)recipe.value()).result();
            ItemStack slot2 = ((RestructurerRecipe)recipe.value()).byproduct();
            ItemStack output = (ItemStack)stacks.get(3);
            ItemStack byproduct = (ItemStack)stacks.get(4);
            if (output.isEmpty()) {
                stacks.set(3, (Object)slot1.copy());
            } else if (output.getItem() == slot1.getItem()) {
                output.grow(slot1.getCount());
            }
            if (!slot2.isEmpty()) {
                if (byproduct.isEmpty()) {
                    stacks.set(4, (Object)slot2.copy());
                } else if (byproduct.getItem() == slot2.getItem()) {
                    byproduct.grow(slot2.getCount());
                }
            }
            input.shrink(1);
            return true;
        }
        return false;
    }

    public int getItemBurnTime(ItemStack stack1, ItemStack stack2) {
        if (stack1.isEmpty() || stack2.isEmpty()) {
            return 0;
        }
        Item itemGlitter = stack1.getItem();
        Item itemShine = stack2.getItem();
        return (RestructurerBlockEntity.getFuelBurnTime(itemGlitter) + RestructurerBlockEntity.getSecondFuelBurnTime(itemShine)) / 2;
    }

    private static int cookingTime(ServerLevel level, RestructurerBlockEntity container) {
        SingleRecipeInput input = new SingleRecipeInput(container.getItem(0));
        return container.cache.getRecipeFor((RecipeInput)input, level).map(recipe -> ((RestructurerRecipe)recipe.value()).cookTime()).orElse(200);
    }

    public static boolean isItemFuel(ItemStack stack) {
        Item item = stack.getItem();
        return RestructurerBlockEntity.getFuelBurnTime(item) > 0 || RestructurerBlockEntity.getSecondFuelBurnTime(item) > 0;
    }

    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return slotsBottom;
        }
        return side == Direction.UP ? slotsTop : slotsSides;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index == 1 || index == 2) {
            Item item = stack.getItem();
            return item == Items.WATER_BUCKET || item == Items.BUCKET;
        }
        return true;
    }

    public int getContainerSize() {
        return this.restructurerItemStacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.restructurerItemStacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.restructurerItemStacks.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.restructurerItemStacks, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.restructurerItemStacks, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        Level level;
        ItemStack itemstack = (ItemStack)this.restructurerItemStacks.get(index);
        boolean burning = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack);
        this.restructurerItemStacks.set(index, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        if (index == 0 && !burning && (level = this.level) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.cookTimeTotal = RestructurerBlockEntity.cookingTime(server, this);
            this.cookTime = 0;
            this.setChanged();
        }
    }

    protected NonNullList<ItemStack> getItems() {
        return this.restructurerItemStacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.restructurerItemStacks = stacks;
    }

    public boolean stillValid(Player player) {
        return this.level.getBlockEntity(this.worldPosition) == this && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index != 3 && index != 4 && (index == 0 || RestructurerBlockEntity.isItemFuel(stack));
    }

    public void clearContent() {
        this.restructurerItemStacks.clear();
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            this.recipeMap.addTo((Object)recipe.id(), 1);
        }
    }

    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player player, List<ItemStack> stacks) {
    }

    public void awardRecipe(ServerPlayer player) {
        List<RecipeHolder<?>> list = this.unlockRecipe(player.serverLevel(), player.position());
        player.awardRecipes(list);
        for (RecipeHolder<?> holder : list) {
            if (holder == null) continue;
            player.triggerRecipeCrafted(holder, this.restructurerItemStacks);
        }
        this.recipeMap.clear();
    }

    public List<RecipeHolder<?>> unlockRecipe(ServerLevel level, Vec3 position) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipeMap.object2IntEntrySet()) {
            level.recipeAccess().byKey((ResourceKey)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                RestructurerBlockEntity.grantExperience(level, position, entry.getIntValue(), ((RestructurerRecipe)recipe.value()).experience());
            });
        }
        return list;
    }

    private static void grantExperience(ServerLevel level, Vec3 position, int amount, float multiplier) {
        int i = Mth.floor((float)((float)amount * multiplier));
        float f = Mth.frac((float)((float)amount * multiplier));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)position, (int)i);
    }

    public void fillStackedContents(StackedItemContents helper) {
        for (ItemStack itemstack : this.restructurerItemStacks) {
            helper.accountStack(itemstack);
        }
    }
}

