/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block.menu;

import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModMenus;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class AgateCraftingTableMenu
extends RecipeBookMenu {
    private final CraftingContainer invCrafting = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer invResult = new ResultContainer();
    private final ContainerLevelAccess worldPos;
    private final Player player;

    public AgateCraftingTableMenu(int id, Inventory player) {
        this(id, player, ContainerLevelAccess.NULL);
    }

    public AgateCraftingTableMenu(int id, Inventory player, ContainerLevelAccess world) {
        super((MenuType)ModMenus.AGATE_CRAFTING_TABLE.get(), id);
        this.worldPos = world;
        this.player = player.player;
        this.addSlot((Slot)new ResultSlot(player.player, this.invCrafting, (Container)this.invResult, 0, 124, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.invCrafting, j + i * 3, 30 + j * 18, 17 + i * 18));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)player, i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)player, l, 8 + l * 18, 142));
        }
    }

    public void slotsChanged(Container inventoryIn) {
        this.worldPos.execute((world, pos) -> {
            if (world instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)world;
                AgateCraftingTableMenu.updateSlots((AbstractContainerMenu)this, server, this.player, this.invCrafting, this.invResult, null);
            }
        });
    }

    protected static void updateSlots(AbstractContainerMenu menu, ServerLevel world, Player playerentity, CraftingContainer craft, ResultContainer result, RecipeHolder<CraftingRecipe> holder) {
        CraftingInput input = craft.asCraftInput();
        ServerPlayer serverplayerentity = (ServerPlayer)playerentity;
        ItemStack itemstack = ItemStack.EMPTY;
        Optional optional = world.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, (Level)world);
        if (optional.isPresent()) {
            ItemStack assembled;
            RecipeHolder icraftingrecipe = (RecipeHolder)optional.get();
            CraftingRecipe crafting = (CraftingRecipe)icraftingrecipe.value();
            if (result.setRecipeUsed(serverplayerentity, icraftingrecipe) && (assembled = crafting.assemble((RecipeInput)input, (HolderLookup.Provider)world.registryAccess())).isItemEnabled(world.enabledFeatures())) {
                itemstack = assembled;
            }
        }
        result.setItem(0, itemstack);
        menu.setRemoteSlot(0, itemstack);
        serverplayerentity.connection.send((Packet)new ClientboundContainerSetSlotPacket(menu.containerId, menu.incrementStateId(), 0, itemstack));
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.worldPos.execute((world, pos) -> this.clearContainer(playerIn, (Container)this.invCrafting));
    }

    public boolean stillValid(Player playerIn) {
        return AgateCraftingTableMenu.stillValid((ContainerLevelAccess)this.worldPos, (Player)playerIn, (Block)((Block)ModBlocks.agate_crafting_table.get()));
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                this.worldPos.execute((world, pos) -> itemstack1.getItem().onCraftedBy(itemstack1, world, playerIn));
                if (!this.moveItemStackTo(itemstack1, 10, 46, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index >= 10 && index < 37 ? !this.moveItemStackTo(itemstack1, 37, 46, false) : (index >= 37 && index < 46 ? !this.moveItemStackTo(itemstack1, 10, 37, false) : !this.moveItemStackTo(itemstack1, 10, 46, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
            if (index == 0) {
                playerIn.drop(itemstack1, false);
            }
        }
        return itemstack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeBookMenu.PostPlaceAction handlePlacement(boolean maxItems, boolean creative, RecipeHolder<?> recipe, ServerLevel server, Inventory inventory) {
        RecipeBookMenu.PostPlaceAction action;
        RecipeHolder<?> recipeholder = recipe;
        try {
            List list = this.slots.subList(1, 10);
            action = ServerPlaceRecipe.placeRecipe((ServerPlaceRecipe.CraftingMenuAccess)new ServerPlaceRecipe.CraftingMenuAccess<CraftingRecipe>(){

                public void fillCraftSlotsStackedContents(StackedItemContents contents) {
                    AgateCraftingTableMenu.this.fillCraftSlotsStackedContents(contents);
                }

                public void clearCraftingContent() {
                    AgateCraftingTableMenu.this.invResult.clearContent();
                    AgateCraftingTableMenu.this.invCrafting.clearContent();
                }

                public boolean recipeMatches(RecipeHolder<CraftingRecipe> match) {
                    return ((CraftingRecipe)match.value()).matches((RecipeInput)AgateCraftingTableMenu.this.invCrafting.asCraftInput(), AgateCraftingTableMenu.this.player.level());
                }
            }, (int)3, (int)3, (List)list, (List)list, (Inventory)inventory, recipeholder, (boolean)maxItems, (boolean)creative);
        }
        finally {
            AgateCraftingTableMenu.updateSlots((AbstractContainerMenu)this, server, this.player, this.invCrafting, this.invResult, recipe);
        }
        return action;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.invResult && super.canTakeItemForPickAll(stack, slotIn);
    }

    public void fillCraftSlotsStackedContents(StackedItemContents contents) {
        this.invCrafting.fillStackedContents(contents);
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }
}

