/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block.menu.slots;

import androsa.gaiadimension.block.blockentity.PurifierBlockEntity;
import androsa.gaiadimension.registry.helpers.EventHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class PurifyOutputSlot
extends Slot {
    private final Player thePlayer;
    private int stackSize;

    public PurifyOutputSlot(Player player, Container inv, int index, int positionX, int positionY) {
        super(inv, index, positionX, positionY);
        this.thePlayer = player;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public ItemStack remove(int par1) {
        if (this.hasItem()) {
            this.stackSize += Math.min(par1, this.getItem().getCount());
        }
        return super.remove(par1);
    }

    public void onTake(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        super.onTake(player, stack);
    }

    protected void onQuickCraft(ItemStack par1ItemStack, int par2) {
        this.stackSize += par2;
        this.checkTakeAchievements(par1ItemStack);
    }

    protected void checkTakeAchievements(ItemStack par1ItemStack) {
        par1ItemStack.onCraftedBy(this.thePlayer.level(), this.thePlayer, this.stackSize);
        Player player = this.thePlayer;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((PurifierBlockEntity)this.container).awardRecipe(serverPlayer);
        }
        this.stackSize = 0;
        NeoForge.EVENT_BUS.post((Event)new EventHandler.ItemPurifiedEvent(this.thePlayer, par1ItemStack));
    }
}

