/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data;

import androsa.gaiadimension.data.provider.GaiaBiomeProvider;
import androsa.gaiadimension.registry.bootstrap.GaiaBiomes;
import androsa.gaiadimension.registry.registration.ModEntities;
import androsa.gaiadimension.world.chunk.warp.TerrainPoint;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class GaiaBiomeMaker
extends GaiaBiomeProvider {
    public static void init(BootstrapContext<Biome> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter worldCarvers = context.lookup(Registries.CONFIGURED_CARVER);
        context.register(GaiaBiomes.pink_agate_forest, (Object)GaiaBiomeMaker.makePinkAgateForest((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.blue_agate_taiga, (Object)GaiaBiomeMaker.makeBlueAgateTaiga((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.green_agate_jungle, (Object)GaiaBiomeMaker.makeGreenAgateJungle((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.purple_agate_swamp, (Object)GaiaBiomeMaker.makePurpleAgateSwamp((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.fossil_woodland, (Object)GaiaBiomeMaker.makeFossilWoodland((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.mutant_agate_wildwood, (Object)GaiaBiomeMaker.makeMutantAgateWildwood((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.volcanic_lands, (Object)GaiaBiomeMaker.makeVolcanicLands((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.static_wasteland, (Object)GaiaBiomeMaker.makeStaticWasteland((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.goldstone_lands, (Object)GaiaBiomeMaker.makeGoldstoneLands((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.crystal_plains, (Object)GaiaBiomeMaker.makeCrystalPlains((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.salt_dunes, (Object)GaiaBiomeMaker.makeSaltDunes((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.mookaite_mesa, (Object)GaiaBiomeMaker.makeMookaite((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.shining_grove, (Object)GaiaBiomeMaker.makeShiningGrove((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.smoldering_bog, (Object)GaiaBiomeMaker.makeSmolderingBog((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.mineral_reservoir, (Object)GaiaBiomeMaker.makeMineralReservoir((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.mineral_river, (Object)GaiaBiomeMaker.makeMineralRiver((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.golden_forest, (Object)GaiaBiomeMaker.makeGoldenForest((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.golden_plains, (Object)GaiaBiomeMaker.makeGoldenPlains((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.golden_hills, (Object)GaiaBiomeMaker.makeGoldenHills((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.golden_sands, (Object)GaiaBiomeMaker.makeGoldenSands((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(GaiaBiomes.golden_marsh, (Object)GaiaBiomeMaker.makeGoldenMarsh((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
    }

    public static List<Pair<TerrainPoint, Holder<Biome>>> makeBiomeList(HolderGetter<Biome> registry) {
        return List.of(GaiaBiomeMaker.pairBiome(registry, 0.1f, 0.2f, GaiaBiomes.blue_agate_taiga), GaiaBiomeMaker.pairBiome(registry, 0.05f, 0.05f, GaiaBiomes.crystal_plains), GaiaBiomeMaker.pairBiome(registry, 0.1f, 0.05f, GaiaBiomes.fossil_woodland), GaiaBiomeMaker.pairBiome(registry, 0.125f, 0.05f, GaiaBiomes.goldstone_lands), GaiaBiomeMaker.pairBiome(registry, 0.1f, 0.2f, GaiaBiomes.green_agate_jungle), GaiaBiomeMaker.pairBiome(registry, 0.35f, 0.15f, GaiaBiomes.golden_forest), GaiaBiomeMaker.pairBiome(registry, 0.8f, 0.5f, GaiaBiomes.golden_hills), GaiaBiomeMaker.pairBiome(registry, 0.15f, 0.05f, GaiaBiomes.golden_marsh), GaiaBiomeMaker.pairBiome(registry, 0.35f, 0.1f, GaiaBiomes.golden_plains), GaiaBiomeMaker.pairBiome(registry, 0.25f, 0.05f, GaiaBiomes.golden_sands), GaiaBiomeMaker.pairBiome(registry, -1.8f, 0.1f, GaiaBiomes.mineral_reservoir), GaiaBiomeMaker.pairBiome(registry, -0.8f, 0.0f, GaiaBiomes.mineral_river), GaiaBiomeMaker.pairBiome(registry, 2.0f, 0.075f, GaiaBiomes.mookaite_mesa), GaiaBiomeMaker.pairBiome(registry, 0.1f, 0.1f, GaiaBiomes.mutant_agate_wildwood), GaiaBiomeMaker.pairBiome(registry, 0.1f, 0.1f, GaiaBiomes.pink_agate_forest), GaiaBiomeMaker.pairBiome(registry, 0.0f, 0.05f, GaiaBiomes.purple_agate_swamp), GaiaBiomeMaker.pairBiome(registry, 0.2f, 0.05f, GaiaBiomes.salt_dunes), GaiaBiomeMaker.pairBiome(registry, 0.4f, 0.05f, GaiaBiomes.shining_grove), GaiaBiomeMaker.pairBiome(registry, 0.2f, 0.02f, GaiaBiomes.smoldering_bog), GaiaBiomeMaker.pairBiome(registry, 3.0f, 0.05f, GaiaBiomes.static_wasteland), GaiaBiomeMaker.pairBiome(registry, 1.0f, 0.7f, GaiaBiomes.volcanic_lands));
    }

    private static Pair<TerrainPoint, Holder<Biome>> pairBiome(HolderGetter<Biome> registry, float depth, float scale, ResourceKey<Biome> biome) {
        return Pair.of((Object)new TerrainPoint(depth, scale), (Object)registry.getOrThrow(biome));
    }

    public static Biome makePinkAgateForest(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(15901620, 13016408, 15381216), GaiaBiomeMaker.pinkAgateForest(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.GROWTH_SAPPER, 20, 3, 5)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.AGATE_GOLEM, 15, 1, 3)))).temperature(0.66f));
    }

    public static Biome makeBlueAgateTaiga(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(6851272, 9815527, 15381216), GaiaBiomeMaker.blueAgateTaiga(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.HOWLITE_WOLF, 15, 2, 4)).addSpawn(MobCategory.MONSTER, GaiaBiomeMaker.mobData(ModEntities.BLUE_HOWLITE_WOLF, 1, 1, 1)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.GROWTH_SAPPER, 20, 3, 5)))).temperature(0.4f));
    }

    public static Biome makeGreenAgateJungle(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(4961870, 8437662, 15381216), GaiaBiomeMaker.greenAgateJungle(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.GROWTH_SAPPER, 20, 3, 5)).addSpawn(MobCategory.AMBIENT, GaiaBiomeMaker.mobData(ModEntities.MARKUZAR_PLANT, 15, 2, 4)))).temperature(0.75f));
    }

    public static Biome makePurpleAgateSwamp(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(8417209, 11234801, 15381216), GaiaBiomeMaker.purpleAgateSwamp(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.GROWTH_SAPPER, 20, 3, 5)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.SPELLBOUND_ELEMENTAL, 10, 2, 4)))).temperature(0.66f));
    }

    public static Biome makeFossilWoodland(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(12298105, 13016408, 15381216), GaiaBiomeMaker.fossilWoodland(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.MONSTER, GaiaBiomeMaker.mobData(ModEntities.ANCIENT_LAGRAHK, 10, 1, 2)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.ROCKY_LUGGEROTH, 10, 4, 5)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.RUGGED_LURMORUS, 10, 1, 3)))).temperature(0.66f));
    }

    public static Biome makeMutantAgateWildwood(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(13948848, 15833793, 15381216), GaiaBiomeMaker.mutantAgateWildwood(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.GROWTH_SAPPER, 40, 3, 5)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.MUTANT_GROWTH_EXTRACTOR, 5, 2, 4)))).temperature(0.66f));
    }

    public static Biome makeVolcanicLands(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(0x232323, 4922905, 16086896), GaiaBiomeMaker.volcanicLands(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.MONSTER, GaiaBiomeMaker.mobData(ModEntities.LESSER_SPITFIRE, 10, 2, 4)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.NOMADIC_LAGRAHK, 15, 1, 3)))).temperature(0.9f));
    }

    public static Biome makeStaticWasteland(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(2837910, 2633554, 5690794), GaiaBiomeMaker.staticWasteland(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.MONSTER, GaiaBiomeMaker.mobData(ModEntities.LESSER_SHOCKSHOOTER, 10, 2, 4)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.NOMADIC_LAGRAHK, 15, 1, 3)))).temperature(0.4f));
    }

    public static Biome makeGoldstoneLands(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(0x232323, 0x222222, 12352044), GaiaBiomeMaker.goldstoneLands(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.MONSTER, GaiaBiomeMaker.mobData(ModEntities.CORRUPT_SAPPER, 20, 2, 4)).addSpawn(MobCategory.MONSTER, GaiaBiomeMaker.mobData(ModEntities.CONTORTED_NAGA, 10, 2, 3)))).temperature(0.55f));
    }

    public static Biome makeCrystalPlains(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(15901620, 13016408, 15381216), GaiaBiomeMaker.crystalPlains(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.GROWTH_SAPPER, 20, 4, 6)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.CRYSTAL_GOLEM, 15, 1, 3)))).temperature(0.66f));
    }

    public static Biome makeSaltDunes(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(15901620, 13016408, 15381216), GaiaBiomeMaker.saltDunes(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.NOMADIC_LAGRAHK, 15, 1, 3)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.SALTION, 15, 1, 3)))).temperature(0.8f));
    }

    public static Biome makeSmolderingBog(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(0x262627, 0x111112, 0x322B33, 8284598), GaiaBiomeMaker.smolderingBog(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.BISMUTH_ULETRUS, 20, 2, 3)))).temperature(0.9f));
    }

    public static Biome makeShiningGrove(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(7982765, 0xDDF7FF, 15004627, 16764489), GaiaBiomeMaker.shiningGrove(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.NOMADIC_LAGRAHK, 15, 1, 1)))).temperature(0.5f));
    }

    public static Biome makeMineralReservoir(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(15901620, 13016408, 15381216), GaiaBiomeMaker.mineralBiome(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.WATER_CREATURE, GaiaBiomeMaker.mobData(ModEntities.MINERAL_ARENTHIS, 10, 1, 4)))).temperature(0.66f));
    }

    public static Biome makeSaltyCoast(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(15901620, 13016408, 15381216), GaiaBiomeMaker.mineralBiome(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns())).temperature(0.66f));
    }

    public static Biome makeMineralRiver(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(15901620, 13016408, 15381216), GaiaBiomeMaker.mineralBiome(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns())).temperature(0.66f));
    }

    public static Biome makeGoldenHills(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(4997150, 3415307, 13801728), GaiaBiomeMaker.goldenHillsBiome(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.AUREATE_EVRAUN, 20, 1, 2)))).temperature(0.3f));
    }

    public static Biome makeGoldenForest(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(4997150, 3415307, 13801728), GaiaBiomeMaker.goldenForestBiome(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.GROWTH_GRAZER, 20, 2, 4)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.AUREATE_EVRAUN, 20, 1, 2)))).temperature(0.3f));
    }

    public static Biome makeGoldenPlains(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(4997150, 3415307, 13801728), GaiaBiomeMaker.goldenPlainsBiome(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.GROWTH_GRAZER, 20, 2, 4)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.AUREATE_EVRAUN, 20, 1, 2)))).temperature(0.3f));
    }

    public static Biome makeGoldenMarsh(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(4997150, 3415307, 13801728), GaiaBiomeMaker.goldenMarshBiome(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.AUREATE_EVRAUN, 20, 1, 2)))).temperature(0.3f));
    }

    public static Biome makeGoldenSands(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(4997150, 3415307, 13801728), GaiaBiomeMaker.goldenSandsBiome(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.AUREATE_EVRAUN, 20, 1, 2)))).temperature(0.7f));
    }

    public static Biome makeMookaite(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return GaiaBiomeMaker.buildBiome(GaiaBiomeMaker.createBuilder(GaiaBiomeMaker.createAmbience(14646073, 16165141, 12793637), GaiaBiomeMaker.mookaiteMesa(features, carvers), GaiaBiomeMaker.buildSpawns(GaiaBiomeMaker.createSpawns().addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.MOOKAITE_CONSTRUCT, 10, 1, 2)).addSpawn(MobCategory.CREATURE, GaiaBiomeMaker.mobData(ModEntities.OPALITE_CONSTRUCT, 10, 1, 2)))).temperature(0.65f));
    }
}

