/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data;

import androsa.gaiadimension.advancement.criterion.SapperPredicate;
import androsa.gaiadimension.data.provider.GaiaBlockLootTableProvider;
import androsa.gaiadimension.data.provider.GaiaEntityLootTableProvider;
import androsa.gaiadimension.entity.data.SapperVariant;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModEntities;
import androsa.gaiadimension.registry.registration.ModItems;
import androsa.gaiadimension.registry.values.GaiaBuiltinTables;
import androsa.gaiadimension.registry.values.GaiaChestTables;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;

public class GaiaLootTables
extends LootTableProvider {
    public static final float[] leaf_chances = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public GaiaLootTables(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, GaiaBuiltinTables.builtin(), List.of(new LootTableProvider.SubProviderEntry(Blocks::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(Entities::new, LootContextParamSets.ENTITY), new LootTableProvider.SubProviderEntry(Chests::new, LootContextParamSets.CHEST)), provider);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector collector) {
    }

    public record Chests(HolderLookup.Provider provider) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(GaiaChestTables.CHESTS_MINITOWER_AMETHYST, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.purple_geode_slice.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.pyrite.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.scaynyx_ingot.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.sugilite_axe.get())).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.proustite.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModBlocks.amethyst_bricks.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)9.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.old_bow.get())).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.agate_arrow.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.white_opal.get())))));
            consumer.accept(GaiaChestTables.CHESTS_MINITOWER_COPAL, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.pink_geode_slice.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.pyrite.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.scaynyx_ingot.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.sugilite_axe.get())).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.albite.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModBlocks.copal_bricks.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)9.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.old_bow.get())).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.agate_arrow.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.white_opal.get())))));
            consumer.accept(GaiaChestTables.CHESTS_MINITOWER_JADE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.green_geode_slice.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.pyrite.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.scaynyx_ingot.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.sugilite_axe.get())).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.euclase.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModBlocks.jade_bricks.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)9.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.old_bow.get())).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.agate_arrow.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.white_opal.get())))));
            consumer.accept(GaiaChestTables.CHESTS_MINITOWER_JET, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.blue_geode_slice.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.pyrite.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.scaynyx_ingot.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.sugilite_axe.get())).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.stibnite.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModBlocks.jet_bricks.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)9.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.old_bow.get())).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.agate_arrow.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.white_opal.get())))));
            consumer.accept(GaiaChestTables.CHESTS_MALACHITE_WATCHTOWER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModBlocks.malachite_bricks.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModBlocks.malachite_tiles.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModBlocks.malachite_pillar.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.pyrite.get())).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.stibnite_sword.get())).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.euclase_sword.get())).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.tiligr.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.proustite_helmet.get())).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.albite_helmet.get())).setWeight(2))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.stibnite.get())).setWeight(6).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.proustite.get())).setWeight(6).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.euclase.get())).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.albite.get())).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.green_opal.get())).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.white_opal.get())).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))));
        }
    }

    public static class Entities
    extends GaiaEntityLootTableProvider {
        protected Entities(HolderLookup.Provider provider) {
            super(provider);
        }

        public void generate() {
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.AGATE_GOLEM, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.ANCIENT_LAGRAHK, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.ARCHAIC_WARRIOR, this.warriorTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.BISMUTH_ULETRUS, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.CAVERN_TICK, this.singleDropTable((Supplier<Item>)ModItems.fine_thread, 0.0f, 1.0f));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.CONTORTED_NAGA, this.singleDropTable((Supplier<Item>)ModItems.goldstone, 0.0f, 2.0f));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.CORRUPT_SAPPER, this.singleDropTable((Supplier<Item>)ModItems.goldstone_residue, 0.0f, 2.0f));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.CRYSTAL_GOLEM, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.GROWTH_SAPPER, LootTable.lootTable().withPool(Entities.growthSapperTables(GaiaBuiltinTables.SAPPER_TABLES)));
            SapperVariant.SapperLoot.GEODE_BY_VARIANT.forEach((variant, item) -> this.add((EntityType)ModEntities.GROWTH_SAPPER.get(), GaiaBuiltinTables.SAPPER_TABLES.get(variant), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)))));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.HOWLITE_WOLF, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.LESSER_SHOCKSHOOTER, this.singleDropTable((Supplier<Item>)ModItems.crystallized_lapis_lazuli, 0.0f, 2.0f));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.LESSER_SPITFIRE, this.singleDropTable((Supplier<Item>)ModItems.crystallized_redstone, 0.0f, 2.0f));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.MARKUZAR_PLANT, this.singleDropTable((Supplier<Item>)ModItems.markuzar_mint, 0.0f, 2.0f));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.MINERAL_ARENTHIS, this.cookableDoubleDropTable((Supplier<Item>)ModItems.large_tentacle, (Supplier<Item>)ModItems.sugar_cluster, 0.0f, 3.0f, 0.0f, 2.0f));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.MUCKLING, this.singleDropTable((Supplier<Item>)ModItems.sweet_muckball, 0.0f, 2.0f));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.MUTANT_GROWTH_EXTRACTOR, this.extractorTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.NOMADIC_LAGRAHK, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.PRIMAL_BEAST, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.ROCKY_LUGGEROTH, this.cookableSingleDropTable((Supplier<Item>)ModItems.luggeroth_chop, 0.0f, 3.0f));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.RUGGED_LURMORUS, this.cookableSingleDropTable((Supplier<Item>)ModItems.lurmorus_meat, 0.0f, 3.0f));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.SALTION, this.singleDropTable((Supplier<Item>)ModItems.fine_thread, 0.0f, 2.0f));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.SHALLOW_ARENTHIS, this.cookableDoubleDropTable((Supplier<Item>)ModItems.small_tentacle, (Supplier<Item>)ModItems.sugar_crystals, 0.0f, 3.0f, 0.0f, 2.0f));
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.SHALURKER, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.SPELLBOUND_ELEMENTAL, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.MALACHITE_DRONE, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.MOOKAITE_CONSTRUCT, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.OPALITE_CONSTRUCT, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.GROWTH_GRAZER, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.AUREATE_EVRAUN, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.BLUE_HOWLITE_WOLF, this.blankTable());
            this.addTable((Supplier<? extends EntityType<?>>)ModEntities.MALACHITE_GUARD, this.malachiteGuardTable());
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return ModEntities.ENTITY_TYPES.getEntries().stream().map(DeferredHolder::value);
        }

        private static LootPool.Builder growthSapperTables(Map<SapperVariant, ResourceKey<LootTable>> map) {
            AlternativesEntry.Builder builder = AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]);
            for (Map.Entry<SapperVariant, ResourceKey<LootTable>> entry : map.entrySet()) {
                builder = builder.otherwise(NestedLootTable.lootTableReference(entry.getValue()).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)SapperPredicate.isVariant(entry.getKey())))));
            }
            return LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder);
        }
    }

    public static class Blocks
    extends GaiaBlockLootTableProvider {
        protected Blocks(HolderLookup.Provider provider) {
            super(provider);
        }

        protected void generate() {
            this.noDrops(ModBlocks.malachite_guard_spawner);
            this.dropSelf(ModBlocks.keystone_block);
            this.dropSelf(ModBlocks.pyrite_torch);
            this.dropSelf(ModBlocks.agate_crafting_table);
            this.dropTable((Supplier<Block>)ModBlocks.crude_storage_crate, this.smallCrate((Block)ModBlocks.crude_storage_crate.get()));
            this.dropTable((Supplier<Block>)ModBlocks.mega_storage_crate, this.largeCrate((Block)ModBlocks.mega_storage_crate.get()));
            this.dropTable((Supplier<Block>)ModBlocks.gaia_stone_furnace, this.withName((Block)ModBlocks.gaia_stone_furnace.get()));
            this.dropTable((Supplier<Block>)ModBlocks.restructurer, this.withName((Block)ModBlocks.restructurer.get()));
            this.dropTable((Supplier<Block>)ModBlocks.purifier, this.withName((Block)ModBlocks.purifier.get()));
            this.dropSelf(ModBlocks.heavy_soil);
            this.dropSelf(ModBlocks.corrupted_soil);
            this.dropSelf(ModBlocks.boggy_soil);
            this.dropSelf(ModBlocks.light_soil);
            this.dropSelf(ModBlocks.aurum_soil);
            this.dropWithSilk((Supplier<Block>)ModBlocks.glitter_grass, (Supplier<Block>)ModBlocks.heavy_soil);
            this.dropWithSilk((Supplier<Block>)ModBlocks.corrupted_grass, (Supplier<Block>)ModBlocks.corrupted_soil);
            this.dropWithSilk((Supplier<Block>)ModBlocks.murky_grass, (Supplier<Block>)ModBlocks.boggy_soil);
            this.dropWithSilk((Supplier<Block>)ModBlocks.soft_grass, (Supplier<Block>)ModBlocks.light_soil);
            this.dropWithSilk((Supplier<Block>)ModBlocks.gilded_grass, (Supplier<Block>)ModBlocks.aurum_soil);
            this.dropOnlySilk((Supplier<Block>)ModBlocks.frail_glitter_block);
            this.dropSelf(ModBlocks.thick_glitter_block);
            this.dropSelf(ModBlocks.gummy_glitter_block);
            this.dropSelf(ModBlocks.pink_sludge_block);
            this.dropTable((Supplier<Block>)ModBlocks.crystal_growth, this.withShards((Block)ModBlocks.crystal_growth.get()));
            this.dropTable((Supplier<Block>)ModBlocks.crystal_growth_red, this.withShards((Block)ModBlocks.crystal_growth_red.get()));
            this.dropTable((Supplier<Block>)ModBlocks.crystal_growth_black, this.withShards((Block)ModBlocks.crystal_growth_black.get()));
            this.dropTable((Supplier<Block>)ModBlocks.crystal_growth_seared, this.withShards((Block)ModBlocks.crystal_growth_seared.get()));
            this.dropTable((Supplier<Block>)ModBlocks.crystal_growth_mutant, this.withShards((Block)ModBlocks.crystal_growth_mutant.get()));
            this.dropTable((Supplier<Block>)ModBlocks.crystal_growth_aura, this.withShards((Block)ModBlocks.crystal_growth_aura.get()));
            this.dropTable((Supplier<Block>)ModBlocks.golden_grass, this.createShearsOnlyDrop((ItemLike)ModBlocks.golden_grass.get()));
            this.dropTable((Supplier<Block>)ModBlocks.tall_golden_grass, (Block block) -> this.doubleShearsOnly((Block)block, (Block)ModBlocks.golden_grass.get()));
            this.dropSelf(ModBlocks.thiscus);
            this.dropSelf(ModBlocks.ouzium);
            this.dropSelf(ModBlocks.agathum);
            this.dropSelf(ModBlocks.varloom);
            this.dropSelf(ModBlocks.corrupted_varloom);
            this.dropSelf(ModBlocks.glamelea);
            this.dropSelf(ModBlocks.missingno_plant);
            this.dropSelf(ModBlocks.spotted_kersei);
            this.dropSelf(ModBlocks.thorny_wiltha);
            this.dropSelf(ModBlocks.roofed_agaric);
            this.dropSelf(ModBlocks.bulbous_hobina);
            this.dropSelf(ModBlocks.stickly_cupsir);
            this.dropSelf(ModBlocks.mystical_murgni);
            this.dropSelf(ModBlocks.corrupted_gaia_eye);
            this.dropSelf(ModBlocks.twinkling_gilsri);
            this.dropSelf(ModBlocks.elder_imklia);
            this.dropSelf(ModBlocks.gold_orb_tucher);
            this.dropSelf(ModBlocks.missingno_fungus);
            this.dropTable((Supplier<Block>)ModBlocks.golden_vine, this.createShearsOnlyDrop((ItemLike)ModBlocks.golden_vine.get()));
            this.dropSelf(ModBlocks.sombre_cacti);
            this.dropTable((Supplier<Block>)ModBlocks.sombre_shrub, this.createShearsOnlyDrop((ItemLike)ModBlocks.sombre_shrub.get()));
            this.dropSelf(ModBlocks.pink_agate_sapling);
            this.dropSelf(ModBlocks.blue_agate_sapling);
            this.dropSelf(ModBlocks.green_agate_sapling);
            this.dropSelf(ModBlocks.purple_agate_sapling);
            this.dropSelf(ModBlocks.fossilized_sapling);
            this.dropSelf(ModBlocks.corrupted_sapling);
            this.dropSelf(ModBlocks.burnt_sapling);
            this.dropSelf(ModBlocks.fire_agate_sapling);
            this.dropSelf(ModBlocks.aura_sapling);
            this.dropSelf(ModBlocks.golden_sapling);
            this.dropChance((Supplier<? extends Block>)ModBlocks.pink_agate_leaves, (Supplier<? extends Block>)ModBlocks.pink_agate_sapling, leaf_chances);
            this.dropChance((Supplier<? extends Block>)ModBlocks.blue_agate_leaves, (Supplier<? extends Block>)ModBlocks.blue_agate_sapling, leaf_chances);
            this.dropChance((Supplier<? extends Block>)ModBlocks.green_agate_leaves, (Supplier<? extends Block>)ModBlocks.green_agate_sapling, leaf_chances);
            this.dropChance((Supplier<? extends Block>)ModBlocks.purple_agate_leaves, (Supplier<? extends Block>)ModBlocks.purple_agate_sapling, leaf_chances);
            this.dropChanceAlternative((Supplier<? extends Block>)ModBlocks.fossilized_leaves, (Supplier<? extends Block>)ModBlocks.fossilized_sapling, (Supplier<Item>)ModItems.fine_dust, leaf_chances);
            this.dropChanceAlternative((Supplier<? extends Block>)ModBlocks.corrupted_leaves, (Supplier<? extends Block>)ModBlocks.corrupted_sapling, (Supplier<Item>)ModItems.goldstone_dust, leaf_chances);
            this.dropChanceAlternative((Supplier<? extends Block>)ModBlocks.burnt_leaves, (Supplier<? extends Block>)ModBlocks.burnt_sapling, () -> Items.GUNPOWDER, leaf_chances);
            this.dropChanceAlternative((Supplier<? extends Block>)ModBlocks.fire_agate_leaves, (Supplier<? extends Block>)ModBlocks.fire_agate_sapling, (Supplier<Item>)ModItems.hot_dust, leaf_chances);
            this.dropChance((Supplier<? extends Block>)ModBlocks.aura_leaves, (Supplier<? extends Block>)ModBlocks.aura_sapling, leaf_chances);
            this.dropChance((Supplier<? extends Block>)ModBlocks.golden_leaves, (Supplier<? extends Block>)ModBlocks.golden_sapling, leaf_chances);
            this.dropSelf(ModBlocks.pink_agate_log);
            this.dropSelf(ModBlocks.blue_agate_log);
            this.dropSelf(ModBlocks.green_agate_log);
            this.dropSelf(ModBlocks.purple_agate_log);
            this.dropSelf(ModBlocks.fossilized_log);
            this.dropSelf(ModBlocks.corrupted_log);
            this.dropSelf(ModBlocks.burnt_log);
            this.dropSelf(ModBlocks.fire_agate_log);
            this.dropSelf(ModBlocks.aura_log);
            this.dropSelf(ModBlocks.golden_log);
            this.dropSelf(ModBlocks.stripped_pink_agate_log);
            this.dropSelf(ModBlocks.stripped_blue_agate_log);
            this.dropSelf(ModBlocks.stripped_green_agate_log);
            this.dropSelf(ModBlocks.stripped_purple_agate_log);
            this.dropSelf(ModBlocks.stripped_fossilized_log);
            this.dropSelf(ModBlocks.stripped_corrupted_log);
            this.dropSelf(ModBlocks.stripped_burnt_log);
            this.dropSelf(ModBlocks.stripped_fire_agate_log);
            this.dropSelf(ModBlocks.stripped_aura_log);
            this.dropSelf(ModBlocks.stripped_golden_log);
            this.dropSelf(ModBlocks.pink_agate_wood);
            this.dropSelf(ModBlocks.blue_agate_wood);
            this.dropSelf(ModBlocks.green_agate_wood);
            this.dropSelf(ModBlocks.purple_agate_wood);
            this.dropSelf(ModBlocks.fossilized_wood);
            this.dropSelf(ModBlocks.corrupted_wood);
            this.dropSelf(ModBlocks.burnt_wood);
            this.dropSelf(ModBlocks.fire_agate_wood);
            this.dropSelf(ModBlocks.aura_wood);
            this.dropSelf(ModBlocks.golden_wood);
            this.dropSelf(ModBlocks.stripped_pink_agate_wood);
            this.dropSelf(ModBlocks.stripped_blue_agate_wood);
            this.dropSelf(ModBlocks.stripped_green_agate_wood);
            this.dropSelf(ModBlocks.stripped_purple_agate_wood);
            this.dropSelf(ModBlocks.stripped_fossilized_wood);
            this.dropSelf(ModBlocks.stripped_corrupted_wood);
            this.dropSelf(ModBlocks.stripped_burnt_wood);
            this.dropSelf(ModBlocks.stripped_fire_agate_wood);
            this.dropSelf(ModBlocks.stripped_aura_wood);
            this.dropSelf(ModBlocks.stripped_golden_wood);
            this.dropSelf(ModBlocks.salt);
            this.dropSelf(ModBlocks.saltstone);
            this.dropAlternative((Supplier<Block>)ModBlocks.pebbles, (Supplier<Item>)ModItems.sturdy_pebble);
            this.dropWithSilk((Supplier<Block>)ModBlocks.gaia_stone, (Supplier<Block>)ModBlocks.gaia_cobblestone);
            this.dropSelf(ModBlocks.gaia_cobblestone);
            this.dropSelf(ModBlocks.wasteland_stone);
            this.dropSelf(ModBlocks.static_stone);
            this.dropOnlySilk((Supplier<Block>)ModBlocks.charged_mineral);
            this.dropSelf(ModBlocks.volcanic_rock);
            this.dropSelf(ModBlocks.searing_rock);
            this.dropSelf(ModBlocks.primal_mass);
            this.dropSelf(ModBlocks.nexustone);
            this.dropSelf(ModBlocks.impure_rock);
            this.dropSelf(ModBlocks.active_rock);
            this.dropSelf(ModBlocks.impure_sludge);
            this.dropSelf(ModBlocks.geyser_block);
            this.dropOnlySilk((Supplier<Block>)ModBlocks.sparkling_rock);
            this.dropSelf(ModBlocks.aura_shoot);
            this.dropSelf(ModBlocks.golden_stone);
            this.dropSelf(ModBlocks.tough_golden_stone);
            this.dropSelf(ModBlocks.brilliant_stone);
            this.dropSelf(ModBlocks.gilded_brilliant_stone);
            this.dropSelf(ModBlocks.aurum_mud);
            this.dropSelf(ModBlocks.golden_sand);
            this.dropSelf(ModBlocks.scarlet_mookaite);
            this.dropSelf(ModBlocks.auburn_mookaite);
            this.dropSelf(ModBlocks.gold_mookaite);
            this.dropSelf(ModBlocks.mauve_mookaite);
            this.dropSelf(ModBlocks.beige_mookaite);
            this.dropSelf(ModBlocks.ivory_mookaite);
            this.dropSelf(ModBlocks.pink_agate_tiles);
            this.dropSelf(ModBlocks.blue_agate_tiles);
            this.dropSelf(ModBlocks.green_agate_tiles);
            this.dropSelf(ModBlocks.purple_agate_tiles);
            this.dropSelf(ModBlocks.fossilized_tiles);
            this.dropSelf(ModBlocks.corrupted_tiles);
            this.dropSelf(ModBlocks.burnt_tiles);
            this.dropSelf(ModBlocks.fire_agate_tiles);
            this.dropSelf(ModBlocks.aura_tiles);
            this.dropSelf(ModBlocks.golden_tiles);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.pink_agate_tile_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.blue_agate_tile_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.green_agate_tile_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.purple_agate_tile_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.fossilized_tile_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.corrupted_tile_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.burnt_tile_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.fire_agate_tile_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.aura_tile_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.golden_tile_slab);
            this.dropSelf(ModBlocks.pink_agate_tile_stairs);
            this.dropSelf(ModBlocks.blue_agate_tile_stairs);
            this.dropSelf(ModBlocks.green_agate_tile_stairs);
            this.dropSelf(ModBlocks.purple_agate_tile_stairs);
            this.dropSelf(ModBlocks.fossilized_tile_stairs);
            this.dropSelf(ModBlocks.corrupted_tile_stairs);
            this.dropSelf(ModBlocks.burnt_tile_stairs);
            this.dropSelf(ModBlocks.fire_agate_tile_stairs);
            this.dropSelf(ModBlocks.aura_tile_stairs);
            this.dropSelf(ModBlocks.golden_tile_stairs);
            this.dropCurtain((Supplier<? extends Block>)ModBlocks.pink_agate_curtain);
            this.dropCurtain((Supplier<? extends Block>)ModBlocks.blue_agate_curtain);
            this.dropCurtain((Supplier<? extends Block>)ModBlocks.green_agate_curtain);
            this.dropCurtain((Supplier<? extends Block>)ModBlocks.purple_agate_curtain);
            this.dropCurtain((Supplier<? extends Block>)ModBlocks.fossilized_curtain);
            this.dropCurtain((Supplier<? extends Block>)ModBlocks.corrupted_curtain);
            this.dropCurtain((Supplier<? extends Block>)ModBlocks.burnt_agate_curtain);
            this.dropCurtain((Supplier<? extends Block>)ModBlocks.fire_agate_curtain);
            this.dropCurtain((Supplier<? extends Block>)ModBlocks.aura_curtain);
            this.dropCurtain((Supplier<? extends Block>)ModBlocks.golden_curtain);
            this.dropOnlySilk((Supplier<Block>)ModBlocks.cloudy_glass);
            this.dropOnlySilk((Supplier<Block>)ModBlocks.foggy_glass);
            this.dropSelf(ModBlocks.gaia_stone_bricks);
            this.dropSelf(ModBlocks.cracked_gaia_stone_bricks);
            this.dropSelf(ModBlocks.crusted_gaia_stone_bricks);
            this.dropSelf(ModBlocks.raw_jade);
            this.dropSelf(ModBlocks.jade_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.jade_brick_slab);
            this.dropSelf(ModBlocks.jade_brick_stairs);
            this.dropSelf(ModBlocks.cracked_jade_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.cracked_jade_brick_slab);
            this.dropSelf(ModBlocks.cracked_jade_brick_stairs);
            this.dropSelf(ModBlocks.crusted_jade_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.crusted_jade_brick_slab);
            this.dropSelf(ModBlocks.crusted_jade_brick_stairs);
            this.dropSelf(ModBlocks.raw_copal);
            this.dropSelf(ModBlocks.copal_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.copal_brick_slab);
            this.dropSelf(ModBlocks.copal_brick_stairs);
            this.dropSelf(ModBlocks.cracked_copal_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.cracked_copal_brick_slab);
            this.dropSelf(ModBlocks.cracked_copal_brick_stairs);
            this.dropSelf(ModBlocks.crusted_copal_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.crusted_copal_brick_slab);
            this.dropSelf(ModBlocks.crusted_copal_brick_stairs);
            this.dropSelf(ModBlocks.raw_jet);
            this.dropSelf(ModBlocks.jet_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.jet_brick_slab);
            this.dropSelf(ModBlocks.jet_brick_stairs);
            this.dropSelf(ModBlocks.cracked_jet_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.cracked_jet_brick_slab);
            this.dropSelf(ModBlocks.cracked_jet_brick_stairs);
            this.dropSelf(ModBlocks.crusted_jet_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.crusted_jet_brick_slab);
            this.dropSelf(ModBlocks.crusted_jet_brick_stairs);
            this.dropSelf(ModBlocks.raw_amethyst);
            this.dropSelf(ModBlocks.amethyst_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.amethyst_brick_slab);
            this.dropSelf(ModBlocks.amethyst_brick_stairs);
            this.dropSelf(ModBlocks.cracked_amethyst_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.cracked_amethyst_brick_slab);
            this.dropSelf(ModBlocks.cracked_amethyst_brick_stairs);
            this.dropSelf(ModBlocks.crusted_amethyst_bricks);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.crusted_amethyst_brick_slab);
            this.dropSelf(ModBlocks.crusted_amethyst_brick_stairs);
            this.dropSelf(ModBlocks.reinforced_bricks);
            this.dropSelf(ModBlocks.bolstered_bricks);
            this.dropSelf(ModBlocks.malachite_bricks);
            this.dropSelf(ModBlocks.malachite_cracked_bricks);
            this.dropSelf(ModBlocks.malachite_crusted_bricks);
            this.dropSelf(ModBlocks.malachite_tiles);
            this.dropSelf(ModBlocks.malachite_chisel_bricks);
            this.dropSelf(ModBlocks.malachite_pulsing_bricks);
            this.dropSelf(ModBlocks.malachite_pulsing_tiles);
            this.dropSelf(ModBlocks.malachite_pulsing_chisel);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.malachite_brick_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.malachite_cracked_brick_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.malachite_crusted_brick_slab);
            this.dropSlab((Supplier<SlabBlock>)ModBlocks.malachite_tile_slab);
            this.dropSelf(ModBlocks.malachite_pillar);
            this.dropSelf(ModBlocks.malachite_brick_stairs);
            this.dropSelf(ModBlocks.malachite_cracked_brick_stairs);
            this.dropSelf(ModBlocks.malachite_crusted_brick_stairs);
            this.dropSelf(ModBlocks.malachite_tile_stairs);
            this.dropSelf(ModBlocks.malachite_chisel_stairs);
            this.dropSelf(ModBlocks.malachite_pulsing_brick_stairs);
            this.dropSelf(ModBlocks.malachite_pulsing_floor_stairs);
            this.dropSelf(ModBlocks.malachite_pulsing_chisel_stairs);
            this.dropSelf(ModBlocks.malachite_pillar_stairs);
            this.dropSelf(ModBlocks.sugilite_block);
            this.dropSelf(ModBlocks.hematite_block);
            this.dropSelf(ModBlocks.cinnabar_block);
            this.dropSelf(ModBlocks.labradorite_block);
            this.dropSelf(ModBlocks.moonstone_block);
            this.dropSelf(ModBlocks.red_opal_block);
            this.dropSelf(ModBlocks.blue_opal_block);
            this.dropSelf(ModBlocks.green_opal_block);
            this.dropSelf(ModBlocks.white_opal_block);
            this.dropSelf(ModBlocks.pyrite_block);
            this.dropSelf(ModBlocks.tektite_block);
            this.dropSelf(ModBlocks.goldstone_block);
            this.dropSelf(ModBlocks.aura_block);
            this.dropSelf(ModBlocks.bismuth_block);
            this.dropSelf(ModBlocks.opalite_block);
            this.dropSelf(ModBlocks.stibnite_block);
            this.dropSelf(ModBlocks.proustite_block);
            this.dropSelf(ModBlocks.euclase_block);
            this.dropSelf(ModBlocks.albite_block);
            this.dropSelf(ModBlocks.carnelian_block);
            this.dropSelf(ModBlocks.benitoite_block);
            this.dropSelf(ModBlocks.diopside_block);
            this.dropSelf(ModBlocks.goshenite_block);
            this.dropSelf(ModBlocks.celestine_block);
            this.dropWithFortune((Supplier<Block>)ModBlocks.sugilite_ore, (Supplier<Item>)ModItems.sugilite);
            this.dropWithFortune((Supplier<Block>)ModBlocks.hematite_ore, (Supplier<Item>)ModItems.hematite);
            this.dropWithFortune((Supplier<Block>)ModBlocks.cinnabar_ore, (Supplier<Item>)ModItems.cinnabar);
            this.dropWithFortune((Supplier<Block>)ModBlocks.labradorite_ore, (Supplier<Item>)ModItems.labradorite);
            this.dropWithFortune((Supplier<Block>)ModBlocks.moonstone_ore, (Supplier<Item>)ModItems.moonstone);
            this.dropWithFortune((Supplier<Block>)ModBlocks.red_opal_ore, (Supplier<Item>)ModItems.red_opal);
            this.dropWithFortune((Supplier<Block>)ModBlocks.blue_opal_ore, (Supplier<Item>)ModItems.blue_opal);
            this.dropWithFortune((Supplier<Block>)ModBlocks.green_opal_ore, (Supplier<Item>)ModItems.green_opal);
            this.dropWithFortune((Supplier<Block>)ModBlocks.white_opal_ore, (Supplier<Item>)ModItems.white_opal);
            this.dropWithFortune((Supplier<Block>)ModBlocks.pyrite_ore, (Supplier<Item>)ModItems.pyrite);
            this.dropSelf(ModBlocks.speckled_rock);
            this.dropSelf(ModBlocks.coarse_rock);
            this.dropSelf(ModBlocks.precious_rock);
            this.dropWithMultiple((Supplier<Block>)ModBlocks.scarlet_opalite_ore, (Supplier<Item>)ModItems.opalite);
            this.dropWithMultiple((Supplier<Block>)ModBlocks.auburn_opalite_ore, (Supplier<Item>)ModItems.opalite);
            this.dropWithMultiple((Supplier<Block>)ModBlocks.gold_opalite_ore, (Supplier<Item>)ModItems.opalite);
            this.dropWithMultiple((Supplier<Block>)ModBlocks.mauve_opalite_ore, (Supplier<Item>)ModItems.opalite);
            this.dropWithMultiple((Supplier<Block>)ModBlocks.beige_opalite_ore, (Supplier<Item>)ModItems.opalite);
            this.dropWithMultiple((Supplier<Block>)ModBlocks.ivory_opalite_ore, (Supplier<Item>)ModItems.opalite);
            this.dropWithFortune((Supplier<Block>)ModBlocks.celestine_ore, (Supplier<Item>)ModItems.celestine);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_thiscus);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_ouzium);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_agathum);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_varloom);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_corrupted_varloom);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_missingno_plant);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_spotted_kersei);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_thorny_wiltha);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_roofed_agaric);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_bulbous_hobina);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_stickly_cupsir);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_mystical_murgni);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_corrupted_gaia_eye);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_twinkling_gilsri);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_elder_imklia);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_gold_orb_tucher);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_missingno_fungus);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_pink_agate_sapling);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_blue_agate_sapling);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_green_agate_sapling);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_purple_agate_sapling);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_fossilized_sapling);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_corrupted_sapling);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_burnt_sapling);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_fire_agate_sapling);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_aura_sapling);
            this.dropPot((Supplier<FlowerPotBlock>)ModBlocks.potted_golden_sapling);
        }

        protected Iterable<Block> getKnownBlocks() {
            return ModBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

