/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data.provider;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public class GaiaAdvancementProvider
extends AdvancementProvider {
    public GaiaAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, List<AdvancementSubProvider> list) {
        super(output, provider, list);
    }

    protected static MutableComponent title(String name) {
        return GaiaAdvancementProvider.advancement(name + ".title");
    }

    protected static MutableComponent description(String name) {
        return GaiaAdvancementProvider.advancement(name + ".description");
    }

    protected static MutableComponent advancement(String name) {
        return Component.translatable((String)("advancements.gaia." + name));
    }

    protected static String loc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("gaia/" + name)).toString();
    }

    protected static Criterion<?> biome(HolderLookup.Provider provider, ResourceKey<Biome> define) {
        HolderLookup.RegistryLookup registry = provider.lookupOrThrow(Registries.BIOME);
        return PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)registry.getOrThrow(define)));
    }

    protected static Criterion<?> structure(HolderLookup.Provider provider, ResourceKey<Structure> define) {
        HolderLookup.RegistryLookup registry = provider.lookupOrThrow(Registries.STRUCTURE);
        return PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inStructure((Holder)registry.getOrThrow(define)));
    }

    protected static Criterion<?> item(Supplier<? extends Item> item) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)item.get()});
    }
}

