/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.entity.AgateGolem;
import androsa.gaiadimension.registry.registration.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class CrystalGolem
extends AbstractGolem {
    public CrystalGolem(EntityType<? extends CrystalGolem> entity, Level world) {
        super(entity, world);
        this.xpReward = 15;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 150.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ARMOR, 2.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.3, true));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.3, 32.0f));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.3));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AgateGolem.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, false, true, (entity, level) -> entity instanceof Enemy && !(entity instanceof Creeper)));
    }

    public boolean doHurtTarget(ServerLevel level, Entity entityIn) {
        level.broadcastEntityEvent((Entity)this, (byte)4);
        DamageSource source = this.damageSources().mobAttack((LivingEntity)this);
        boolean flag = entityIn.hurtServer(level, source, (float)(6 + this.random.nextInt(15)));
        if (flag) {
            entityIn.setDeltaMovement(entityIn.getDeltaMovement().add(0.0, 0.4, 0.0));
            if (level instanceof ServerLevel) {
                ServerLevel server = level;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)server, (Entity)entityIn, (DamageSource)source);
            }
        }
        return flag;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return ModSounds.ENTITY_CRYSTAL_GOLEM_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_CRYSTAL_GOLEM_DEATH.get();
    }

    public static boolean canSpawnHere(EntityType<CrystalGolem> entity, LevelAccessor world, EntitySpawnReason spawn, BlockPos pos, RandomSource random) {
        return spawn == EntitySpawnReason.SPAWNER || world.getBlockState(pos.below()).isValidSpawn((BlockGetter)world, pos.below(), entity) && world.getRawBrightness(pos, 0) > 8;
    }
}

