/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.registry.registration.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class GrowthGrazer
extends PathfinderMob {
    public GrowthGrazer(EntityType<? extends GrowthGrazer> entity, Level world) {
        super(entity, world);
        this.xpReward = 1 + this.random.nextInt(3);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_GROWTH_SAPPER_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ENTITY_GROWTH_SAPPER_HURT.get();
    }

    public static boolean canSpawnHere(EntityType<GrowthGrazer> entity, LevelAccessor world, EntitySpawnReason spawn, BlockPos pos, RandomSource random) {
        return spawn == EntitySpawnReason.SPAWNER || world.getBlockState(pos.below()).isValidSpawn((BlockGetter)world, pos.below(), entity) && world.getRawBrightness(pos, 0) > 8;
    }
}

