/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.entity.boss.MalachiteGuard;
import androsa.gaiadimension.registry.registration.ModParticles;
import androsa.gaiadimension.registry.registration.ModSounds;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.neoforged.neoforge.common.CommonHooks;

public class MalachiteDrone
extends Monster {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.defineId(MalachiteDrone.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private LivingEntity owner;

    public MalachiteDrone(EntityType<? extends MalachiteDrone> entity, Level world) {
        super(entity, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MOVEMENT_SPEED, 0.6);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OWNER_UNIQUE_ID, Optional.empty());
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, false));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.6, 16.0f));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new FollowGuardGoal(this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setOwnerUniqueId(UUID.fromString(nbt.getString("OwnerUUID")));
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (this.getOwnerUniqueId() != null) {
            nbt.putString("OwnerUUID", this.getOwnerUniqueId().toString());
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        ServerLevel server;
        Entity entity;
        Level level;
        if (this.getOwnerUniqueId() != null && (level = this.level()) instanceof ServerLevel && (entity = (server = (ServerLevel)level).getEntity(this.getOwnerUniqueId())) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity entity) {
        this.owner = entity;
        this.setOwnerUniqueId(entity == null ? null : entity.getUUID());
    }

    @Nullable
    public UUID getOwnerUniqueId() {
        return ((Optional)this.entityData.get(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerUniqueId(@Nullable UUID id) {
        this.entityData.set(OWNER_UNIQUE_ID, Optional.ofNullable(id));
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_MALACHITE_DRONE_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ENTITY_MALACHITE_DRONE_HURT.get();
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.getOwnerUniqueId() != null) {
                Entity entity = server.getEntity(this.getOwnerUniqueId());
                if (entity != null) {
                    if (this.level().dimension() != entity.level().dimension()) {
                        this.ownerRemoved(entity);
                    }
                    if (this.distanceToSqr(entity) > 500.0 && (this.isLeashed() || this.isPassenger())) {
                        this.ownerRemoved(entity);
                    }
                } else {
                    this.setOwnerUniqueId(null);
                }
            }
        }
    }

    private void ownerRemoved(Entity owner) {
        if (owner instanceof MalachiteGuard) {
            MalachiteGuard guard = (MalachiteGuard)owner;
            guard.onDroneKilled();
        }
        this.setOwnerUniqueId(null);
        if (this.level().isClientSide()) {
            double px = this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth();
            double py = this.getY() + (double)(this.random.nextFloat() * this.getBbHeight());
            double pz = this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth();
            this.level().addParticle((ParticleOptions)ModParticles.SPAWNER_CORE.get(), px, py, pz, 0.0, 128.0, 0.0);
        }
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSounds.ENTITY_MALACHITE_DRONE_DESYNC.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    public void remove(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.DISCARDED && this.getOwnerUniqueId() != null) {
            this.ownerRemoved((Entity)this.getOwner());
        }
        super.remove(reason);
    }

    public void die(DamageSource source) {
        ServerLevel server;
        Entity entity;
        if (CommonHooks.onLivingDeath((LivingEntity)this, (DamageSource)source)) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel && (entity = (server = (ServerLevel)level).getEntity(this.getOwnerUniqueId())) != null && entity instanceof MalachiteGuard) {
            MalachiteGuard guard = (MalachiteGuard)entity;
            guard.onDroneKilled();
        }
        super.die(source);
    }

    public boolean removeWhenFarAway(double dist) {
        return this.getOwnerUniqueId() == null;
    }

    static class FollowGuardGoal
    extends Goal {
        private final MalachiteDrone drone;
        private MalachiteGuard guard;
        private final LevelAccessor world;
        private final double followSpeed = 0.4;
        private final PathNavigation navigator;
        private int timeToRecalcPath;
        private final float maxDist = 2.0f;
        private final float minDist = 10.0f;
        private float oldWaterCost;

        public FollowGuardGoal(MalachiteDrone entity) {
            this.drone = entity;
            this.world = entity.level();
            this.navigator = entity.getNavigation();
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity owner = this.drone.getOwner();
            if (owner == null) {
                return false;
            }
            if (owner.isSpectator()) {
                return false;
            }
            if (this.drone.distanceToSqr((Entity)owner) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            if (!(owner instanceof MalachiteGuard)) {
                return false;
            }
            this.guard = (MalachiteGuard)owner;
            return true;
        }

        public boolean canContinueToUse() {
            return !this.navigator.isDone() && this.drone.distanceToSqr((Entity)this.guard) > (double)(this.maxDist * this.maxDist);
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.drone.getPathfindingMalus(PathType.WATER);
            this.drone.setPathfindingMalus(PathType.WATER, 0.0f);
        }

        public void stop() {
            this.guard = null;
            this.navigator.stop();
            this.drone.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        }

        public void tick() {
            this.drone.getLookControl().setLookAt((Entity)this.guard, 10.0f, (float)this.drone.getMaxHeadXRot());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.drone.isLeashed() && !this.drone.isPassenger()) {
                    if (this.drone.distanceToSqr((Entity)this.guard) >= 144.0) {
                        this.tryTeleport();
                    } else {
                        this.navigator.moveTo((Entity)this.guard, this.followSpeed);
                    }
                }
            }
        }

        private void tryTeleport() {
            BlockPos guardpos = new BlockPos((Vec3i)this.guard.blockPosition());
            for (int chance = 0; chance < 10; ++chance) {
                int rx = this.getRandomInt(-3, 3);
                int ry = this.getRandomInt(-1, 1);
                int rz = this.getRandomInt(-3, 3);
                boolean teleport = this.tryTeleportTo(guardpos.getX() + rx, guardpos.getY() + ry, guardpos.getZ() + rz);
                if (!teleport) continue;
                return;
            }
        }

        private boolean tryTeleportTo(int x, int y, int z) {
            if (Math.abs((double)x - this.guard.getX()) < 2.0 && Math.abs((double)z - this.guard.getZ()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new BlockPos(x, y, z))) {
                return false;
            }
            this.drone.moveTo((float)x + 0.5f, y, (float)z + 0.5f, this.drone.getYRot(), this.drone.getXRot());
            this.navigator.stop();
            return true;
        }

        private boolean canTeleportTo(BlockPos pos) {
            PathType nodeType = WalkNodeEvaluator.getPathTypeStatic((Mob)this.drone, (BlockPos)pos);
            if (nodeType != PathType.WALKABLE) {
                return false;
            }
            BlockState state = this.world.getBlockState(pos.below());
            if (state.getBlock() instanceof LeavesBlock) {
                return false;
            }
            BlockPos posDown = pos.subtract((Vec3i)this.drone.blockPosition());
            return this.world.noCollision((Entity)this.drone, this.drone.getBoundingBox().move(posDown));
        }

        private int getRandomInt(int min, int max) {
            return this.drone.getRandom().nextInt(max - min + 1) + min;
        }
    }
}

