/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.registry.registration.ModFluids;
import androsa.gaiadimension.registry.registration.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class MineralArenthis
extends WaterAnimal {
    public float arenthisPitch;
    public float prevArenthisPitch;
    public float arenthisYaw;
    public float prevArenthisYaw;
    public float arenthisRotation;
    public float prevArenthisRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public MineralArenthis(EntityType<? extends MineralArenthis> entity, Level worldIn) {
        super(entity, worldIn);
        this.xpReward = 5;
        this.random.setSeed((long)(1 + this.getId()));
        this.rotationVelocity = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
    }

    public boolean canSwimInFluidType(FluidType type) {
        return type == ModFluids.MINERAL_WATER.get() || type == NeoForgeMod.WATER_TYPE.value();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return type != ModFluids.MINERAL_WATER.get() && type != NeoForgeMod.WATER_TYPE.value();
    }

    protected void handleAirSupply(int amount) {
        if (this.isAlive() && !this.isInWaterOrBubble() && this.isInFluidType((type, height) -> this.canDrownInFluidType((FluidType)type), true)) {
            this.setAirSupply(amount - 1);
            if (this.getAirSupply() == -20) {
                this.setAirSupply(0);
                this.hurt(this.damageSources().drown(), 2.0f);
            }
        } else {
            this.setAirSupply(300);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MoveRandomGoal(this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_MINERAL_ARENTHIS_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ENTITY_MINERAL_ARENTHIS_HURT.get();
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public void aiStep() {
        super.aiStep();
        this.prevArenthisPitch = this.arenthisPitch;
        this.prevArenthisYaw = this.arenthisYaw;
        this.prevArenthisRotation = this.arenthisRotation;
        this.lastTentacleAngle = this.tentacleAngle;
        this.arenthisRotation += this.rotationVelocity;
        if ((double)this.arenthisRotation > Math.PI * 2) {
            if (this.level().isClientSide()) {
                this.arenthisRotation = (float)Math.PI * 2;
            } else {
                this.arenthisRotation = (float)((double)this.arenthisRotation - Math.PI * 2);
                if (this.random.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)19);
            }
        }
        if (this.isInWaterOrBubble() || this.isInFluidType((type, height) -> this.canSwimInFluidType((FluidType)type))) {
            if (this.arenthisRotation < (float)Math.PI) {
                float f = this.arenthisRotation / (float)Math.PI;
                this.tentacleAngle = Mth.sin((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.level().isClientSide()) {
                this.setDeltaMovement(this.randomMotionVecX * this.randomMotionSpeed, this.randomMotionVecY * this.randomMotionSpeed, this.randomMotionVecZ * this.randomMotionSpeed);
            }
            Vec3 vec3d = this.getDeltaMovement();
            double dist = vec3d.horizontalDistance();
            this.yBodyRot += (-((float)Mth.atan2((double)vec3d.x, (double)vec3d.z)) * 57.295776f - this.yBodyRot) * 0.1f;
            this.setYRot(this.yBodyRot);
            this.arenthisYaw = (float)((double)this.arenthisYaw + Math.PI * (double)this.rotateSpeed * 1.5);
            this.arenthisPitch += (-((float)Mth.atan2((double)dist, (double)vec3d.y)) * 57.295776f - this.arenthisPitch) * 0.1f;
        } else {
            this.tentacleAngle = Mth.abs((float)Mth.sin((float)this.arenthisRotation)) * (float)Math.PI * 0.25f;
            if (!this.level().isClientSide()) {
                double d0 = this.getDeltaMovement().y;
                if (this.hasEffect(MobEffects.LEVITATION)) {
                    d0 = 0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1);
                } else if (!this.isNoGravity()) {
                    d0 -= 0.08;
                }
                this.setDeltaMovement(0.0, d0 * (double)0.98f, 0.0);
            }
            this.arenthisPitch = (float)((double)this.arenthisPitch + (double)(-90.0f - this.arenthisPitch) * 0.02);
        }
    }

    public static boolean canSpawnHere(EntityType<MineralArenthis> entity, LevelAccessor world, EntitySpawnReason reason, BlockPos pos, RandomSource rand) {
        return pos.getY() > 30 && pos.getY() < 50;
    }

    public void travel(Vec3 motion) {
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public void handleEntityEvent(byte id) {
        if (id == 19) {
            this.arenthisRotation = 0.0f;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void setMovementVector(float randomMotionVecXIn, float randomMotionVecYIn, float randomMotionVecZIn) {
        this.randomMotionVecX = randomMotionVecXIn;
        this.randomMotionVecY = randomMotionVecYIn;
        this.randomMotionVecZ = randomMotionVecZIn;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    static class MoveRandomGoal
    extends Goal {
        private final MineralArenthis arenthis;

        public MoveRandomGoal(MineralArenthis entity) {
            this.arenthis = entity;
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            int i = this.arenthis.getNoActionTime();
            if (i > 100) {
                this.arenthis.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.arenthis.getRandom().nextInt(50) == 0 || !this.arenthis.wasTouchingWater && !this.arenthis.isInFluidType((fluidType, height) -> this.arenthis.canSwimInFluidType((FluidType)fluidType)) || !this.arenthis.hasMovementVector()) {
                float randomVec = this.arenthis.getRandom().nextFloat() * ((float)Math.PI * 2);
                float vecX = Mth.cos((float)randomVec) * 0.2f;
                float vecY = -0.1f + this.arenthis.getRandom().nextFloat() * 0.2f;
                float vecZ = Mth.sin((float)randomVec) * 0.2f;
                this.arenthis.setMovementVector(vecX, vecY, vecZ);
            }
        }
    }
}

