/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.registry.bootstrap.GaiaBiomes;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModSounds;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class Muckling
extends Slime {
    public Muckling(EntityType<? extends Muckling> entity, Level par1World) {
        super(entity, par1World);
    }

    public void setSize(int size, boolean resetHealth) {
        super.setSize(size, resetHealth);
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)size + 3.0);
        this.xpReward += 3;
    }

    protected SoundEvent getDeathSound() {
        return this.isTiny() ? ModSounds.ENTITY_MUCKLING_DEATH_SMALL.get() : ModSounds.ENTITY_MUCKLING_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return this.isTiny() ? ModSounds.ENTITY_MUCKLING_HURT_SMALL.get() : ModSounds.ENTITY_MUCKLING_HURT.get();
    }

    protected SoundEvent getJumpSound() {
        return this.isTiny() ? ModSounds.ENTITY_MUCKLING_JUMP_SMALL.get() : ModSounds.ENTITY_MUCKLING_JUMP.get();
    }

    protected SoundEvent getSquishSound() {
        return this.isTiny() ? ModSounds.ENTITY_MUCKLING_SQUISH_SMALL.get() : ModSounds.ENTITY_MUCKLING_SQUISH.get();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0);
    }

    protected boolean isDealsDamage() {
        return true;
    }

    protected boolean spawnCustomParticles() {
        int i = this.getSize();
        for (int j = 0; j < i * 8; ++j) {
            float f = this.random.nextFloat() * ((float)Math.PI * 2);
            float f1 = this.random.nextFloat() * 0.5f + 0.5f;
            float f2 = Mth.sin((float)f) * (float)i * 0.5f * f1;
            float f3 = Mth.cos((float)f) * (float)i * 0.5f * f1;
            Level world = this.level();
            double d0 = this.getX() + (double)f2;
            double d1 = this.getZ() + (double)f3;
            BlockState state = ((Block)ModBlocks.gummy_glitter_block.get()).defaultBlockState();
            world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), d0, this.getBoundingBox().minY, d1, 0.0, 0.0, 0.0);
        }
        return true;
    }

    public static boolean canSpawnHere(EntityType<Muckling> entity, LevelAccessor world, EntitySpawnReason spawn, BlockPos pos, RandomSource random) {
        if (world.getDifficulty() != Difficulty.PEACEFUL) {
            if (spawn == EntitySpawnReason.SPAWNER && world.getBrightness(LightLayer.SKY, pos) < 8) {
                return true;
            }
            Optional biome = world.getBiome(pos).unwrapKey();
            if (Objects.equals(biome, Optional.of(GaiaBiomes.purple_agate_swamp)) || pos.getY() < 40 && random.nextFloat() < 0.5f) {
                return Muckling.checkMobSpawnRules(entity, (LevelAccessor)world, (EntitySpawnReason)spawn, (BlockPos)pos, (RandomSource)random);
            }
        }
        return false;
    }
}

