/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.entity.data.LagrahkVariant;
import androsa.gaiadimension.registry.bootstrap.GaiaBiomes;
import androsa.gaiadimension.registry.registration.ModEntities;
import androsa.gaiadimension.registry.registration.ModSounds;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class NomadicLagrahk
extends PathfinderMob {
    private static final EntityDataAccessor<LagrahkVariant> LAGRAHK_VARIANT = SynchedEntityData.defineId(NomadicLagrahk.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.LAGRAHK_VARIANT.get()));

    public NomadicLagrahk(EntityType<? extends NomadicLagrahk> entity, Level world) {
        super(entity, world);
        this.xpReward = 10;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 120.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ARMOR, 2.0).add(Attributes.MOVEMENT_SPEED, 0.6);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LAGRAHK_VARIANT, (Object)LagrahkVariant.BASE);
    }

    public LagrahkVariant getEntityVariant() {
        return (LagrahkVariant)((Object)this.entityData.get(LAGRAHK_VARIANT));
    }

    public void setLagrahkVariant(LagrahkVariant type) {
        this.entityData.set(LAGRAHK_VARIANT, (Object)type);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setLagrahkVariant(LagrahkVariant.getVariant(compound.getInt("LagrahkVariant")));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("LagrahkVariant", this.getEntityVariant().getId());
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_NOMADIC_LAGRAHK_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ENTITY_NOMADIC_LAGRAHK_HURT.get();
    }

    public int getMaxSpawnClusterSize() {
        Optional biome = this.level().getBiome(this.blockPosition()).unwrapKey();
        if (Objects.equals(biome, Optional.of(GaiaBiomes.salt_dunes)) || Objects.equals(biome, Optional.of(GaiaBiomes.static_wasteland)) || Objects.equals(biome, Optional.of(GaiaBiomes.volcanic_lands))) {
            return 4;
        }
        return 1;
    }

    public static boolean canSpawnHere(EntityType<NomadicLagrahk> entity, LevelAccessor world, EntitySpawnReason spawn, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).isValidSpawn((BlockGetter)world, pos.below(), entity) && world.getRawBrightness(pos, 0) > 8;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, EntitySpawnReason reason, @Nullable SpawnGroupData spawnDataIn) {
        Optional biome = worldIn.getBiome(this.blockPosition()).unwrapKey();
        if (Objects.equals(biome, Optional.of(GaiaBiomes.salt_dunes))) {
            this.setLagrahkVariant(LagrahkVariant.SALTY);
        } else if (Objects.equals(biome, Optional.of(GaiaBiomes.static_wasteland))) {
            this.setLagrahkVariant(LagrahkVariant.STATIC);
        } else if (Objects.equals(biome, Optional.of(GaiaBiomes.volcanic_lands))) {
            this.setLagrahkVariant(LagrahkVariant.VOLCANIC);
        } else {
            this.setLagrahkVariant(LagrahkVariant.BASE);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }
}

