/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.entity.MookaiteConstruct;
import androsa.gaiadimension.entity.data.MookaitePartType;
import androsa.gaiadimension.item.ConstructKitItem;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModItems;
import androsa.gaiadimension.registry.registration.ModSounds;
import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.neoforged.neoforge.common.CommonHooks;

public class OpaliteContruct
extends PathfinderMob {
    private static final EntityDataAccessor<Optional<UUID>> BOND_CREATOR_UUID = SynchedEntityData.defineId(OpaliteContruct.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> MOOKAITE_COMPANION_UUID = SynchedEntityData.defineId(OpaliteContruct.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<CompoundTag> CONSTRUCT_KIT_DATA = SynchedEntityData.defineId(OpaliteContruct.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<Boolean> IS_CONSTRUCTING = SynchedEntityData.defineId(OpaliteContruct.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> OPALITE_STACK = SynchedEntityData.defineId(OpaliteContruct.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SCARLET_STACK = SynchedEntityData.defineId(OpaliteContruct.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> AUBURN_STACK = SynchedEntityData.defineId(OpaliteContruct.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> GOLD_STACK = SynchedEntityData.defineId(OpaliteContruct.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MAUVE_STACK = SynchedEntityData.defineId(OpaliteContruct.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BEIGE_STACK = SynchedEntityData.defineId(OpaliteContruct.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> IVORY_STACK = SynchedEntityData.defineId(OpaliteContruct.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Map<Item, EntityDataAccessor<Integer>> BLOCK_TO_DATA = ImmutableMap.of((Object)((Block)ModBlocks.scarlet_mookaite.get()).asItem(), SCARLET_STACK, (Object)((Block)ModBlocks.auburn_mookaite.get()).asItem(), AUBURN_STACK, (Object)((Block)ModBlocks.gold_mookaite.get()).asItem(), GOLD_STACK, (Object)((Block)ModBlocks.mauve_mookaite.get()).asItem(), MAUVE_STACK, (Object)((Block)ModBlocks.beige_mookaite.get()).asItem(), BEIGE_STACK, (Object)((Block)ModBlocks.ivory_mookaite.get()).asItem(), IVORY_STACK);
    private static final Map<ConstructKitItem.Color, EntityDataAccessor<Integer>> COLOR_TO_DATA = ImmutableMap.of((Object)((Object)ConstructKitItem.Color.SCARLET), SCARLET_STACK, (Object)((Object)ConstructKitItem.Color.AUBURN), AUBURN_STACK, (Object)((Object)ConstructKitItem.Color.GOLD), GOLD_STACK, (Object)((Object)ConstructKitItem.Color.MAUVE), MAUVE_STACK, (Object)((Object)ConstructKitItem.Color.BEIGE), BEIGE_STACK, (Object)((Object)ConstructKitItem.Color.IVORY), IVORY_STACK);

    public OpaliteContruct(EntityType<? extends OpaliteContruct> entity, Level level) {
        super(entity, level);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.ARMOR, 0.5).add(Attributes.MOVEMENT_SPEED, (double)0.7f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BOND_CREATOR_UUID, Optional.empty());
        builder.define(MOOKAITE_COMPANION_UUID, Optional.empty());
        builder.define(CONSTRUCT_KIT_DATA, (Object)new CompoundTag());
        builder.define(IS_CONSTRUCTING, (Object)false);
        builder.define(OPALITE_STACK, (Object)0);
        builder.define(SCARLET_STACK, (Object)0);
        builder.define(AUBURN_STACK, (Object)0);
        builder.define(GOLD_STACK, (Object)0);
        builder.define(MAUVE_STACK, (Object)0);
        builder.define(BEIGE_STACK, (Object)0);
        builder.define(IVORY_STACK, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setConstructing(tag.getBoolean("IsConstructing"));
        this.setOpaliteAmount(tag.getInt("OpaliteStack"));
        this.setMookaiteAmount(SCARLET_STACK, tag.getInt("ScarletStack"));
        this.setMookaiteAmount(AUBURN_STACK, tag.getInt("AuburnStack"));
        this.setMookaiteAmount(GOLD_STACK, tag.getInt("GoldStack"));
        this.setMookaiteAmount(MAUVE_STACK, tag.getInt("MauveStack"));
        this.setMookaiteAmount(BEIGE_STACK, tag.getInt("BeigeStack"));
        this.setMookaiteAmount(IVORY_STACK, tag.getInt("IvoryStack"));
        if (tag.hasUUID("BonderUUID")) {
            this.setBonder(tag.getUUID("BonderUUID"));
        }
        if (tag.hasUUID("MookaiteUUID")) {
            this.setMookaiteCompanion(tag.getUUID("MookaiteUUID"));
        }
        if (tag.contains("ConstructKit", 10)) {
            this.setKitData(tag.getCompound("ConstructKit"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("IsConstructing", this.isConstructing());
        tag.putInt("OpaliteStack", this.getOpaliteAmount());
        tag.putInt("ScarletStack", this.getMookaiteAmount(SCARLET_STACK));
        tag.putInt("AuburnStack", this.getMookaiteAmount(AUBURN_STACK));
        tag.putInt("GoldStack", this.getMookaiteAmount(GOLD_STACK));
        tag.putInt("MauveStack", this.getMookaiteAmount(MAUVE_STACK));
        tag.putInt("BeigeStack", this.getMookaiteAmount(BEIGE_STACK));
        tag.putInt("IvoryStack", this.getMookaiteAmount(IVORY_STACK));
        if (this.getMookaiteCompanion() != null) {
            tag.putUUID("MookaiteUUID", this.getMookaiteCompanion());
        }
        if (this.getBonder() != null) {
            tag.putUUID("BonderUUID", this.getBonder());
        }
        if (!this.getKitData().isEmpty()) {
            tag.put("ConstructKit", (Tag)this.getKitData());
        }
    }

    public void setBonder(UUID id) {
        this.entityData.set(BOND_CREATOR_UUID, Optional.ofNullable(id));
    }

    public UUID getBonder() {
        return ((Optional)this.entityData.get(BOND_CREATOR_UUID)).orElse(null);
    }

    public void setMookaiteCompanion(UUID id) {
        this.entityData.set(MOOKAITE_COMPANION_UUID, Optional.ofNullable(id));
    }

    public UUID getMookaiteCompanion() {
        return ((Optional)this.entityData.get(MOOKAITE_COMPANION_UUID)).orElse(null);
    }

    public CompoundTag getKitData() {
        return (CompoundTag)this.entityData.get(CONSTRUCT_KIT_DATA);
    }

    public void setKitData(CompoundTag tag) {
        this.entityData.set(CONSTRUCT_KIT_DATA, (Object)tag);
    }

    public boolean isConstructing() {
        return (Boolean)this.entityData.get(IS_CONSTRUCTING);
    }

    public void setConstructing(boolean flag) {
        this.entityData.set(IS_CONSTRUCTING, (Object)flag);
    }

    public boolean validateStacks(ConstructKitItem.Kit kit, ConstructKitItem.Color color) {
        boolean flag = false;
        switch (kit) {
            case REPAIR: {
                flag = this.getOpaliteAmount() >= 10;
                break;
            }
            case AUGMENT: {
                flag = this.getOpaliteAmount() >= 5 && this.getMookaiteAmount(COLOR_TO_DATA.get((Object)color)) >= 10;
                break;
            }
            case REPLACE: {
                flag = this.getMookaiteAmount(COLOR_TO_DATA.get((Object)color)) >= 5;
            }
        }
        return flag;
    }

    public boolean validateKit(ConstructKitItem.Kit kit, ConstructKitItem.Part part, ConstructKitItem.Color color) {
        boolean flag = false;
        MookaiteConstruct mookaite = this.getFollowing();
        if (mookaite != null) {
            switch (kit) {
                case REPAIR: {
                    flag = mookaite.getPart(part.getPart()) != MookaitePartType.OPALITE && mookaite.getPart(part.getPart()).isPresent();
                    break;
                }
                case AUGMENT: {
                    flag = !mookaite.getPart(part.getPart()).isPresent();
                    break;
                }
                case REPLACE: {
                    flag = mookaite.getPart(part.getPart()).isPresent() && mookaite.getPart(part.getPart()) != color.getPartColor();
                }
            }
        }
        return flag;
    }

    public boolean validateActivity() {
        if (this.getFollowing() != null && this.distanceToSqr((Entity)this.getFollowing()) < 100.0) {
            return this.getFollowing().getTarget() == null;
        }
        return false;
    }

    public void writeKitData(ConstructKitItem.Kit kit, ConstructKitItem.Part part, ConstructKitItem.Color color) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("KitID", kit.ordinal());
        tag.putInt("PartID", part.ordinal());
        if (color != null) {
            tag.putInt("ColorID", color.ordinal());
        }
        this.setKitData(tag);
    }

    public void clearKitData() {
        CompoundTag tag = new CompoundTag();
        this.setKitData(tag);
    }

    public void setOpaliteAmount(int amount) {
        this.entityData.set(OPALITE_STACK, (Object)amount);
    }

    public int getOpaliteAmount() {
        return (Integer)this.entityData.get(OPALITE_STACK);
    }

    public void setMookaiteAmount(EntityDataAccessor<Integer> mookaite, int amount) {
        this.entityData.set(mookaite, (Object)amount);
    }

    public int getMookaiteAmount(EntityDataAccessor<Integer> mookaite) {
        return (Integer)this.entityData.get(mookaite);
    }

    @Nullable
    public MookaiteConstruct getFollowing() {
        ServerLevel server;
        Entity entity;
        Level level;
        if (this.getMookaiteCompanion() != null && (level = this.level()) instanceof ServerLevel && (entity = (server = (ServerLevel)level).getEntity(this.getMookaiteCompanion())) instanceof MookaiteConstruct) {
            return (MookaiteConstruct)entity;
        }
        return null;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RepairCompanionGoal(this));
        this.goalSelector.addGoal(2, (Goal)new FollowCompanionGoal(this));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.3));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ENTITY_OPALITE_CONSTRUCT_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_OPALITE_CONSTRUCT_DEATH.get();
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean player) {
        super.dropCustomDeathLoot(level, source, player);
        if (this.getOpaliteAmount() > 0) {
            ItemStack opalite = new ItemStack((ItemLike)ModItems.opalite.get(), this.getOpaliteAmount());
            this.spawnAtLocation(level, opalite);
        }
        for (Map.Entry<Item, EntityDataAccessor<Integer>> entry : BLOCK_TO_DATA.entrySet()) {
            ItemStack mookaite = new ItemStack((ItemLike)entry.getKey(), this.getMookaiteAmount(entry.getValue()));
            this.spawnAtLocation(level, mookaite);
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (this.getBonder() != null && player.getUUID().equals(this.getBonder())) {
            if (stack.is((Item)ModItems.opalite.get())) {
                if (this.getOpaliteAmount() >= 10) {
                    player.displayClientMessage((Component)Component.translatable((String)"gaiadimension.opalite_construct.too_many_opalite"), true);
                    return InteractionResult.PASS;
                }
                this.setOpaliteAmount(this.getOpaliteAmount() + 1);
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
            if (BLOCK_TO_DATA.containsKey(item)) {
                EntityDataAccessor<Integer> data = BLOCK_TO_DATA.get(item);
                if (this.getMookaiteAmount(data) >= 10) {
                    player.displayClientMessage((Component)Component.translatable((String)"gaiadimension.opalite_construct.too_many_mookaite"), true);
                    return InteractionResult.PASS;
                }
                this.setMookaiteAmount(data, this.getMookaiteAmount(data) + 1);
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    public static boolean canSpawnHere(EntityType<OpaliteContruct> entity, LevelAccessor world, EntitySpawnReason spawn, BlockPos pos, RandomSource random) {
        return spawn == EntitySpawnReason.SPAWNER || world.getBlockState(pos.below()).isValidSpawn((BlockGetter)world, pos.below(), entity) && world.getRawBrightness(pos, 0) > 8;
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.getMookaiteCompanion() != null;
    }

    public void die(DamageSource source) {
        if (CommonHooks.onLivingDeath((LivingEntity)this, (DamageSource)source)) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel level2 = (ServerLevel)level;
            if (this.getMookaiteCompanion() != null && (entity = level2.getEntity(this.getMookaiteCompanion())) instanceof MookaiteConstruct) {
                MookaiteConstruct mookaite = (MookaiteConstruct)entity;
                mookaite.setOpaliteCompanion(null);
                mookaite.setBonder(null);
                mookaite.setConstructing(false);
            }
        }
        super.die(source);
    }

    static class RepairCompanionGoal
    extends Goal {
        private final OpaliteContruct opalite;
        private MookaiteConstruct mookaite;
        private int repairTime;
        private boolean isDone;

        public RepairCompanionGoal(OpaliteContruct entity) {
            this.opalite = entity;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !this.opalite.getKitData().isEmpty() && this.opalite.getMookaiteCompanion() != null && this.opalite.getFollowing() != null && this.opalite.distanceToSqr((Entity)this.opalite.getFollowing()) <= 100.0;
        }

        public boolean canContinueToUse() {
            return !this.isDone && this.opalite.getMookaiteCompanion() != null;
        }

        public void start() {
            super.start();
            this.mookaite = this.opalite.getFollowing();
            this.mookaite.setConstructing(true);
            this.repairTime = 10;
            this.isDone = false;
        }

        public void stop() {
            super.stop();
            this.mookaite.setConstructing(false);
            this.opalite.clearKitData();
            this.opalite.setConstructing(false);
        }

        public void tick() {
            ServerLevel server;
            Level level = this.opalite.level();
            if (level instanceof ServerLevel && (server = (ServerLevel)level).getEntity(this.opalite.getMookaiteCompanion()) instanceof MookaiteConstruct) {
                this.opalite.getNavigation().moveTo((Entity)this.mookaite, 0.5);
                this.opalite.getLookControl().setLookAt((Entity)this.mookaite);
                if (this.opalite.getNavigation().isDone()) {
                    if (this.repairTime == 10) {
                        this.opalite.setConstructing(true);
                        this.opalite.playSound(SoundEvents.ANVIL_USE);
                    }
                    if (this.repairTime == 0) {
                        ConstructKitItem.Kit kit = ConstructKitItem.Kit.values()[this.opalite.getKitData().getInt("KitID")];
                        MookaiteConstruct.MookaitePart part = ConstructKitItem.Part.values()[this.opalite.getKitData().getInt("PartID")].getPart();
                        ConstructKitItem.Color kitcolor = ConstructKitItem.Color.values()[this.opalite.getKitData().getInt("ColorID")];
                        MookaitePartType color = kitcolor.getPartColor();
                        if (kit == ConstructKitItem.Kit.REPAIR) {
                            color = MookaitePartType.OPALITE;
                        }
                        switch (kit) {
                            case REPAIR: {
                                this.opalite.setOpaliteAmount(this.opalite.getOpaliteAmount() - 10);
                                break;
                            }
                            case AUGMENT: {
                                this.opalite.setOpaliteAmount(this.opalite.getOpaliteAmount() - 5);
                                this.opalite.setMookaiteAmount(COLOR_TO_DATA.get((Object)kitcolor), this.opalite.getMookaiteAmount(COLOR_TO_DATA.get((Object)kitcolor)) - 10);
                                break;
                            }
                            case REPLACE: {
                                this.opalite.setMookaiteAmount(COLOR_TO_DATA.get((Object)kitcolor), this.opalite.getMookaiteAmount(COLOR_TO_DATA.get((Object)kitcolor)) - 5);
                            }
                        }
                        this.mookaite.setPart(part, color);
                        this.isDone = true;
                    }
                    --this.repairTime;
                }
            }
        }
    }

    static class FollowCompanionGoal
    extends Goal {
        private final OpaliteContruct opalite;
        private MookaiteConstruct mookaite;
        private final LevelAccessor world;
        private final double followSpeed = 0.4;
        private final PathNavigation navigator;
        private int timeToRecalcPath;
        private final float maxDist = 2.0f;
        private final float minDist = 10.0f;
        private float oldWaterCost;

        public FollowCompanionGoal(OpaliteContruct entity) {
            this.opalite = entity;
            this.world = entity.level();
            this.navigator = entity.getNavigation();
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            MookaiteConstruct mookaite = this.opalite.getFollowing();
            if (mookaite == null) {
                return false;
            }
            if (mookaite.isSpectator()) {
                return false;
            }
            if (this.opalite.distanceToSqr((Entity)mookaite) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            this.mookaite = mookaite;
            return true;
        }

        public boolean canContinueToUse() {
            return !this.navigator.isDone() && this.opalite.distanceToSqr((Entity)this.mookaite) > (double)(this.maxDist * this.maxDist);
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.opalite.getPathfindingMalus(PathType.WATER);
            this.opalite.setPathfindingMalus(PathType.WATER, 0.0f);
        }

        public void stop() {
            this.mookaite = null;
            this.navigator.stop();
            this.opalite.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        }

        public void tick() {
            this.opalite.getLookControl().setLookAt((Entity)this.mookaite, 10.0f, (float)this.opalite.getMaxHeadXRot());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.opalite.isLeashed() && !this.opalite.isPassenger()) {
                    if (this.opalite.distanceToSqr((Entity)this.mookaite) >= 144.0) {
                        this.tryTeleport();
                    } else {
                        this.navigator.moveTo((Entity)this.mookaite, this.followSpeed);
                    }
                }
            }
        }

        private void tryTeleport() {
            BlockPos guardpos = new BlockPos((Vec3i)this.mookaite.blockPosition());
            for (int chance = 0; chance < 10; ++chance) {
                int rx = this.getRandomInt(-3, 3);
                int ry = this.getRandomInt(-1, 1);
                int rz = this.getRandomInt(-3, 3);
                boolean teleport = this.tryTeleportTo(guardpos.getX() + rx, guardpos.getY() + ry, guardpos.getZ() + rz);
                if (!teleport) continue;
                return;
            }
        }

        private boolean tryTeleportTo(int x, int y, int z) {
            if (Math.abs((double)x - this.mookaite.getX()) < 2.0 && Math.abs((double)z - this.mookaite.getZ()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new BlockPos(x, y, z))) {
                return false;
            }
            this.opalite.moveTo((float)x + 0.5f, y, (float)z + 0.5f, this.opalite.getYRot(), this.opalite.getXRot());
            this.navigator.stop();
            return true;
        }

        private boolean canTeleportTo(BlockPos pos) {
            PathType nodeType = WalkNodeEvaluator.getPathTypeStatic((Mob)this.opalite, (BlockPos)pos.mutable());
            if (nodeType != PathType.WALKABLE) {
                return false;
            }
            BlockState state = this.world.getBlockState(pos.below());
            if (state.getBlock() instanceof LeavesBlock) {
                return false;
            }
            BlockPos posDown = pos.subtract((Vec3i)this.opalite.blockPosition());
            return this.world.noCollision((Entity)this.opalite, this.opalite.getBoundingBox().move(posDown));
        }

        private int getRandomInt(int min, int max) {
            return this.opalite.getRandom().nextInt(max - min + 1) + min;
        }
    }
}

