/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity.boss;

import androsa.gaiadimension.entity.MalachiteDrone;
import androsa.gaiadimension.entity.data.GuardPhase;
import androsa.gaiadimension.entity.data.ThreeStagePhase;
import androsa.gaiadimension.registry.bootstrap.GaiaDamage;
import androsa.gaiadimension.registry.registration.ModEntities;
import androsa.gaiadimension.registry.registration.ModItems;
import androsa.gaiadimension.registry.registration.ModParticles;
import androsa.gaiadimension.registry.registration.ModSounds;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;

public class MalachiteGuard
extends Monster {
    private static final EntityDataAccessor<GuardPhase> PHASE = SynchedEntityData.defineId(MalachiteGuard.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.GUARD_PHASE.get()));
    private static final EntityDataAccessor<ThreeStagePhase> STOMP_PHASE = SynchedEntityData.defineId(MalachiteGuard.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.THREE_STAGE_PHASE.get()));
    private static final EntityDataAccessor<ThreeStagePhase> CHARGE_PHASE = SynchedEntityData.defineId(MalachiteGuard.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.THREE_STAGE_PHASE.get()));
    private int dronesLeft;
    private boolean hasSpawnedDrones;
    private int stompCooldown;
    private int chargeCooldown;
    private float bideDamage;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);

    public MalachiteGuard(EntityType<? extends MalachiteGuard> entity, Level world) {
        super(entity, world);
        this.xpReward = 75;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, 0.6).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(Attributes.STEP_HEIGHT, 1.5);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PHASE, (Object)GuardPhase.DEFENCE);
        builder.define(STOMP_PHASE, (Object)ThreeStagePhase.IDLE);
        builder.define(CHARGE_PHASE, (Object)ThreeStagePhase.IDLE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new DefendGoal());
        this.goalSelector.addGoal(1, (Goal)new StompAttackGoal(this));
        this.goalSelector.addGoal(2, (Goal)new BlastAttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, true));
        this.goalSelector.addGoal(4, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.6, 32.0f));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setPhase(GuardPhase.getPhase(nbt.getInt("Phase")));
        this.setStompPhase(ThreeStagePhase.getStage(nbt.getInt("StompPhase")));
        this.setChargePhase(ThreeStagePhase.getStage(nbt.getInt("ChargePhase")));
        this.dronesLeft = nbt.getInt("DronesLeft");
        this.hasSpawnedDrones = nbt.getBoolean("IsSpawned");
        this.stompCooldown = nbt.getInt("StompCooldown");
        this.chargeCooldown = nbt.getInt("ChargeCooldown");
        this.bideDamage = nbt.getFloat("BideDamage");
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("Phase", this.getPhase().getId());
        nbt.putInt("StompPhase", this.getStompPhase().getId());
        nbt.putInt("ChargePhase", this.getChargePhase().getId());
        nbt.putInt("DronesLeft", this.dronesLeft);
        nbt.putBoolean("IsSpawned", this.hasSpawnedDrones);
        nbt.putInt("StompCooldown", this.stompCooldown);
        nbt.putInt("ChargeCooldown", this.chargeCooldown);
        nbt.putFloat("BideDamage", this.bideDamage);
    }

    public void setCustomName(@Nullable Component text) {
        super.setCustomName(text);
        this.bossInfo.setName(this.getDisplayName());
    }

    public GuardPhase getPhase() {
        return (GuardPhase)((Object)this.entityData.get(PHASE));
    }

    private void setPhase(GuardPhase id) {
        this.entityData.set(PHASE, (Object)id);
    }

    public ThreeStagePhase getStompPhase() {
        return (ThreeStagePhase)((Object)this.entityData.get(STOMP_PHASE));
    }

    public void setStompPhase(ThreeStagePhase id) {
        this.entityData.set(STOMP_PHASE, (Object)id);
    }

    public ThreeStagePhase getChargePhase() {
        return (ThreeStagePhase)((Object)this.entityData.get(CHARGE_PHASE));
    }

    private void setChargePhase(ThreeStagePhase id) {
        this.entityData.set(CHARGE_PHASE, (Object)id);
    }

    public void move(MoverType type, Vec3 motion) {
        if (this.getPhase().canMove() && (this.getStompPhase() == ThreeStagePhase.IDLE || this.getChargePhase() == ThreeStagePhase.IDLE)) {
            super.move(type, motion);
        }
    }

    public void knockback(double amount, double x, double z) {
        if (!this.getPhase().isResistant() || this.getChargePhase() != ThreeStagePhase.IDLE || this.getStompPhase() != ThreeStagePhase.IDLE) {
            super.knockback(amount, x, z);
        }
    }

    public boolean causeFallDamage(float dist, float mul, DamageSource source) {
        return false;
    }

    public void setTarget(@Nullable LivingEntity entity) {
        if (this.level().getDifficulty() == Difficulty.NORMAL || this.level().getDifficulty() == Difficulty.HARD) {
            if (entity instanceof Player && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity)) {
                super.setTarget(entity);
            }
        } else if (this.level().getDifficulty() == Difficulty.EASY) {
            if (entity instanceof Player) {
                if (EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity)) {
                    super.setTarget(entity);
                }
            } else {
                super.setTarget(entity);
            }
        }
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ENTITY_MALACHITE_GUARD_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_MALACHITE_GUARD_DEATH.get();
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.6f;
    }

    public void tick() {
        super.tick();
        if (this.getChargePhase() == ThreeStagePhase.CHARGE && this.level().isClientSide()) {
            for (int i = 0; i < 3; ++i) {
                this.level().addParticle((ParticleOptions)ModParticles.MALACHITE_MAGIC.get(), this.getRandomX(3.0), this.getY() + this.random.nextDouble() * 0.25, this.getRandomZ(3.0), 0.0, 0.0, 0.0);
            }
        }
        if (!this.level().isClientSide()) {
            this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        }
    }

    private void spawnDrones() {
        BlockPos position = this.blockPosition();
        Difficulty difficulty = this.level().getDifficulty();
        if (difficulty == Difficulty.EASY) {
            this.createDrone(position.east(2));
            this.createDrone(position.south());
            this.createDrone(position.west(2));
        }
        if (difficulty == Difficulty.NORMAL) {
            this.createDrone(position.east(2).north());
            this.createDrone(position.east(2).south());
            this.createDrone(position.west(2).north());
            this.createDrone(position.west(2).south());
        }
        if (difficulty == Difficulty.HARD) {
            this.createDrone(position.east(2).north());
            this.createDrone(position.east(2).south());
            this.createDrone(position.west(2).north());
            this.createDrone(position.west(2).south());
            this.createDrone(position.south(2));
        }
    }

    private void createDrone(BlockPos pos) {
        if (!this.level().isClientSide()) {
            MalachiteDrone drone = (MalachiteDrone)((EntityType)ModEntities.MALACHITE_DRONE.get()).create(this.level(), EntitySpawnReason.MOB_SUMMONED);
            drone.moveTo(pos, 0.0f, 0.0f);
            EventHooks.finalizeMobSpawn((Mob)drone, (ServerLevelAccessor)((ServerLevelAccessor)this.level()), (DifficultyInstance)this.level().getCurrentDifficultyAt(pos), (EntitySpawnReason)EntitySpawnReason.MOB_SUMMONED, null);
            drone.setOwner((LivingEntity)this);
            if (this.level().addFreshEntity((Entity)drone)) {
                ++this.dronesLeft;
            }
        }
    }

    public void onDroneKilled() {
        --this.dronesLeft;
    }

    public void aiStep() {
        switch (this.getPhase()) {
            case DEFENCE: {
                Vec3 motion = this.getDeltaMovement();
                this.setDeltaMovement(0.0, motion.y(), 0.0);
                if (this.level().isClientSide()) break;
                if (!this.hasSpawnedDrones) {
                    this.spawnDrones();
                    this.hasSpawnedDrones = true;
                }
                if (this.dronesLeft > 0 || !this.hasSpawnedDrones) break;
                this.setPhase(GuardPhase.ATTACK);
                break;
            }
            case ATTACK: {
                if (!(this.getHealth() <= this.getMaxHealth() / 2.0f)) break;
                this.setPhase(GuardPhase.RESIST);
                break;
            }
            case RESIST: {
                if (!(this.getHealth() > this.getMaxHealth() / 2.0f)) break;
                this.setPhase(GuardPhase.ATTACK);
            }
        }
        float movespeed = (float)this.getAttribute(Attributes.MOVEMENT_SPEED).getValue();
        if (this.getPhase() == GuardPhase.RESIST) {
            movespeed *= 0.35f;
        } else if (this.getPhase() == GuardPhase.DEFENCE) {
            movespeed = 0.0f;
        }
        this.setSpeed(movespeed);
        if (this.stompCooldown > 0) {
            --this.stompCooldown;
        }
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
        super.aiStep();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    protected boolean isAffectedByFluids() {
        return false;
    }

    public boolean doHurtTarget(ServerLevel level, Entity target) {
        boolean flag = super.doHurtTarget(level, target);
        Difficulty difficulty = this.level().getDifficulty();
        if ((difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) && target instanceof Player) {
            Player player = (Player)target;
            NonNullList armor = player.getInventory().armor;
            int slot = this.random.nextInt(armor.size());
            ItemStack stack = (ItemStack)armor.get(slot);
            EquipmentSlot[] equipment = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
            EquipmentSlot slotType = equipment[slot];
            if (difficulty == Difficulty.NORMAL && this.random.nextInt(16) == 0 || difficulty == Difficulty.HARD && this.random.nextInt(8) == 0) {
                player.drop(stack, true, false);
                player.setItemSlot(slotType, ItemStack.EMPTY);
            }
        }
        return flag;
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        if (this.getChargePhase() == ThreeStagePhase.CHARGE && this.isAllowedToDamage(source)) {
            if (level.getDifficulty() == Difficulty.EASY) {
                this.bideDamage += (amount /= 4.0f);
                amount *= 3.0f;
            } else if (level.getDifficulty() == Difficulty.NORMAL) {
                this.bideDamage += (amount /= 2.0f);
            } else if (level.getDifficulty() == Difficulty.HARD) {
                this.bideDamage += (amount /= 4.0f) * 3.0f;
            }
        }
        return switch (this.getPhase()) {
            default -> throw new MatchException(null, null);
            case GuardPhase.DEFENCE -> {
                if (this.blockPosition().getY() < -64 && super.hurtServer(level, source, amount)) {
                    yield true;
                }
                yield false;
            }
            case GuardPhase.ATTACK -> {
                float threshold = this.getMaxHealth() / 2.0f - 2.0f;
                float remaining = this.getHealth() - threshold;
                if (amount > remaining) {
                    amount = remaining;
                }
                yield super.hurtServer(level, source, amount);
            }
            case GuardPhase.RESIST -> {
                if (this.isAllowedToDamage(source)) {
                    float multiply = this.getMultiplier(amount);
                    yield super.hurtServer(level, source, amount * multiply);
                }
                yield this.blockPosition().getY() < -64 && super.hurtServer(level, source, amount);
            }
        };
    }

    private boolean isAllowedToDamage(DamageSource source) {
        Entity entity = source.getDirectEntity();
        if (this.level().getDifficulty() == Difficulty.NORMAL || this.level().getDifficulty() == Difficulty.HARD) {
            return entity instanceof Player;
        }
        return entity instanceof LivingEntity;
    }

    private float getMultiplier(float base) {
        return switch (this.level().getDifficulty()) {
            case Difficulty.EASY -> {
                if (base > 50.0f) {
                    yield 0.25f;
                }
                if (base > 25.0f) {
                    yield 0.5f;
                }
                if (base > 10.0f) {
                    yield 0.75f;
                }
                yield 1.0f;
            }
            case Difficulty.NORMAL -> {
                if (base > 100.0f) {
                    yield 0.0f;
                }
                if (base > 50.0f) {
                    yield 0.125f;
                }
                if (base > 25.0f) {
                    yield 0.25f;
                }
                if (base > 10.0f) {
                    yield 0.5f;
                }
                yield 1.0f;
            }
            case Difficulty.HARD -> {
                if (base > 75.0f) {
                    yield 0.0f;
                }
                if (base > 50.0f) {
                    yield 0.125f;
                }
                if (base > 25.0f) {
                    yield 0.25f;
                }
                if (base > 10.0f) {
                    yield 0.5f;
                }
                yield 1.0f;
            }
            default -> base;
        };
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return this.level().getDifficulty() == Difficulty.HARD && ((MobEffect)effectInstance.getEffect().value()).isBeneficial();
    }

    public void kill(ServerLevel level) {
        this.setHealth(0.0f);
        super.kill(level);
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            if (!this.level().isClientSide()) {
                this.spawnAtLocation((ServerLevel)this.level(), (ItemLike)ModItems.mock_malachite.get(), 1);
            }
            this.discard();
        }
        super.checkDespawn();
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public boolean canTeleport(Level from, Level to) {
        return false;
    }

    protected boolean canRide(Entity entity) {
        return false;
    }

    class DefendGoal
    extends Goal {
        public DefendGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            return !MalachiteGuard.this.getPhase().canMove();
        }
    }

    static class StompAttackGoal
    extends Goal {
        private final MalachiteGuard guard;
        private int stompTime;

        public StompAttackGoal(MalachiteGuard entity) {
            this.guard = entity;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.guard.getPhase().canMove() && this.guard.getChargePhase() == ThreeStagePhase.IDLE && this.guard.stompCooldown <= 0) {
                List list = this.guard.level().getEntities((Entity)this.guard, this.guard.getBoundingBox().inflate(2.0), entity -> {
                    EntityType type = entity.getType();
                    if (type == EntityType.PLAYER) {
                        return EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity);
                    }
                    return false;
                });
                for (Entity entity2 : list) {
                    if (!entity2.onGround() || !(entity2.distanceToSqr((Entity)this.guard) > 1.0) || !(entity2.distanceToSqr((Entity)this.guard) < 4.0)) continue;
                    return entity2.isAlive();
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.guard.stompCooldown <= 0;
        }

        public void start() {
            this.guard.setStompPhase(ThreeStagePhase.CHARGE);
            this.stompTime = 0;
        }

        public void stop() {
            this.guard.setStompPhase(ThreeStagePhase.IDLE);
        }

        public void tick() {
            ++this.stompTime;
            if (this.stompTime == 20) {
                this.guard.setStompPhase(ThreeStagePhase.EXECUTE);
                List targets = this.guard.level().getEntities((Entity)this.guard, this.guard.getBoundingBox().inflate(3.0, -2.0, 3.0), entity -> {
                    EntityType type = entity.getType();
                    return type != ModEntities.MALACHITE_GUARD.get() && type != ModEntities.MALACHITE_DRONE.get();
                });
                this.guard.playSound(ModSounds.ENTITY_MALACHITE_GUARD_STOMP.get(), 1.0f, 1.0f);
                for (Entity entity2 : targets) {
                    Vec3 targetV3D = entity2.getDeltaMovement();
                    entity2.hurt(this.guard.damageSources().mobAttack((LivingEntity)this.guard), 5.0f);
                    entity2.setDeltaMovement(targetV3D.x() * 0.5, targetV3D.y() + (double)0.4f, targetV3D.z() * 0.5);
                }
                if (!this.guard.level().isClientSide()) {
                    for (int x = -3; x <= 3; ++x) {
                        for (int z = -3; z <= 3; ++z) {
                            BlockPos pos = this.guard.blockPosition().offset(x, 0, z);
                            BlockState state = this.guard.level().getBlockState(pos.below());
                            ((ServerLevel)this.guard.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), (double)pos.getX(), this.guard.getY() + this.guard.random.nextDouble() * 0.25, (double)pos.getZ(), 5, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.stompTime >= 30) {
                this.guard.stompCooldown = 120;
            }
        }
    }

    static class BlastAttackGoal
    extends Goal {
        private final MalachiteGuard guard;
        private int attackPhase;
        private int chargeTimer;
        private int explodeTime;

        public BlastAttackGoal(MalachiteGuard entity) {
            this.guard = entity;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.guard.getPhase().canMove() && this.guard.getStompPhase() == ThreeStagePhase.IDLE && this.guard.chargeCooldown <= 0) {
                List list = this.guard.level().getEntities((Entity)this.guard, this.guard.getBoundingBox().inflate(3.0), entity -> {
                    EntityType type = entity.getType();
                    if (type == EntityType.PLAYER) {
                        return EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity);
                    }
                    return false;
                });
                for (Entity entity2 : list) {
                    double guardY;
                    double targetY = entity2.blockPosition().getY();
                    if (!(targetY < (guardY = (double)this.guard.blockPosition().getY()) - 1.0) && !(targetY > guardY + 1.0)) continue;
                    return entity2.isAlive() && this.guard.onGround();
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.guard.chargeCooldown <= 0;
        }

        public void start() {
            this.guard.getNavigation().stop();
            this.guard.setChargePhase(ThreeStagePhase.CHARGE);
            this.attackPhase = 0;
            this.chargeTimer = 100;
            this.explodeTime = 0;
        }

        public void stop() {
            this.guard.setChargePhase(ThreeStagePhase.IDLE);
            this.guard.bideDamage = 0.0f;
        }

        public void tick() {
            --this.chargeTimer;
            if (this.chargeTimer <= 0) {
                if (this.attackPhase == 0) {
                    this.guard.setChargePhase(ThreeStagePhase.EXECUTE);
                    ++this.attackPhase;
                }
                if (this.explodeTime == 0) {
                    List targets = this.guard.level().getEntities((Entity)this.guard, this.guard.getBoundingBox().inflate(4.0), entity -> {
                        EntityType type = entity.getType();
                        return type != ModEntities.MALACHITE_GUARD.get() && type != ModEntities.MALACHITE_DRONE.get();
                    });
                    this.guard.playSound(ModSounds.ENTITY_MALACHITE_GUARD_BLAST.get(), 1.0f, 1.0f);
                    for (Entity entity2 : targets) {
                        Vec3 explosion = new Vec3(this.guard.getX(), this.guard.getY(), this.guard.getZ());
                        Vec3 direction = entity2.position().subtract(explosion).normalize();
                        entity2.hurt(GaiaDamage.getDamage(this.guard.level(), GaiaDamage.MALACHITE_BLAST), 8.0f + this.guard.bideDamage);
                        entity2.setDeltaMovement(direction.x(), direction.y() + (double)0.2f, direction.z());
                    }
                }
                if (this.explodeTime < 10 && !this.guard.level().isClientSide()) {
                    for (int i = 0; i < 5; ++i) {
                        ((ServerLevel)this.guard.level()).sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.MALACHITE_MAGIC.get()), this.guard.getRandomX(1.0), this.guard.getRandomY(), this.guard.getRandomZ(1.0), 5, this.guard.random.nextDouble() - 0.5, this.guard.random.nextDouble() * 0.5, this.guard.random.nextDouble() - 0.5, 0.5);
                    }
                }
                ++this.explodeTime;
                if (this.explodeTime >= 20) {
                    this.guard.chargeCooldown = 60;
                }
            }
        }
    }
}

