/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity.data;

import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;

public enum MookaitePartType implements StringRepresentable
{
    NONE("none", 0, 0.25f, false),
    SCARLET("scarlet", 1, 0.5f, true),
    AUBURN("auburn", 2, 0.5f, true),
    GOLD("gold", 3, 0.5f, true),
    MAUVE("mauve", 4, 0.5f, true),
    BEIGE("beige", 5, 0.5f, true),
    IVORY("ivory", 6, 0.5f, true),
    OPALITE("opalite", 7, 1.0f, true);

    @Deprecated
    private static final StringRepresentable.EnumCodec<MookaitePartType> CODEC;
    private static final IntFunction<MookaitePartType> BY_ID;
    public static final StreamCodec<ByteBuf, MookaitePartType> STREAM_CODEC;
    private final String name;
    private final int id;
    private final float multiplier;
    private final boolean present;

    private MookaitePartType(String name, int id, float multiplier, boolean present) {
        this.name = name;
        this.id = id;
        this.multiplier = multiplier;
        this.present = present;
    }

    public String getSerializedName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public boolean isPresent() {
        return this.present;
    }

    public static MookaitePartType fromName(String name) {
        return (MookaitePartType)CODEC.byName(name, (Enum)NONE);
    }

    public static MookaitePartType getRandom(RandomSource random) {
        return BY_ID.apply(random.nextInt(MookaitePartType.values().length - 1));
    }

    static {
        CODEC = StringRepresentable.fromEnum(MookaitePartType::values);
        BY_ID = ByIdMap.continuous(MookaitePartType::getId, (Object[])MookaitePartType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, MookaitePartType::getId);
    }
}

