/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity.data;

import androsa.gaiadimension.registry.registration.ModItems;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ItemLike;

public enum SapperVariant implements StringRepresentable
{
    COMMON(0, "pink", "common"),
    CHILLED(1, "blue", "chilled"),
    NUTRIENT(2, "green", "nutrient"),
    MYSTIFIED(3, "purple", "mystified");

    private static final IntFunction<SapperVariant> BY_ID;
    public static final StringRepresentable.EnumCodec<SapperVariant> CODEC;
    public static final StreamCodec<ByteBuf, SapperVariant> STREAM_CODEC;
    private final int id;
    private final String name;
    private final String variant;

    private SapperVariant(int id, String name, String variant) {
        this.id = id;
        this.name = name;
        this.variant = variant;
    }

    public String getSerializedName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public String getVariant() {
        return this.variant;
    }

    public static SapperVariant getVariant(int id) {
        return BY_ID.apply(id);
    }

    public static SapperVariant getRandomVariant(RandomSource random) {
        return BY_ID.apply(random.nextInt(SapperVariant.values().length));
    }

    static {
        BY_ID = ByIdMap.continuous(SapperVariant::getId, (Object[])SapperVariant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        CODEC = StringRepresentable.fromEnum(SapperVariant::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, SapperVariant::getId);
    }

    public static interface SapperLoot {
        public static final Map<SapperVariant, ItemLike> GEODE_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(SapperVariant.class), map -> {
            map.put(COMMON, ModItems.pink_geode);
            map.put(CHILLED, ModItems.blue_geode);
            map.put(NUTRIENT, ModItems.green_geode);
            map.put(MYSTIFIED, ModItems.purple_geode);
        });
    }
}

