/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity.projectile;

import androsa.gaiadimension.entity.MookaiteConstruct;
import androsa.gaiadimension.registry.registration.ModEntities;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;

public class MookaiteAreaEffect
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.defineId(MookaiteAreaEffect.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private int duration = 600;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private UUID companionUUID;
    @Nullable
    private UUID bonderUUID;

    public MookaiteAreaEffect(EntityType<? extends MookaiteAreaEffect> entity, Level level) {
        super(entity, level);
        this.noPhysics = true;
    }

    public MookaiteAreaEffect(Level level, double x, double y, double z) {
        this((EntityType<? extends MookaiteAreaEffect>)((EntityType)ModEntities.MOOKAITE_MAGIC_AREA.get()), level);
        this.setPos(x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_RADIUS, (Object)Float.valueOf(3.0f));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.tickCount = tag.getInt("Age");
        this.duration = tag.getInt("Duration");
        this.setRadius(tag.getFloat("Radius"));
        if (tag.hasUUID("Owner")) {
            this.ownerUUID = tag.getUUID("Owner");
        }
        if (tag.hasUUID("Companion")) {
            this.companionUUID = tag.getUUID("Companion");
        }
        if (tag.hasUUID("Bonder")) {
            this.bonderUUID = tag.getUUID("Bonder");
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("Age", this.tickCount);
        tag.putInt("Duration", this.duration);
        tag.putFloat("Radius", this.getRadius());
        if (this.ownerUUID != null) {
            tag.putUUID("Owner", this.ownerUUID);
        }
        if (this.companionUUID != null) {
            tag.putUUID("Companion", this.companionUUID);
        }
        if (this.bonderUUID != null) {
            tag.putUUID("Bonder", this.bonderUUID);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (DATA_RADIUS.equals(data)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(data);
    }

    public void refreshDimensions() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        super.refreshDimensions();
        this.setPos(x, y, z);
    }

    public float getRadius() {
        return ((Float)this.getEntityData().get(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        if (!this.level().isClientSide()) {
            this.getEntityData().set(DATA_RADIUS, (Object)Float.valueOf(Mth.clamp((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int time) {
        this.duration = time;
    }

    public void tick() {
        block4: {
            List entities;
            float radius;
            block3: {
                super.tick();
                radius = this.getRadius();
                if (!this.level().isClientSide) break block3;
                int area = Mth.ceil((float)((float)Math.PI * radius * radius));
                for (int j = 0; j < area; ++j) {
                    float wave = this.random.nextFloat() * ((float)Math.PI * 2);
                    float dist = Mth.sqrt((float)this.random.nextFloat()) * radius;
                    double x = this.getX() + (double)(Mth.cos((float)wave) * dist);
                    double y = this.getY();
                    double z = this.getZ() + (double)(Mth.sin((float)wave) * dist);
                    double vx = (0.5 - this.random.nextDouble()) * 0.15;
                    double vy = 0.01;
                    double vz = (0.5 - this.random.nextDouble()) * 0.15;
                    this.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.ENCHANTED_HIT, x, y, z, vx, vy, vz);
                }
                break block4;
            }
            if (this.tickCount >= this.duration) {
                this.discard();
                return;
            }
            if (this.tickCount % 5 != 0 || (entities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox(), entity -> this.validateUUID((LivingEntity)entity, this.ownerUUID) && this.validateUUID((LivingEntity)entity, this.companionUUID) && this.validateUUID((LivingEntity)entity, this.bonderUUID))).isEmpty()) break block4;
            for (LivingEntity livingentity : entities) {
                double z;
                double x = livingentity.getX() - this.getX();
                double dist = x * x + (z = livingentity.getZ() - this.getZ()) * z;
                if (!(dist <= (double)(radius * radius))) continue;
                livingentity.hurt(this.level().damageSources().magic(), 2.0f);
            }
        }
    }

    public boolean hurtServer(ServerLevel server, DamageSource source, float amount) {
        return false;
    }

    private boolean validateUUID(LivingEntity entity, UUID id) {
        if (id != null) {
            return !entity.getUUID().equals(id);
        }
        return false;
    }

    public void setOwner(@Nullable LivingEntity entity) {
        this.owner = entity;
        UUID uUID = this.ownerUUID = entity == null ? null : entity.getUUID();
        if (entity instanceof MookaiteConstruct) {
            MookaiteConstruct mookaite = (MookaiteConstruct)entity;
            if (mookaite.getOpaliteCompanion() != null) {
                this.companionUUID = mookaite.getOpaliteCompanion();
            }
            if (mookaite.getBonder() != null) {
                this.bonderUUID = mookaite.getBonder();
            }
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)(this.getRadius() * 2.0f), (float)0.5f);
    }
}

