/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.item;

import androsa.gaiadimension.entity.MookaiteConstruct;
import androsa.gaiadimension.entity.OpaliteContruct;
import androsa.gaiadimension.registry.registration.ModDataComponents;
import androsa.gaiadimension.registry.registration.ModEntities;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ConstructCharmItem
extends Item {
    public ConstructCharmItem(Item.Properties props) {
        super(props);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nonnull
    @ParametersAreNonnullByDefault
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (!(entity instanceof MookaiteConstruct) && !(entity instanceof OpaliteContruct)) {
            this.displayMessage(player, "invalid_entity");
            return InteractionResult.PASS;
        }
        if (entity instanceof MookaiteConstruct) {
            MookaiteConstruct mookaite = (MookaiteConstruct)entity;
            if (stack.has(ModDataComponents.MOOKAITE_UUID)) {
                this.displayMessage(player, "has_opalite_bond");
                return InteractionResult.PASS;
            }
            if (mookaite.getOpaliteCompanion() != null) {
                this.displayMessage(player, "mookaite_already_bonded");
                return InteractionResult.PASS;
            }
            this.setUUID(stack, mookaite.getUUID(), (Supplier<DataComponentType<UUID>>)ModDataComponents.MOOKAITE_UUID);
        }
        if (entity instanceof OpaliteContruct) {
            OpaliteContruct opalite = (OpaliteContruct)entity;
            if (stack.has(ModDataComponents.OPALITE_UUID)) {
                this.displayMessage(player, "has_mookaite_bond");
                return InteractionResult.PASS;
            }
            if (opalite.getMookaiteCompanion() != null) {
                this.displayMessage(player, "opalite_already_bonded");
                return InteractionResult.PASS;
            }
            this.setUUID(stack, opalite.getUUID(), (Supplier<DataComponentType<UUID>>)ModDataComponents.OPALITE_UUID);
        }
        if (stack.has(ModDataComponents.MOOKAITE_UUID) && stack.has(ModDataComponents.OPALITE_UUID)) {
            boolean mFlag = false;
            boolean oFlag = false;
            Entity mookaite = null;
            Entity opalite = null;
            if (!player.level().isClientSide()) {
                List entities = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(16.0), e -> {
                    EntityType type = e.getType();
                    return type == ModEntities.MOOKAITE_CONSTRUCT.get() || type == ModEntities.OPALITE_CONSTRUCT.get();
                });
                for (Entity e2 : entities) {
                    if (e2.getUUID().equals(this.getUUID(stack, (Supplier<DataComponentType<UUID>>)ModDataComponents.MOOKAITE_UUID))) {
                        mFlag = true;
                        mookaite = e2;
                    }
                    if (!e2.getUUID().equals(this.getUUID(stack, (Supplier<DataComponentType<UUID>>)ModDataComponents.OPALITE_UUID))) continue;
                    oFlag = true;
                    opalite = e2;
                }
            }
            if (mFlag && oFlag) {
                mFlag = mookaite instanceof MookaiteConstruct;
                oFlag = opalite instanceof OpaliteContruct;
                if (mookaite instanceof MookaiteConstruct) {
                    MookaiteConstruct mEntity = (MookaiteConstruct)mookaite;
                    if (opalite instanceof OpaliteContruct) {
                        OpaliteContruct oEntity = (OpaliteContruct)opalite;
                        if (!player.level().isClientSide()) {
                            mEntity.setBonder(player.getUUID());
                            mEntity.setOpaliteCompanion(oEntity.getUUID());
                            oEntity.setBonder(player.getUUID());
                            oEntity.setMookaiteCompanion(mEntity.getUUID());
                            stack.shrink(1);
                        }
                        this.displayMessage(player, "success");
                        return InteractionResult.CONSUME;
                    }
                }
                if (!mFlag && !oFlag) {
                    this.displayMessage(player, "both_invalid");
                } else if (!mFlag) {
                    this.displayMessage(player, "mookaite_invalid");
                } else if (!oFlag) {
                    this.displayMessage(player, "opalite_invalid");
                }
                if (!player.level().isClientSide()) {
                    this.reset(stack);
                }
                return InteractionResult.PASS;
            }
            if (!mFlag && !oFlag) {
                this.displayMessage(player, "both_out_of_range");
            } else if (!mFlag) {
                this.displayMessage(player, "mookaite_out_of_range");
            } else if (!oFlag) {
                this.displayMessage(player, "opalite_out_of_range");
            }
            if (!player.level().isClientSide()) {
                this.reset(stack);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    private void displayMessage(Player player, String name) {
        player.displayClientMessage((Component)Component.translatable((String)("gaiadimension.construct_charm.message." + name)), true);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide()) {
                this.reset(stack);
            }
            player.displayClientMessage((Component)Component.translatable((String)"construct_charm.message.reset"), true);
            return InteractionResult.SUCCESS.heldItemTransformedTo(stack);
        }
        return InteractionResult.PASS;
    }

    private void reset(ItemStack stack) {
        this.removeUUID(stack, (Supplier<DataComponentType<UUID>>)ModDataComponents.MOOKAITE_UUID);
        this.removeUUID(stack, (Supplier<DataComponentType<UUID>>)ModDataComponents.OPALITE_UUID);
    }

    public void setUUID(ItemStack stack, UUID id, Supplier<DataComponentType<UUID>> tagname) {
        stack.set(tagname, (Object)id);
    }

    public UUID getUUID(ItemStack stack, Supplier<DataComponentType<UUID>> tagname) {
        return stack.has(tagname) ? (UUID)stack.get(tagname) : null;
    }

    public void removeUUID(ItemStack stack, Supplier<DataComponentType<UUID>> tagname) {
        stack.remove(tagname);
    }
}

