/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.item;

import androsa.gaiadimension.entity.MookaiteConstruct;
import androsa.gaiadimension.entity.OpaliteContruct;
import androsa.gaiadimension.entity.data.MookaitePartType;
import androsa.gaiadimension.registry.registration.ModDataComponents;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ConstructKitItem
extends Item {
    private final Kit kit;
    private final Color partColor;

    public ConstructKitItem(Item.Properties props, Kit kit) {
        this(props, kit, null);
    }

    public ConstructKitItem(Item.Properties props, Kit kit, Color color) {
        super(props);
        this.kit = kit;
        this.partColor = color;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        super.appendHoverText(stack, context, components, flag);
        components.add((Component)Component.translatable((String)("gaiadimension.construct_kit." + this.kit.getName())).withStyle(ChatFormatting.GRAY));
        if (this.kit.canCycleParts() && stack.has(ModDataComponents.KIT_PART)) {
            components.add((Component)Component.translatable((String)"gaiadimension.construct_kit.part").withStyle(ChatFormatting.GRAY).append(CommonComponents.SPACE).append(ConstructKitItem.getPart((Part)((Object)stack.get(ModDataComponents.KIT_PART)))));
            components.add((Component)Component.translatable((String)"gaiaidmension.construct_kit.part.instruction").withStyle(ChatFormatting.DARK_GRAY));
        }
        if (this.partColor != null) {
            components.add((Component)Component.translatable((String)"gaiadimension.construct_kit.color").withStyle(ChatFormatting.GRAY).append(CommonComponents.SPACE).append(ConstructKitItem.getColor(this.partColor)));
        }
    }

    private static Component getPart(Part part) {
        return Component.translatable((String)("gaiadimension.construct_kit.part." + part.getPart().name())).withStyle(style -> style.withColor(8755711));
    }

    private static Component getColor(Color part) {
        return Component.translatable((String)("gaiadimension.construct_kit.color." + part.getPartColor().getSerializedName())).withStyle(style -> style.withColor(part.getColor()));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.kit.canCycleParts() && player.isSecondaryUseActive()) {
            if (!stack.has(ModDataComponents.KIT_PART)) {
                stack.set(ModDataComponents.KIT_PART, (Object)Part.LEFT_HORN);
            } else {
                int maxSize = Part.values().length - 1;
                int next = ((Part)((Object)stack.get(ModDataComponents.KIT_PART))).getId() + 1;
                if (next > maxSize) {
                    next = 0;
                }
                if (next < 0) {
                    next = maxSize;
                }
                stack.set(ModDataComponents.KIT_PART, (Object)Part.byId(next));
                player.displayClientMessage((Component)Component.translatable((String)"gaiadimension.construct_kit.part.swap").append(CommonComponents.SPACE).append(ConstructKitItem.getPart((Part)((Object)stack.get(ModDataComponents.KIT_PART)))), true);
            }
            return InteractionResult.SUCCESS.heldItemTransformedTo(stack);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (this.kit != Kit.BLANK && entity.isAlive() && entity instanceof OpaliteContruct) {
            OpaliteContruct opalite = (OpaliteContruct)entity;
            if (!entity.level().isClientSide()) {
                if (opalite.getMookaiteCompanion() == null) {
                    return this.fail(player, Error.NO_BOND);
                }
                if (opalite.getFollowing() == null) {
                    return this.fail(player, Error.FOLLOWER);
                }
                if (!opalite.getKitData().isEmpty()) {
                    return this.fail(player, Error.IN_USE);
                }
                Part part = (Part)((Object)stack.get(ModDataComponents.KIT_PART));
                if (part == null) {
                    return this.fail(player, Error.NO_PART);
                }
                if (!opalite.validateStacks(this.kit, this.partColor)) {
                    return this.fail(player, Error.RESOURCES);
                }
                if (!opalite.validateKit(this.kit, part, this.partColor)) {
                    return this.fail(player, Error.INCOMPATIBLE);
                }
                if (!opalite.validateActivity()) {
                    return this.fail(player, Error.IN_COMBAT);
                }
                opalite.writeKitData(this.kit, part, this.partColor);
                stack.shrink(1);
                return InteractionResult.SUCCESS_SERVER;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult fail(Player player, Error failure) {
        player.displayClientMessage(failure.getLangKey(), true);
        return InteractionResult.FAIL;
    }

    public static enum Kit {
        BLANK("blank", false),
        REPAIR("repair", true),
        AUGMENT("augment", true),
        REPLACE("replace", true);

        private final String name;
        private final boolean cycleParts;

        private Kit(String name, boolean cycle) {
            this.name = name;
            this.cycleParts = cycle;
        }

        public String getName() {
            return this.name;
        }

        public boolean canCycleParts() {
            return this.cycleParts;
        }
    }

    public static enum Color {
        SCARLET(13119795, MookaitePartType.SCARLET),
        AUBURN(12670727, MookaitePartType.AUBURN),
        GOLD(13538609, MookaitePartType.GOLD),
        MAUVE(0x905090, MookaitePartType.MAUVE),
        BEIGE(13415315, MookaitePartType.BEIGE),
        IVORY(14082809, MookaitePartType.IVORY);

        private final int color;
        private final MookaitePartType part;

        private Color(int color, MookaitePartType part) {
            this.color = color;
            this.part = part;
        }

        public int getColor() {
            return this.color;
        }

        public MookaitePartType getPartColor() {
            return this.part;
        }
    }

    public static enum Part implements StringRepresentable
    {
        LEFT_HORN(0, () -> MookaiteConstruct.LEFT_HORN),
        RIGHT_HORN(1, () -> MookaiteConstruct.RIGHT_HORN),
        LEFT_EYE(2, () -> MookaiteConstruct.LEFT_EYE),
        RIGHT_EYE(3, () -> MookaiteConstruct.RIGHT_EYE),
        LEFT_SHOULDER(4, () -> MookaiteConstruct.LEFT_SHOULDER),
        RIGHT_SHOULDER(5, () -> MookaiteConstruct.RIGHT_SHOULDER),
        LEFT_ARM(6, () -> MookaiteConstruct.LEFT_ARM),
        RIGHT_ARM(7, () -> MookaiteConstruct.RIGHT_ARM),
        LEFT_LEG(8, () -> MookaiteConstruct.LEFT_LEG),
        RIGHT_LEG(9, () -> MookaiteConstruct.RIGHT_LEG);

        private static final IntFunction<Part> ID;
        public static final Codec<Part> CODEC;
        public static final StreamCodec<ByteBuf, Part> STREAM_CODEC;
        private final int id;
        private final Supplier<MookaiteConstruct.MookaitePart> part;

        private Part(int id, Supplier<MookaiteConstruct.MookaitePart> part) {
            this.id = id;
            this.part = part;
        }

        public MookaiteConstruct.MookaitePart getPart() {
            return this.part.get();
        }

        public int getId() {
            return this.id;
        }

        public static Part byId(int id) {
            return ID.apply(id);
        }

        public String getSerializedName() {
            return this.part.get().name();
        }

        static {
            ID = ByIdMap.continuous(Part::getId, (Object[])Part.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromValues(Part::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(ID, part -> part.id);
        }
    }

    public static enum Error {
        NO_BOND("no_bond"),
        FOLLOWER("follower"),
        IN_USE("in_use"),
        NO_PART("no_part"),
        RESOURCES("resources"),
        INCOMPATIBLE("incompatible"),
        IN_COMBAT("in_combat");

        private final String lang;

        private Error(String lang) {
            this.lang = lang;
        }

        public Component getLangKey() {
            return Component.translatable((String)("gaiadimension.construct_kit.invalid." + this.lang)).withStyle(ChatFormatting.RED);
        }
    }
}

