/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.item;

import androsa.gaiadimension.registry.registration.ModItems;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ScaynyxBucketItem
extends BucketItem {
    public ScaynyxBucketItem(Item.Properties props, Supplier<? extends Fluid> fluid) {
        super(fluid.get(), props);
    }

    public static ItemStack getEmptySuccessItem(ItemStack stack, Player entity) {
        return !entity.getAbilities().instabuild ? new ItemStack((ItemLike)ModItems.scaynyx_bucket.get()) : stack;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult raytraceresult = ScaynyxBucketItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)(this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (raytraceresult.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        if (raytraceresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        BlockPos blockpos = raytraceresult.getBlockPos();
        Direction direction = raytraceresult.getDirection();
        BlockPos blockpos1 = blockpos.relative(direction);
        if (world.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos1, direction, itemstack)) {
            BlockPos blockpos2;
            if (this.content == Fluids.EMPTY) {
                BucketPickup fluid;
                ItemStack fluidstack;
                BlockState fluidblock = world.getBlockState(blockpos);
                Block block = fluidblock.getBlock();
                if (block instanceof BucketPickup && !(fluidstack = (fluid = (BucketPickup)block).pickupBlock(player, (LevelAccessor)world, blockpos, fluidblock)).isEmpty()) {
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    fluid.getPickupSound(fluidblock).ifPresent(event -> player.playSound(event, 1.0f, 1.0f));
                    world.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, blockpos);
                    ItemStack itemstack1 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)fluidstack);
                    if (!world.isClientSide) {
                        CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, fluidstack);
                    }
                    return InteractionResult.SUCCESS.heldItemTransformedTo(itemstack1);
                }
                return InteractionResult.FAIL;
            }
            BlockState blockstate = world.getBlockState(blockpos);
            BlockPos blockPos = blockpos2 = this.canBlockContainFluid(player, world, blockpos, blockstate) ? blockpos : blockpos1;
            if (this.emptyContents(player, world, blockpos2, raytraceresult, itemstack)) {
                this.checkExtraContent(player, world, itemstack, blockpos2);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos2, itemstack);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                ItemStack itemstack1 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)ScaynyxBucketItem.getEmptySuccessItem(itemstack, player));
                return InteractionResult.SUCCESS.heldItemTransformedTo(itemstack1);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public boolean canBlockContainFluid(Player player, Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.getBlock() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.getBlock()).canPlaceLiquid(player, (BlockGetter)worldIn, posIn, blockstate, this.content);
    }
}

