/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.item;

import androsa.gaiadimension.entity.projectile.ThrownPebble;
import androsa.gaiadimension.registry.registration.ModSounds;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SturdyPebbleItem
extends Item {
    public SturdyPebbleItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (!playerIn.isCreative()) {
            itemstack.shrink(1);
        }
        worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), ModSounds.STURDY_PEBBLE_THROW.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (worldIn.random.nextFloat() * 0.4f + 0.8f));
        if (worldIn instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)worldIn;
            Projectile.spawnProjectileFromRotation(ThrownPebble::new, (ServerLevel)server, (ItemStack)itemstack, (LivingEntity)playerIn, (float)0.0f, (float)1.5f, (float)1.0f);
        }
        playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResult.SUCCESS;
    }
}

