/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.model;

import androsa.gaiadimension.entity.data.GuardPhase;
import androsa.gaiadimension.entity.data.ThreeStagePhase;
import androsa.gaiadimension.model.renderstate.MalachiteGuardRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MalachiteGuardModel
extends EntityModel<MalachiteGuardRenderState> {
    public ModelPart head;
    public ModelPart torso;
    public ModelPart upperArmL;
    public ModelPart lowerArmL;
    public ModelPart upperArmR;
    public ModelPart lowerArmR;
    public ModelPart legL;
    public ModelPart legR;
    public ModelPart footL;
    public ModelPart footR;
    private boolean reset;

    public MalachiteGuardModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.torso = root.getChild("torso");
        this.upperArmL = root.getChild("shoulder_left").getChild("upper_arm_left");
        this.lowerArmL = this.upperArmL.getChild("lower_arm_left");
        this.upperArmR = root.getChild("shoulder_right").getChild("upper_arm_right");
        this.lowerArmR = this.upperArmR.getChild("lower_arm_right");
        this.legL = root.getChild("leg_left");
        this.footL = this.legL.getChild("boot_left");
        this.legR = root.getChild("leg_right");
        this.footR = this.legR.getChild("boot_right");
    }

    public static LayerDefinition makeBodyLayer(CubeDeformation scale) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(17, 9).addBox(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, scale), PartPose.offset((float)0.0f, (float)-20.0f, (float)0.0f));
        PartDefinition helmet = head.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(20, 23).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, scale), PartPose.ZERO);
        helmet.addOrReplaceChild("blade_left", CubeListBuilder.create().texOffs(0, 35).addBox(0.0f, -7.0f, 0.0f, 0.0f, 7.0f, 4.0f, scale), PartPose.offsetAndRotation((float)4.1f, (float)-6.0f, (float)0.0f, (float)-1.0471976f, (float)0.0f, (float)0.0f));
        helmet.addOrReplaceChild("blade_right", CubeListBuilder.create().texOffs(8, 35).addBox(0.0f, -7.0f, 0.0f, 0.0f, 7.0f, 4.0f, scale), PartPose.offsetAndRotation((float)-4.1f, (float)-6.0f, (float)0.0f, (float)-1.0471976f, (float)0.0f, (float)0.0f));
        PartDefinition torso = root.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(88, 0).addBox(-6.0f, 0.0f, -2.5f, 12.0f, 6.0f, 5.0f, scale), PartPose.offset((float)0.0f, (float)-16.0f, (float)0.0f));
        torso.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(65, 12).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, scale), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition leftshoulder = root.addOrReplaceChild("shoulder_left", CubeListBuilder.create().texOffs(66, 6).addBox(0.0f, -2.0f, -2.0f, 5.0f, 2.0f, 4.0f, scale), PartPose.offset((float)6.0f, (float)-14.5f, (float)0.0f));
        PartDefinition leftupperarm = leftshoulder.addOrReplaceChild("upper_arm_left", CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale), PartPose.offset((float)2.5f, (float)0.0f, (float)0.0f));
        leftupperarm.addOrReplaceChild("lower_arm_left", CubeListBuilder.create().texOffs(4, 19).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, scale), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition rightshoulder = root.addOrReplaceChild("shoulder_right", CubeListBuilder.create().texOffs(70, 0).addBox(-5.0f, -2.0f, -2.0f, 5.0f, 2.0f, 4.0f, scale), PartPose.offset((float)-6.0f, (float)-14.5f, (float)0.0f));
        PartDefinition rightupperarm = rightshoulder.addOrReplaceChild("upper_arm_right", CubeListBuilder.create().texOffs(99, 11).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale), PartPose.offset((float)-2.5f, (float)0.0f, (float)0.0f));
        rightupperarm.addOrReplaceChild("lower_arm_right", CubeListBuilder.create().texOffs(107, 11).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, scale), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        root.addOrReplaceChild("waist", CubeListBuilder.create().texOffs(58, 0).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 5.0f, 2.0f, scale), PartPose.offset((float)0.0f, (float)-10.0f, (float)0.0f));
        root.addOrReplaceChild("hips", CubeListBuilder.create().texOffs(24, 0).addBox(-6.0f, 0.0f, -2.5f, 12.0f, 4.0f, 5.0f, scale), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition leftleg = root.addOrReplaceChild("leg_left", CubeListBuilder.create().texOffs(12, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, scale), PartPose.offset((float)4.5f, (float)-1.0f, (float)0.0f));
        leftleg.addOrReplaceChild("boot_left", CubeListBuilder.create().texOffs(79, 11).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 15.0f, 5.0f, scale), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition rightleg = root.addOrReplaceChild("leg_right", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, scale), PartPose.offset((float)-4.5f, (float)-1.0f, (float)0.0f));
        rightleg.addOrReplaceChild("boot_right", CubeListBuilder.create().texOffs(45, 9).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 15.0f, 5.0f, scale), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void setRotateAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }

    public void setupAnim(MalachiteGuardRenderState state) {
        if (state.phase == GuardPhase.DEFENCE) {
            if (this.reset) {
                this.reset = false;
            }
            this.root.y = 0.1f;
            this.setRotateAngle(this.upperArmL, -1.3f, -0.1f, 0.0f);
            this.setRotateAngle(this.upperArmR, -1.3f, 0.1f, 0.0f);
            this.setRotateAngle(this.legL, -0.5f, -0.7f, 0.0f);
            this.setRotateAngle(this.legR, -0.5f, 0.7f, 0.0f);
            this.setRotateAngle(this.footL, 0.5f, 0.0f, 0.0f);
            this.setRotateAngle(this.footR, 0.5f, 0.0f, 0.0f);
            this.setRotateAngle(this.lowerArmL, -1.7f, 0.6f, 0.0f);
            this.setRotateAngle(this.lowerArmR, -1.7f, -0.6f, 0.0f);
        } else if (state.chargePhase == ThreeStagePhase.CHARGE || state.stompPhase == ThreeStagePhase.EXECUTE) {
            if (this.reset) {
                this.reset = false;
            }
            this.root.y = 0.5f;
            this.setRotateAngle(this.head, 0.8f, 0.0f, 0.0f);
            this.setRotateAngle(this.torso, 0.2f, 0.0f, 0.0f);
            this.setRotateAngle(this.upperArmL, -0.8f, -0.4f, 0.0f);
            this.setRotateAngle(this.upperArmR, -0.8f, 0.4f, 0.0f);
            this.setRotateAngle(this.lowerArmL, -1.8f, 0.0f, 0.0f);
            this.setRotateAngle(this.lowerArmR, -1.8f, 0.0f, 0.0f);
            this.setRotateAngle(this.legL, -1.1f, -0.3f, 0.0f);
            this.setRotateAngle(this.legR, -1.1f, 0.3f, 0.0f);
            this.setRotateAngle(this.footL, 1.6f, 0.0f, 0.0f);
            this.setRotateAngle(this.footR, 1.6f, 0.0f, 0.0f);
        } else if (state.chargePhase == ThreeStagePhase.EXECUTE) {
            if (this.reset) {
                this.reset = false;
            }
            this.root.y = 0.1f;
            this.setRotateAngle(this.head, -0.8f, 0.0f, 0.0f);
            this.setRotateAngle(this.torso, -0.1f, 0.0f, 0.0f);
            this.setRotateAngle(this.upperArmL, -3.0f, 0.0f, 0.7f);
            this.setRotateAngle(this.upperArmR, -3.0f, 0.0f, -0.7f);
            this.setRotateAngle(this.lowerArmL, 0.0f, 0.0f, 0.0f);
            this.setRotateAngle(this.lowerArmR, 0.0f, 0.0f, 0.0f);
            this.setRotateAngle(this.legL, 0.0f, 0.0f, -0.3f);
            this.setRotateAngle(this.legR, 0.0f, 0.0f, 0.3f);
            this.setRotateAngle(this.footL, 0.0f, 0.0f, 0.0f);
            this.setRotateAngle(this.footR, 0.0f, 0.0f, 0.0f);
        } else if (state.stompPhase == ThreeStagePhase.CHARGE) {
            if (this.reset) {
                this.reset = false;
            }
            this.setRotateAngle(this.head, -0.3f, 0.0f, 0.0f);
            this.setRotateAngle(this.upperArmL, -2.0f, -0.7f, 0.0f);
            this.setRotateAngle(this.upperArmR, -2.0f, 0.7f, 0.0f);
            this.setRotateAngle(this.lowerArmL, -0.8f, 0.3f, 0.0f);
            this.setRotateAngle(this.lowerArmR, -0.8f, -0.3f, 0.0f);
            this.setRotateAngle(this.legL, -2.0f, -0.5f, 0.0f);
            this.setRotateAngle(this.footL, 2.0f, 0.0f, 0.0f);
            this.setRotateAngle(this.legR, -0.2f, 0.5f, 0.0f);
            this.setRotateAngle(this.footR, 0.2f, 0.0f, 0.0f);
        } else {
            this.root.y = 0.0f;
            if (!this.reset) {
                this.resetAngles(this.head, this.torso, this.upperArmL, this.upperArmR, this.legL, this.legR, this.footL, this.footR, this.lowerArmL, this.lowerArmR);
                this.reset = true;
            }
            this.upperArmR.zRot = 0.0f;
            this.upperArmL.zRot = 0.0f;
            this.upperArmR.xRot = 0.0f;
            this.upperArmL.xRot = 0.0f;
            this.upperArmR.zRot += Mth.cos((float)(state.ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.upperArmL.zRot -= Mth.cos((float)(state.ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.upperArmR.xRot += Mth.sin((float)(state.ageInTicks * 0.067f)) * 0.05f;
            this.upperArmL.xRot -= Mth.sin((float)(state.ageInTicks * 0.067f)) * 0.05f;
            this.upperArmL.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 0.5f * state.walkAnimationSpeed;
            this.upperArmR.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 0.5f * state.walkAnimationSpeed;
            this.legR.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 0.5f * state.walkAnimationSpeed;
            this.legL.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 0.5f * state.walkAnimationSpeed;
            this.head.yRot = state.yRot / 57.295776f;
            this.head.xRot = state.xRot / 57.295776f;
        }
    }

    private void resetAngles(ModelPart ... renderers) {
        for (ModelPart part : renderers) {
            this.setRotateAngle(part, 0.0f, 0.0f, 0.0f);
        }
    }
}

