/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.model;

import androsa.gaiadimension.model.renderstate.MookaiteConstructRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MookaiteConstructModel
extends EntityModel<MookaiteConstructRenderState> {
    private final ModelPart head;
    private final ModelPart torso;
    private final ModelPart right_arm_upper;
    private final ModelPart left_arm_upper;
    private final ModelPart right_leg_upper;
    private final ModelPart left_leg_upper;
    private final ModelPart right_horn;
    private final ModelPart left_horn;
    private final ModelPart right_eye;
    private final ModelPart left_eye;
    private final ModelPart right_shoulder;
    private final ModelPart left_shoulder;
    private final ModelPart right_arm_brace;
    private final ModelPart left_arm_brace;
    private final ModelPart right_leg_brace;
    private final ModelPart left_leg_brace;

    public MookaiteConstructModel(ModelPart root) {
        super(root);
        ModelPart body = root.getChild("body");
        this.torso = body.getChild("torso");
        this.head = this.torso.getChild("neck").getChild("head");
        this.right_arm_upper = this.torso.getChild("right_arm_upper");
        this.left_arm_upper = this.torso.getChild("left_arm_upper");
        this.right_leg_upper = root.getChild("right_leg_upper");
        this.left_leg_upper = root.getChild("left_leg_upper");
        this.right_horn = this.head.getChild("right_ear").getChild("right_horn");
        this.left_horn = this.head.getChild("left_ear").getChild("left_horn");
        this.right_eye = this.head.getChild("right_eye");
        this.left_eye = this.head.getChild("left_eye");
        this.right_shoulder = this.right_arm_upper.getChild("right_shoulder");
        this.left_shoulder = this.left_arm_upper.getChild("left_shoulder");
        this.right_arm_brace = this.right_arm_upper.getChild("right_arm_lower").getChild("right_arm_brace");
        this.left_arm_brace = this.left_arm_upper.getChild("left_arm_lower").getChild("left_arm_brace");
        this.right_leg_brace = this.right_leg_upper.getChild("right_leg_lower").getChild("right_leg_brace");
        this.left_leg_brace = this.left_leg_upper.getChild("left_leg_lower").getChild("left_leg_brace");
    }

    public static LayerDefinition makeBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-10.5f, (float)0.0f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, -7.0f, -4.8042f, 20.0f, 7.0f, 8.0f), PartPose.offset((float)0.0f, (float)3.5f, (float)0.0f));
        PartDefinition neck = torso.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(73, 76).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-3.5f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(40, 66).addBox(-3.0f, -6.4183f, -2.9959f, 6.0f, 7.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)-0.7418f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(0, 54).addBox(-1.5f, -1.5f, -1.0f, 3.0f, 3.0f, 2.0f), PartPose.offset((float)-2.5f, (float)-2.9183f, (float)-2.9959f));
        head.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(40, 33).addBox(-1.5f, -1.5f, -1.0f, 3.0f, 3.0f, 2.0f), PartPose.offset((float)2.5f, (float)-2.9183f, (float)-2.9959f));
        head.addOrReplaceChild("chin", CubeListBuilder.create().texOffs(27, 15).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.5817f, (float)-1.9959f));
        head.addOrReplaceChild("sail", CubeListBuilder.create().texOffs(53, 71).addBox(-0.5f, -8.0f, 0.0f, 1.0f, 8.0f, 5.0f), PartPose.offset((float)0.0f, (float)-2.4183f, (float)-2.4959f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(28, 76).addBox(-3.0f, -6.0f, -0.5f, 3.0f, 6.0f, 2.0f), PartPose.offset((float)-2.0f, (float)-2.4183f, (float)-0.9959f));
        right_ear.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(65, 76).addBox(-2.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.offset((float)-3.0f, (float)-2.0f, (float)0.5f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(28, 47).addBox(0.0f, -6.0f, -0.5f, 3.0f, 6.0f, 2.0f), PartPose.offset((float)2.0f, (float)-2.4183f, (float)-0.9959f));
        left_ear.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(38, 76).addBox(0.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.offset((float)3.0f, (float)-2.0f, (float)0.5f));
        torso.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(17, 47).addBox(-0.5f, -9.0f, 0.0f, 1.0f, 9.0f, 9.0f), PartPose.offset((float)-4.5f, (float)-2.0f, (float)0.0f));
        torso.addOrReplaceChild("left_fin", CubeListBuilder.create().texOffs(38, 38).addBox(-0.5f, -9.0f, 0.0f, 1.0f, 9.0f, 9.0f), PartPose.offset((float)4.5f, (float)-2.0f, (float)0.0f));
        body.addOrReplaceChild("lower_torso", CubeListBuilder.create().texOffs(20, 65).addBox(-3.0f, 0.0f, -2.3042f, 6.0f, 7.0f, 4.0f), PartPose.offset((float)0.0f, (float)3.5f, (float)-0.5f));
        body.addOrReplaceChild("torso_shell_1", CubeListBuilder.create().texOffs(37, 58).addBox(-4.0f, -1.0f, -2.8042f, 8.0f, 2.0f, 6.0f), PartPose.offset((float)0.0f, (float)5.5f, (float)-1.0f));
        body.addOrReplaceChild("torso_shell_2", CubeListBuilder.create().texOffs(52, 50).addBox(-4.0f, -1.0f, -4.8042f, 8.0f, 2.0f, 6.0f), PartPose.offset((float)0.0f, (float)8.5f, (float)1.0f));
        body.addOrReplaceChild("torso_shell_3", CubeListBuilder.create().texOffs(48, 0).addBox(-4.0f, -1.0f, -4.8042f, 8.0f, 2.0f, 6.0f), PartPose.offset((float)0.0f, (float)11.5f, (float)1.0f));
        body.addOrReplaceChild("waist", CubeListBuilder.create().texOffs(72, 27).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 3.0f, 4.0f), PartPose.offset((float)0.0f, (float)12.5f, (float)0.5f));
        body.addOrReplaceChild("hip", CubeListBuilder.create().texOffs(0, 15).addBox(-5.0f, -2.0f, -3.5f, 10.0f, 4.0f, 7.0f), PartPose.offset((float)0.0f, (float)17.5f, (float)-0.5f));
        PartDefinition right_arm_upper = torso.addOrReplaceChild("right_arm_upper", CubeListBuilder.create().texOffs(20, 76).addBox(-2.0f, 0.1958f, -1.0f, 2.0f, 10.0f, 2.0f), PartPose.offsetAndRotation((float)-10.0f, (float)-5.0f, (float)-1.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        right_arm_upper.addOrReplaceChild("right_shoulder", CubeListBuilder.create().texOffs(27, 19).addBox(-7.0f, -3.4021f, -3.3941f, 7.0f, 7.0f, 7.0f), PartPose.offsetAndRotation((float)1.0f, (float)-1.5f, (float)0.5f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm_lower = right_arm_upper.addOrReplaceChild("right_arm_lower", CubeListBuilder.create().texOffs(76, 0).addBox(-0.5f, 0.0f, -1.5f, 3.0f, 11.0f, 3.0f), PartPose.offsetAndRotation((float)-1.0f, (float)10.0f, (float)1.0f, (float)-1.5708f, (float)1.0036f, (float)-1.5708f));
        right_arm_lower.addOrReplaceChild("right_arm_brace", CubeListBuilder.create().texOffs(51, 10).addBox(-3.0f, -5.0f, -2.5f, 6.0f, 10.0f, 5.0f), PartPose.offset((float)1.0f, (float)6.5f, (float)0.0f));
        right_arm_lower.addOrReplaceChild("right_finger_1", CubeListBuilder.create().texOffs(21, 26).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)-0.5f, (float)11.5f, (float)-1.0f));
        right_arm_lower.addOrReplaceChild("right_finger_2", CubeListBuilder.create().texOffs(0, 26).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)1.0f, (float)11.5f, (float)-1.0f));
        right_arm_lower.addOrReplaceChild("right_finger_3", CubeListBuilder.create().texOffs(3, 18).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)2.5f, (float)11.5f, (float)-1.0f));
        right_arm_lower.addOrReplaceChild("right_thumb", CubeListBuilder.create().texOffs(27, 18).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)2.5f, (float)11.5f, (float)1.5f));
        PartDefinition left_arm_upper = torso.addOrReplaceChild("left_arm_upper", CubeListBuilder.create().texOffs(12, 75).addBox(0.0f, 0.1958f, -1.0f, 2.0f, 10.0f, 2.0f), PartPose.offsetAndRotation((float)10.0f, (float)-5.0f, (float)-1.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        left_arm_upper.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(0, 26).addBox(0.0f, -3.4021f, -3.3941f, 7.0f, 7.0f, 7.0f), PartPose.offsetAndRotation((float)-1.0f, (float)-1.5f, (float)0.5f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm_lower = left_arm_upper.addOrReplaceChild("left_arm_lower", CubeListBuilder.create().texOffs(0, 75).addBox(-2.5f, 0.0f, -1.5f, 3.0f, 11.0f, 3.0f), PartPose.offsetAndRotation((float)1.0f, (float)10.0f, (float)1.0f, (float)-1.5708f, (float)-1.0105f, (float)1.5708f));
        left_arm_lower.addOrReplaceChild("left_arm_brace", CubeListBuilder.create().texOffs(50, 28).addBox(-3.0f, -5.0f, -2.5f, 6.0f, 10.0f, 5.0f), PartPose.offset((float)-1.0f, (float)6.5f, (float)0.0f));
        left_arm_lower.addOrReplaceChild("left_finger_1", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)0.5f, (float)11.5f, (float)-1.0f));
        left_arm_lower.addOrReplaceChild("left_finger_2", CubeListBuilder.create().texOffs(3, 3).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)-1.0f, (float)11.5f, (float)-1.0f));
        left_arm_lower.addOrReplaceChild("left_finger_3", CubeListBuilder.create().texOffs(0, 15).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)-2.5f, (float)11.5f, (float)-1.0f));
        left_arm_lower.addOrReplaceChild("left_thumb", CubeListBuilder.create().texOffs(4, 0).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)-2.5f, (float)11.5f, (float)1.5f));
        PartDefinition right_leg_upper = root.addOrReplaceChild("right_leg_upper", CubeListBuilder.create().texOffs(75, 58).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.offset((float)-4.0f, (float)9.0f, (float)-0.5f));
        PartDefinition right_leg_lower = right_leg_upper.addOrReplaceChild("right_leg_lower", CubeListBuilder.create().texOffs(60, 61).addBox(-2.5f, 0.0f, -1.0f, 5.0f, 10.0f, 5.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)-1.5f));
        right_leg_lower.addOrReplaceChild("right_leg_brace", CubeListBuilder.create().texOffs(0, 40).addBox(-3.0f, -3.5f, -3.5f, 6.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)1.5f));
        right_leg_lower.addOrReplaceChild("right_foot", CubeListBuilder.create().texOffs(65, 17).addBox(-2.0f, -1.0f, -4.0f, 4.0f, 2.0f, 8.0f), PartPose.offset((float)0.0f, (float)9.5f, (float)1.5f));
        PartDefinition left_leg_upper = root.addOrReplaceChild("left_leg_upper", CubeListBuilder.create().texOffs(74, 45).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.offset((float)4.0f, (float)9.0f, (float)-0.5f));
        PartDefinition left_leg_lower = left_leg_upper.addOrReplaceChild("left_leg_lower", CubeListBuilder.create().texOffs(0, 60).addBox(-2.5f, 0.0f, -1.0f, 5.0f, 10.0f, 5.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)-1.5f));
        left_leg_lower.addOrReplaceChild("left_leg_brace", CubeListBuilder.create().texOffs(21, 33).addBox(-3.0f, -3.5f, -3.5f, 6.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)1.5f));
        left_leg_lower.addOrReplaceChild("left_foot", CubeListBuilder.create().texOffs(64, 35).addBox(-2.0f, -1.0f, -4.0f, 4.0f, 2.0f, 8.0f), PartPose.offset((float)0.0f, (float)9.5f, (float)1.5f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)96, (int)96);
    }

    public void setupAnim(MookaiteConstructRenderState state) {
        this.right_horn.visible = state.rightHorn.isPresent();
        this.left_horn.visible = state.leftHorn.isPresent();
        this.right_eye.visible = state.rightEye.isPresent();
        this.left_eye.visible = state.leftEye.isPresent();
        this.right_shoulder.visible = state.rightShoulder.isPresent();
        this.left_shoulder.visible = state.leftShoulder.isPresent();
        this.right_arm_brace.visible = state.rightArmBrace.isPresent();
        this.left_arm_brace.visible = state.leftArmBrace.isPresent();
        this.right_leg_brace.visible = state.rightLegBrace.isPresent();
        this.left_leg_brace.visible = state.leftLegBrace.isPresent();
        this.torso.yRot = state.yRot / 85.943665f;
        this.head.xRot = state.xRot / 57.295776f - 0.7418f;
        this.right_arm_upper.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 1.0f * state.walkAnimationSpeed + 0.2182f;
        this.left_arm_upper.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.0f * state.walkAnimationSpeed + 0.2182f;
        this.right_leg_upper.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 0.7f * state.walkAnimationSpeed;
        this.left_leg_upper.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 0.7f * state.walkAnimationSpeed;
    }
}

