/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.model;

import androsa.gaiadimension.model.renderstate.OpaliteConstructRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class OpaliteConstructModel
extends EntityModel<OpaliteConstructRenderState> {
    private final ModelPart head;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public OpaliteConstructModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition makeBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(31, 14).addBox(-3.0f, -6.0f, -2.5f, 6.0f, 6.0f, 5.0f), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -5.5f, -4.0f, 10.0f, 11.0f, 8.0f), PartPose.offset((float)0.0f, (float)12.5f, (float)0.0f));
        body.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(0, 19).addBox(-5.5f, -0.5f, 0.0f, 11.0f, 11.0f, 4.0f), PartPose.offset((float)0.0f, (float)-5.5f, (float)1.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 34).addBox(-4.0f, 0.0f, -2.5f, 4.0f, 11.0f, 5.0f), PartPose.offset((float)-5.0f, (float)8.0f, (float)0.0f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(25, 29).addBox(0.0f, 0.0f, -2.5f, 4.0f, 11.0f, 5.0f), PartPose.offset((float)5.0f, (float)8.0f, (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(37, 39).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 6.0f, 6.0f), PartPose.offset((float)-2.5f, (float)18.0f, (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(36, 0).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 6.0f, 6.0f), PartPose.offset((float)2.5f, (float)18.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(OpaliteConstructRenderState state) {
        this.head.yRot = state.yRot / 57.295776f;
        this.head.xRot = state.xRot / 57.295776f;
        this.right_arm.zRot = 0.0f;
        this.left_arm.zRot = 0.0f;
        this.right_arm.zRot += Mth.cos((float)(state.ageInTicks * 0.09f)) * 0.05f;
        this.left_arm.zRot -= Mth.cos((float)(state.ageInTicks * 0.09f)) * 0.05f;
        if (state.isConstructing) {
            this.right_arm.xRot = -2.0f;
            this.left_arm.xRot = -2.0f;
        } else {
            this.right_arm.xRot = 0.0f;
            this.left_arm.xRot = 0.0f;
            this.right_arm.xRot += Mth.sin((float)(state.ageInTicks * 0.067f)) * 0.05f;
            this.left_arm.xRot -= Mth.sin((float)(state.ageInTicks * 0.067f)) * 0.05f;
            this.left_arm.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 1.0f * state.walkAnimationSpeed;
            this.right_arm.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.0f * state.walkAnimationSpeed;
        }
        this.left_leg.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 0.5f * state.walkAnimationSpeed;
        this.right_leg.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 0.5f * state.walkAnimationSpeed;
    }
}

