/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;

public class PrimalBeastModel
extends EntityModel<LivingEntityRenderState> {
    public ModelPart root;
    public ModelPart head;
    public ModelPart armL;
    public ModelPart armR;
    public ModelPart fingersL;
    public ModelPart fingersR;
    public ModelPart legL;
    public ModelPart legR;
    public ModelPart tailtop;
    public ModelPart tailBottom;

    public PrimalBeastModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        ModelPart torso = root.getChild("torso");
        this.armL = torso.getChild("arm_left");
        this.fingersL = this.armL.getChild("forearm_left").getChild("fingers_left");
        this.armR = torso.getChild("arm_right");
        this.fingersR = this.armR.getChild("forearm_right").getChild("fingers_right");
        ModelPart stomach = root.getChild("stomach");
        this.legL = stomach.getChild("leg_left");
        this.legR = stomach.getChild("leg_right");
        this.tailtop = stomach.getChild("tail_segment_top");
        this.tailBottom = this.tailtop.getChild("tail_segment_bottom");
    }

    public static LayerDefinition makeBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(34, 16).addBox(-4.0f, -7.8f, -6.0f, 8.0f, 9.0f, 6.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)-3.0f));
        PartDefinition torso = root.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-6.5f, 0.0f, -3.5f, 13.0f, 11.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)-3.5f, (float)0.4886922f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = torso.addOrReplaceChild("arm_left", CubeListBuilder.create().texOffs(73, 11).addBox(0.0f, 0.0f, -2.5f, 5.0f, 13.0f, 5.0f), PartPose.offsetAndRotation((float)6.5f, (float)0.9f, (float)0.0f, (float)-0.33161256f, (float)0.0f, (float)0.0f));
        PartDefinition leftforearm = leftarm.addOrReplaceChild("forearm_left", CubeListBuilder.create().texOffs(57, 26).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 13.0f, 5.0f), PartPose.offsetAndRotation((float)2.4f, (float)11.5f, (float)0.4f, (float)-0.61086524f, (float)0.0f, (float)0.0f));
        leftforearm.addOrReplaceChild("fingers_left", CubeListBuilder.create().texOffs(78, 0).addBox(0.0f, 0.0f, -2.4f, 2.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)0.5f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.31415927f));
        PartDefinition rightarm = torso.addOrReplaceChild("arm_right", CubeListBuilder.create().texOffs(0, 18).addBox(-5.0f, 0.0f, -2.5f, 5.0f, 13.0f, 5.0f), PartPose.offsetAndRotation((float)-6.5f, (float)0.9f, (float)0.0f, (float)-0.33161256f, (float)0.0f, (float)0.0f));
        PartDefinition rightforearm = rightarm.addOrReplaceChild("forearm_right", CubeListBuilder.create().texOffs(15, 31).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 13.0f, 5.0f), PartPose.offsetAndRotation((float)-2.4f, (float)11.5f, (float)0.4f, (float)-0.61086524f, (float)0.0f, (float)0.0f));
        rightforearm.addOrReplaceChild("fingers_right", CubeListBuilder.create().texOffs(20, 18).addBox(0.0f, 0.0f, -2.4f, 2.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)-2.5f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.31415927f));
        PartDefinition stomach = root.addOrReplaceChild("stomach", CubeListBuilder.create().texOffs(40, 0).addBox(-6.0f, 0.0f, 0.0f, 12.0f, 9.0f, 7.0f), PartPose.offset((float)0.0f, (float)3.0f, (float)-2.2f));
        stomach.addOrReplaceChild("leg_left", CubeListBuilder.create().texOffs(35, 38).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.offset((float)3.1f, (float)8.0f, (float)3.5f));
        stomach.addOrReplaceChild("leg_right", CubeListBuilder.create().texOffs(71, 38).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.offset((float)-2.9f, (float)8.0f, (float)3.5f));
        PartDefinition tail = stomach.addOrReplaceChild("tail_segment_top", CubeListBuilder.create().texOffs(49, 47).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)7.0f, (float)-0.5934119f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("tail_segment_bottom", CubeListBuilder.create().texOffs(0, 40).addBox(-1.5f, -2.0f, 0.0f, 3.0f, 2.0f, 9.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.6f, (float)9.4f, (float)0.33161256f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)96, (int)64);
    }

    public void setupAnim(LivingEntityRenderState state) {
        this.head.yRot = state.yRot / 57.295776f;
        this.head.xRot = state.xRot / 57.295776f;
        this.armR.zRot = 0.0f;
        this.armL.zRot = 0.0f;
        this.armR.xRot = -0.33161256f;
        this.armL.xRot = -0.33161256f;
        this.armR.zRot += Mth.cos((float)(state.ageInTicks * 0.09f)) * 0.05f + 0.15f;
        this.armL.zRot -= Mth.cos((float)(state.ageInTicks * 0.09f)) * 0.05f + 0.15f;
        this.armR.xRot += Mth.sin((float)(state.ageInTicks * 0.067f)) * 0.05f;
        this.armL.xRot -= Mth.sin((float)(state.ageInTicks * 0.067f)) * 0.05f;
        this.armL.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 1.0f * state.walkAnimationSpeed - 0.33161256f;
        this.armR.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.0f * state.walkAnimationSpeed - 0.33161256f;
        this.fingersL.zRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.025f)) * 0.15f + 0.3f;
        this.fingersR.zRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.025f)) * -0.15f - 0.3f;
        this.legL.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 0.5f * state.walkAnimationSpeed;
        this.legR.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 0.5f * state.walkAnimationSpeed;
        this.tailtop.yRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 0.5f * state.walkAnimationSpeed * 0.5f;
        this.tailtop.yRot -= Mth.sin((float)(state.ageInTicks * 0.067f)) * 0.05f;
        this.tailBottom.yRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 0.5f * state.walkAnimationSpeed * 0.5f;
        this.tailBottom.yRot -= Mth.sin((float)(state.ageInTicks * 0.067f)) * 0.05f;
    }
}

