/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;

public class SaltionModel
extends EntityModel<LivingEntityRenderState> {
    public ModelPart head;
    public ModelPart armL;
    public ModelPart armR;
    public ModelPart legL1;
    public ModelPart legL2;
    public ModelPart legL3;
    public ModelPart legR1;
    public ModelPart legR2;
    public ModelPart legR3;
    public ModelPart tail1;
    public ModelPart tail2;
    public ModelPart tail3;
    public ModelPart bulb;

    public SaltionModel(ModelPart root) {
        super(root);
        ModelPart body = root.getChild("body");
        this.head = body.getChild("head");
        this.armL = body.getChild("arm_left");
        this.armR = body.getChild("arm_right");
        this.legL1 = body.getChild("leg_front_left");
        this.legL2 = body.getChild("leg_mid_left");
        this.legL3 = body.getChild("leg_back_left");
        this.legR1 = body.getChild("leg_front_right");
        this.legR2 = body.getChild("leg_mid_right");
        this.legR3 = body.getChild("leg_back_right");
        this.tail1 = body.getChild("tail_segment_1");
        this.tail2 = this.tail1.getChild("tail_segment_2");
        this.tail3 = this.tail2.getChild("tail_segment_3");
        this.bulb = this.tail3.getChild("bulb");
    }

    public static LayerDefinition makeBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -1.5f, 0.0f, 5.0f, 3.0f, 10.0f), PartPose.offset((float)0.0f, (float)21.0f, (float)-4.0f));
        body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(41, 12).addBox(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.3f, (float)1.1f));
        body.addOrReplaceChild("leg_front_left", CubeListBuilder.create().texOffs(20, 0).addBox(-6.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)0.6f, (float)2.8f, (float)0.0f, (float)0.13962634f, (float)-0.34906584f));
        body.addOrReplaceChild("leg_mid_left", CubeListBuilder.create().texOffs(36, 0).addBox(-6.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)0.6f, (float)5.8f, (float)0.0f, (float)0.17453292f, (float)-0.34906584f));
        body.addOrReplaceChild("leg_back_left", CubeListBuilder.create().texOffs(20, 4).addBox(-6.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)0.6f, (float)8.8f, (float)0.0f, (float)0.20943952f, (float)-0.34906584f));
        body.addOrReplaceChild("leg_front_right", CubeListBuilder.create().texOffs(36, 4).addBox(0.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)0.6f, (float)2.8f, (float)0.0f, (float)-0.13962634f, (float)0.34906584f));
        body.addOrReplaceChild("leg_mid_right", CubeListBuilder.create().texOffs(30, 8).addBox(0.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)0.6f, (float)5.8f, (float)0.0f, (float)-0.17453292f, (float)0.34906584f));
        body.addOrReplaceChild("leg_back_right", CubeListBuilder.create().texOffs(46, 8).addBox(0.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)0.6f, (float)8.8f, (float)0.0f, (float)-0.20943952f, (float)0.34906584f));
        PartDefinition leftarm = body.addOrReplaceChild("arm_left", CubeListBuilder.create().texOffs(14, 14).addBox(-1.0f, -1.0f, -5.0f, 2.0f, 2.0f, 5.0f), PartPose.offsetAndRotation((float)2.0f, (float)1.0f, (float)0.8f, (float)0.0f, (float)-0.83775806f, (float)0.0f));
        PartDefinition leftpincer = leftarm.addOrReplaceChild("pincer_left", CubeListBuilder.create().texOffs(0, 27).addBox(-8.0f, -1.0f, -2.0f, 8.0f, 2.0f, 3.0f), PartPose.offsetAndRotation((float)1.0f, (float)-0.1f, (float)-5.2f, (float)0.0f, (float)-0.34906584f, (float)0.0f));
        leftpincer.addOrReplaceChild("claw_left", CubeListBuilder.create().texOffs(47, 18).addBox(-4.0f, -0.5f, -1.0f, 4.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2617994f, (float)0.0f));
        PartDefinition rightarm = body.addOrReplaceChild("arm_right", CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, -1.0f, -5.0f, 2.0f, 2.0f, 5.0f), PartPose.offsetAndRotation((float)-2.0f, (float)1.0f, (float)0.8f, (float)0.0f, (float)0.83775806f, (float)0.0f));
        PartDefinition rightpincer = rightarm.addOrReplaceChild("pincer_right", CubeListBuilder.create().texOffs(25, 25).addBox(0.0f, -1.0f, -2.0f, 8.0f, 2.0f, 3.0f), PartPose.offsetAndRotation((float)-1.0f, (float)-0.1f, (float)-5.2f, (float)0.0f, (float)0.34906584f, (float)0.0f));
        rightpincer.addOrReplaceChild("claw_right", CubeListBuilder.create().texOffs(50, 2).addBox(0.0f, -0.5f, -1.0f, 4.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2617994f, (float)0.0f));
        PartDefinition tail1 = body.addOrReplaceChild("tail_segment_1", CubeListBuilder.create().texOffs(25, 12).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 2.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)8.6f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail_segment_2", CubeListBuilder.create().texOffs(36, 18).addBox(-1.5f, 0.0f, -0.8f, 3.0f, 2.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.9f, (float)0.95609134f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail_segment_3", CubeListBuilder.create().texOffs(0, 20).addBox(-1.5f, 0.0f, -0.6f, 3.0f, 2.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.1f, (float)0.8651597f, (float)0.0f, (float)0.0f));
        PartDefinition bulb = tail3.addOrReplaceChild("bulb", CubeListBuilder.create().texOffs(16, 21).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)1.1f, (float)4.0f));
        bulb.addOrReplaceChild("stinger", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.8f, (float)2.0f, (float)1.3089969f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)40);
    }

    public void setupAnim(LivingEntityRenderState state) {
        this.head.yRot = state.yRot / 57.295776f;
        this.armR.yRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 0.4f * state.walkAnimationSpeed + 0.83775806f;
        this.armL.yRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 0.4f * state.walkAnimationSpeed - 0.83775806f;
        this.tail1.xRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.05f)) * 0.1f + 0.7853982f;
        this.tail2.xRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.05f)) * 0.1f + 0.95609134f;
        this.tail3.xRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.05f)) * 0.1f + 0.8651597f;
        this.bulb.xRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.05f)) * 0.1f + 0.7853982f;
        float f1 = -(Mth.cos((float)(state.walkAnimationPos * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * state.walkAnimationSpeed;
        float f2 = -(Mth.cos((float)(state.walkAnimationPos * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * state.walkAnimationSpeed;
        float f3 = -(Mth.cos((float)(state.walkAnimationPos * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * state.walkAnimationSpeed;
        float f4 = Math.abs(Mth.sin((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 0.4f) * state.walkAnimationSpeed;
        float f5 = Math.abs(Mth.sin((float)(state.walkAnimationPos * 0.6662f + 1.5707964f)) * 0.4f) * state.walkAnimationSpeed;
        float f6 = Math.abs(Mth.sin((float)(state.walkAnimationPos * 0.6662f + 4.712389f)) * 0.4f) * state.walkAnimationSpeed;
        this.legL1.zRot = -0.34906584f;
        this.legL1.yRot = 0.13962634f;
        this.legL1.yRot += f1;
        this.legL1.zRot += f4;
        this.legR1.zRot = 0.34906584f;
        this.legR1.yRot = -0.13962634f;
        this.legR1.yRot -= f1;
        this.legR1.zRot -= f4;
        this.legL2.zRot = -0.34906584f;
        this.legL2.yRot = 0.17453292f;
        this.legL2.yRot += f2;
        this.legL2.zRot += f5;
        this.legR2.zRot = 0.34906584f;
        this.legR2.yRot = -0.17453292f;
        this.legR2.yRot -= f2;
        this.legR2.zRot -= f5;
        this.legL3.zRot = -0.34906584f;
        this.legL3.yRot = 0.20943952f;
        this.legL3.yRot += f3;
        this.legL3.zRot += f6;
        this.legR3.zRot = 0.34906584f;
        this.legR3.yRot = -0.20943952f;
        this.legR3.yRot -= f3;
        this.legR3.zRot -= f6;
    }
}

