/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.model;

import java.util.Arrays;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.SquidRenderState;
import net.minecraft.util.Mth;

public class ShallowArenthisModel
extends EntityModel<SquidRenderState> {
    public ModelPart[] tentacles = new ModelPart[7];
    public ModelPart body;
    public ModelPart tail;

    public ShallowArenthisModel(ModelPart root) {
        super(root);
        this.body = root.getChild("cap").getChild("head").getChild("body");
        this.tail = this.body.getChild("tail");
        Arrays.setAll(this.tentacles, num -> root.getChild(ShallowArenthisModel.getTentacleName(num)));
    }

    public static LayerDefinition makeBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition cap = root.addOrReplaceChild("cap", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -5.0f, 10.0f, 5.0f, 10.0f), PartPose.ZERO);
        PartDefinition head = cap.addOrReplaceChild("head", CubeListBuilder.create().texOffs(30, 0).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 3.0f, 5.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition body = head.addOrReplaceChild("body", CubeListBuilder.create().texOffs(48, 9).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 15).addBox(-3.5f, 0.0f, 0.0f, 7.0f, 4.0f, 0.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        for (int j = 0; j < 7; ++j) {
            double d0 = (double)j * Math.PI * 2.0 / 7.0;
            float f = (float)Math.cos(d0) * 5.0f;
            float f1 = (float)Math.sin(d0) * 5.0f;
            d0 = (double)j * Math.PI * -2.0 / 7.0 + 1.5707963267948966;
            CubeListBuilder tentaclecube = CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 1.0f, 8.0f, 1.0f);
            root.addOrReplaceChild(ShallowArenthisModel.getTentacleName(j), tentaclecube, PartPose.offsetAndRotation((float)f, (float)5.0f, (float)f1, (float)0.0f, (float)((float)d0), (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public static String getTentacleName(int num) {
        return "tentacle_" + num;
    }

    public void setupAnim(SquidRenderState state) {
        this.body.xRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.025f)) * 0.3f;
        this.tail.xRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.025f)) * 0.3f;
        for (ModelPart modelrenderer : this.tentacles) {
            modelrenderer.xRot = state.tentacleAngle;
        }
    }
}

